/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.SystemProperties;
import android.util.Log;
import dalvik.system.SamplingProfiler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.io.IoUtils;

public class SamplingProfilerIntegration {
    public static final String TAG = "SamplingProfilerIntegration";
    public static final String SNAPSHOT_DIR = "/data/snapshots";
    public static final boolean enabled;
    public static final Executor snapshotWriter;
    public static final int samplingProfilerMilliseconds;
    public static final int samplingProfilerDepth;
    public static final AtomicBoolean pending;
    public static SamplingProfiler INSTANCE;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void start() {
        if (!enabled) {
            return;
        }
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        SamplingProfiler.ThreadSet threadSet = SamplingProfiler.newThreadGroupTheadSet(group);
        INSTANCE = new SamplingProfiler(samplingProfilerDepth, threadSet);
        INSTANCE.start(samplingProfilerMilliseconds);
    }

    public static void writeSnapshot(final String processName, final PackageInfo packageInfo) {
        if (!enabled) {
            return;
        }
        if (pending.compareAndSet(false, true)) {
            snapshotWriter.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        SamplingProfilerIntegration.writeSnapshotFile(processName, packageInfo);
                    }
                    finally {
                        pending.set(false);
                    }
                }
            });
        }
    }

    public static void writeZygoteSnapshot() {
        if (!enabled) {
            return;
        }
        SamplingProfilerIntegration.writeSnapshotFile("zygote", null);
        INSTANCE.shutdown();
        INSTANCE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSnapshotFile(String processName, PackageInfo packageInfo) {
        if (!enabled) {
            return;
        }
        INSTANCE.stop();
        long start = System.currentTimeMillis();
        String name = processName.replaceAll(":", ".");
        String path = "/data/snapshots/" + name + "-" + System.currentTimeMillis() + ".snapshot";
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(path)));
            SamplingProfilerIntegration.generateSnapshotHeader(name, packageInfo, out);
            new SamplingProfiler.AsciiHprofWriter(INSTANCE.getHprofData(), out).write();
            if (out.checkError()) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            try {
                Log.e(TAG, "Error writing snapshot to " + path, e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(out);
                throw throwable;
            }
            IoUtils.closeQuietly(out);
            return;
        }
        IoUtils.closeQuietly(out);
        new File(path).setReadable(true, false);
        long elapsed = System.currentTimeMillis() - start;
        Log.i(TAG, "Wrote snapshot for " + name + " in " + elapsed + "ms.");
    }

    public static void generateSnapshotHeader(String processName, PackageInfo packageInfo, PrintStream out) {
        out.println("Version: 2");
        out.println("Process: " + processName);
        if (packageInfo != null) {
            out.println("Package: " + packageInfo.packageName);
            out.println("Package-Version: " + packageInfo.versionCode);
        }
        out.println("Build: " + Build.FINGERPRINT);
        out.println();
    }

    static {
        pending = new AtomicBoolean(false);
        samplingProfilerMilliseconds = SystemProperties.getInt("persist.sys.profiler_ms", 0);
        samplingProfilerDepth = SystemProperties.getInt("persist.sys.profiler_depth", 4);
        if (samplingProfilerMilliseconds > 0) {
            File dir = new File(SNAPSHOT_DIR);
            dir.mkdirs();
            dir.setWritable(true, false);
            dir.setExecutable(true, false);
            if (dir.isDirectory()) {
                snapshotWriter = Executors.newSingleThreadExecutor(new ThreadFactory(){

                    public Thread newThread(Runnable r) {
                        return new Thread(r, SamplingProfilerIntegration.TAG);
                    }
                });
                enabled = true;
                Log.i(TAG, "Profiling enabled. Sampling interval ms: " + samplingProfilerMilliseconds);
            } else {
                snapshotWriter = null;
                enabled = true;
                Log.w(TAG, "Profiling setup failed. Could not create /data/snapshots");
            }
        } else {
            snapshotWriter = null;
            enabled = false;
            Log.i(TAG, "Profiling disabled.");
        }
    }
}

