/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Message;
import android.util.Log;
import android.util.Patterns;
import com.android.internal.telephony.ApnSetting;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.gsm.GSMPhone;

public class GsmDataConnection
extends DataConnection {
    public static final String LOG_TAG = "GSM";
    public ApnSetting apn;

    public GsmDataConnection(GSMPhone phone, String name, RetryManager rm) {
        super(phone, name, rm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GsmDataConnection makeDataConnection(GSMPhone phone, int id2, RetryManager rm) {
        Object object = mCountLock;
        synchronized (object) {
        }
        GsmDataConnection gsmDc = new GsmDataConnection(phone, "GsmDataConnection-" + ++mCount, rm);
        gsmDc.start();
        gsmDc.log("Made " + gsmDc.getName());
        gsmDc.mId = id2;
        gsmDc.mRetryMgr = rm;
        return gsmDc;
    }

    public void onConnect(DataConnection.ConnectionParams cp) {
        this.apn = cp.apn;
        this.log("Connecting to carrier: '" + this.apn.carrier + "' APN: '" + this.apn.apn + "' proxy: '" + this.apn.proxy + "' port: '" + this.apn.port);
        this.setHttpProxy(this.apn.proxy, this.apn.port);
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = DataConnection.FailCause.NONE;
        Message msg = this.obtainMessage(3, cp);
        msg.obj = cp;
        int authType = this.apn.authType;
        if (authType == -1) {
            authType = this.apn.user != null ? 3 : 0;
        }
        String protocol = this.phone.getServiceState().getRoaming() ? this.apn.roamingProtocol : this.apn.protocol;
        this.phone.mCM.setupDataCall(Integer.toString(1), Integer.toString(0), this.apn.apn, this.apn.user, this.apn.password, Integer.toString(authType), protocol, msg);
    }

    public void clearSettings() {
        super.clearSettings();
        this.apn = null;
    }

    public String toString() {
        return "State=" + this.getCurrentState().getName() + " Apn=" + this.apn + " create=" + this.createTime + " lastFail=" + this.lastFailTime + " lastFailCause=" + (Object)((Object)this.lastFailCause);
    }

    public boolean isDnsOk(String[] domainNameServers) {
        if (!(!"0.0.0.0".equals(domainNameServers[0]) || !"0.0.0.0".equals(domainNameServers[1]) || ((GSMPhone)this.phone).isDnsCheckDisabled() || this.apn.types[0].equals("mms") && this.isIpAddress(this.apn.mmsProxy))) {
            this.log(String.format("isDnsOk: return false apn.types[0]=%s APN_TYPE_MMS=%s isIpAddress(%s)=%s", this.apn.types[0], "mms", this.apn.mmsProxy, this.isIpAddress(this.apn.mmsProxy)));
            return false;
        }
        return true;
    }

    public void log(String s) {
        Log.d(LOG_TAG, "[" + this.getName() + "] " + s);
    }

    public ApnSetting getApn() {
        return this.apn;
    }

    public void setHttpProxy(String httpProxy, String httpPort) {
        if (httpProxy == null || httpProxy.length() == 0) {
            this.phone.setSystemProperty("net.gprs.http-proxy", null);
            return;
        }
        if (httpPort == null || httpPort.length() == 0) {
            httpPort = "8080";
        }
        this.phone.setSystemProperty("net.gprs.http-proxy", "http://" + httpProxy + ":" + httpPort + "/");
    }

    public boolean isIpAddress(String address) {
        if (address == null) {
            return false;
        }
        return Patterns.IP_ADDRESS.matcher(this.apn.mmsProxy).matches();
    }
}

