/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import com.android.internal.util.Predicate;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicates {
    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        return Predicates.and(Arrays.asList(components));
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> components) {
        return new AndPredicate(components, null);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        return Predicates.or(Arrays.asList(components));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> components) {
        return new OrPredicate(components, null);
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return new NotPredicate(predicate, null);
    }

    public static class 1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NotPredicate<T>
    implements Predicate<T> {
        public final Predicate<? super T> predicate;

        public NotPredicate(Predicate<? super T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }

        public /* synthetic */ NotPredicate(Predicate x0, 1 x1) {
            this(x0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrPredicate<T>
    implements Predicate<T> {
        public final Iterable<? extends Predicate<? super T>> components;

        public OrPredicate(Iterable<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ OrPredicate(Iterable x0, 1 x1) {
            this(x0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AndPredicate<T>
    implements Predicate<T> {
        public final Iterable<? extends Predicate<? super T>> components;

        public AndPredicate(Iterable<? extends Predicate<? super T>> components) {
            this.components = components;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ AndPredicate(Iterable x0, 1 x1) {
            this(x0);
        }
    }
}

