/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public class ActionMenuItemView
extends LinearLayout
implements MenuView.ItemView,
View.OnClickListener {
    public static final String TAG = "ActionMenuItemView";
    public MenuItemImpl mItemData;
    public CharSequence mTitle;
    public MenuBuilder.ItemInvoker mItemInvoker;
    public ImageButton mImageButton;
    public Button mTextButton;

    public ActionMenuItemView(Context context) {
        this(context, null);
    }

    public ActionMenuItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ActionMenuItemView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void onFinishInflate() {
        this.mImageButton = (ImageButton)this.findViewById(0x1020200);
        this.mTextButton = (Button)this.findViewById(0x1020201);
        this.mImageButton.setOnClickListener(this);
        this.mTextButton.setOnClickListener(this);
    }

    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    public void initialize(MenuItemImpl itemData, int menuType) {
        this.mItemData = itemData;
        this.setIcon(itemData.getIcon());
        this.setTitle(itemData.getTitleForItemView(this));
        this.setId(itemData.getItemId());
        this.setVisibility(itemData.isVisible() ? 0 : 8);
        this.setEnabled(itemData.isEnabled());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mImageButton.setEnabled(enabled);
        this.mTextButton.setEnabled(enabled);
    }

    public void onClick(View v) {
        if (this.mItemInvoker != null) {
            this.mItemInvoker.invokeItem(this.mItemData);
        }
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker invoker) {
        this.mItemInvoker = invoker;
    }

    public boolean prefersCondensedTitle() {
        return true;
    }

    public void setCheckable(boolean checkable) {
    }

    public void setChecked(boolean checked) {
    }

    public void setIcon(Drawable icon) {
        this.mImageButton.setImageDrawable(icon);
        if (icon != null) {
            this.mImageButton.setVisibility(0);
        } else {
            this.mImageButton.setVisibility(8);
        }
        this.mTextButton.setVisibility(icon == null || this.mItemData.showsTextAsAction() ? 0 : 8);
    }

    public boolean hasText() {
        return this.mTextButton.getVisibility() != 8;
    }

    public void setShortcut(boolean showShortcut, char shortcutKey) {
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
        this.setContentDescription(title);
        if (this.mImageButton.getDrawable() == null || this.mItemData.showsTextAsAction()) {
            this.mTextButton.setText(this.mTitle);
            this.mTextButton.setVisibility(0);
        }
    }

    public boolean showsIcon() {
        return true;
    }
}

