/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.ActionMenuView;
import com.android.internal.view.menu.MenuBuilder;

public class ActionBarContextView
extends ViewGroup
implements Animator.AnimatorListener {
    public static final String TAG = "ActionBarContextView";
    public int mContentHeight;
    public CharSequence mTitle;
    public CharSequence mSubtitle;
    public View mClose;
    public View mCustomView;
    public LinearLayout mTitleLayout;
    public TextView mTitleView;
    public TextView mSubtitleView;
    public int mTitleStyleRes;
    public int mSubtitleStyleRes;
    public ActionMenuView mMenuView;
    public Animator mCurrentAnimation;
    public boolean mAnimateInOnLayout;
    public int mAnimationMode;
    public static final int ANIMATE_IDLE = 0;
    public static final int ANIMATE_IN = 1;
    public static final int ANIMATE_OUT = 2;

    public ActionBarContextView(Context context) {
        this(context, null);
    }

    public ActionBarContextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843634);
    }

    public ActionBarContextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ActionMode, defStyle, 0);
        this.setBackgroundDrawable(a.getDrawable(0));
        this.mTitleStyleRes = a.getResourceId(2, 0);
        this.mSubtitleStyleRes = a.getResourceId(3, 0);
        this.mContentHeight = a.getLayoutDimension(1, 0);
        a.recycle();
    }

    public ActionMode startActionModeForChild(View child, ActionMode.Callback callback) {
        return null;
    }

    public void setHeight(int height) {
        this.mContentHeight = height;
    }

    public void setCustomView(View view) {
        if (this.mCustomView != null) {
            this.removeView(this.mCustomView);
        }
        this.mCustomView = view;
        if (this.mTitleLayout != null) {
            this.removeView(this.mTitleLayout);
            this.mTitleLayout = null;
        }
        if (view != null) {
            this.addView(view);
        }
        this.requestLayout();
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
        this.initTitle();
    }

    public void setSubtitle(CharSequence subtitle) {
        this.mSubtitle = subtitle;
        this.initTitle();
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public void initTitle() {
        if (this.mTitleLayout == null) {
            LayoutInflater inflater = LayoutInflater.from(this.getContext());
            inflater.inflate(0x1090019, (ViewGroup)this);
            this.mTitleLayout = (LinearLayout)this.getChildAt(this.getChildCount() - 1);
            this.mTitleView = (TextView)this.mTitleLayout.findViewById(16908798);
            this.mSubtitleView = (TextView)this.mTitleLayout.findViewById(16908799);
            if (this.mTitle != null) {
                this.mTitleView.setText(this.mTitle);
                if (this.mTitleStyleRes != 0) {
                    this.mTitleView.setTextAppearance(this.mContext, this.mTitleStyleRes);
                }
            }
            if (this.mSubtitle != null) {
                this.mSubtitleView.setText(this.mSubtitle);
                if (this.mSubtitleStyleRes != 0) {
                    this.mSubtitleView.setTextAppearance(this.mContext, this.mSubtitleStyleRes);
                }
                this.mSubtitleView.setVisibility(0);
            }
        } else {
            this.mTitleView.setText(this.mTitle);
            this.mSubtitleView.setText(this.mSubtitle);
            this.mSubtitleView.setVisibility(this.mSubtitle != null ? 0 : 8);
            if (this.mTitleLayout.getParent() == null) {
                this.addView(this.mTitleLayout);
            }
        }
    }

    public void initForMode(final ActionMode mode) {
        if (this.mClose == null) {
            LayoutInflater inflater = LayoutInflater.from(this.mContext);
            this.mClose = inflater.inflate(17367069, (ViewGroup)this, false);
            this.addView(this.mClose);
        } else if (this.mClose.getParent() == null) {
            this.addView(this.mClose);
        }
        View closeButton = this.mClose.findViewById(0x1020202);
        closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                mode.finish();
            }
        });
        MenuBuilder menu2 = (MenuBuilder)mode.getMenu();
        this.mMenuView = (ActionMenuView)menu2.getMenuView(3, this);
        this.mMenuView.setOverflowReserved(true);
        this.mMenuView.updateChildren(false);
        this.addView(this.mMenuView);
        this.mAnimateInOnLayout = true;
    }

    public void closeMode() {
        if (this.mAnimationMode == 2) {
            return;
        }
        if (this.mClose == null) {
            this.killMode();
            return;
        }
        this.finishAnimation();
        this.mAnimationMode = 2;
        this.mCurrentAnimation = this.makeOutAnimation();
        this.mCurrentAnimation.start();
    }

    public void finishAnimation() {
        Animator a = this.mCurrentAnimation;
        if (a != null) {
            this.mCurrentAnimation = null;
            a.end();
        }
    }

    public void killMode() {
        this.finishAnimation();
        this.removeAllViews();
        this.mCustomView = null;
        this.mMenuView = null;
        this.mAnimateInOnLayout = false;
    }

    public boolean showOverflowMenu() {
        if (this.mMenuView != null) {
            return this.mMenuView.showOverflowMenu();
        }
        return false;
    }

    public void openOverflowMenu() {
        if (this.mMenuView != null) {
            this.mMenuView.openOverflowMenu();
        }
    }

    public boolean hideOverflowMenu() {
        if (this.mMenuView != null) {
            return this.mMenuView.hideOverflowMenu();
        }
        return false;
    }

    public boolean isOverflowMenuShowing() {
        if (this.mMenuView != null) {
            return this.mMenuView.isOverflowMenuShowing();
        }
        return false;
    }

    public ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -2);
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        if (widthMode != 0x40000000) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_width=\"match_parent\" (or fill_parent)");
        }
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        if (heightMode == 0) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_height=\"wrap_content\"");
        }
        int contentWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int maxHeight = this.mContentHeight > 0 ? this.mContentHeight : View.MeasureSpec.getSize(heightMeasureSpec);
        int verticalPadding = this.getPaddingTop() + this.getPaddingBottom();
        int availableWidth = contentWidth - this.getPaddingLeft() - this.getPaddingRight();
        int height = maxHeight - verticalPadding;
        int childSpecHeight = View.MeasureSpec.makeMeasureSpec(height, Integer.MIN_VALUE);
        if (this.mClose != null) {
            availableWidth = this.measureChildView(this.mClose, availableWidth, childSpecHeight, 0);
        }
        if (this.mMenuView != null) {
            availableWidth = this.measureChildView(this.mMenuView, availableWidth, childSpecHeight, 0);
        }
        if (this.mTitleLayout != null && this.mCustomView == null) {
            availableWidth = this.measureChildView(this.mTitleLayout, availableWidth, childSpecHeight, 0);
        }
        if (this.mCustomView != null) {
            ViewGroup.LayoutParams lp = this.mCustomView.getLayoutParams();
            int customWidthMode = lp.width != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int customWidth = lp.width >= 0 ? Math.min(lp.width, availableWidth) : availableWidth;
            int customHeightMode = lp.height != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int customHeight = lp.height >= 0 ? Math.min(lp.height, height) : height;
            this.mCustomView.measure(View.MeasureSpec.makeMeasureSpec(customWidth, customWidthMode), View.MeasureSpec.makeMeasureSpec(customHeight, customHeightMode));
        }
        if (this.mContentHeight <= 0) {
            int measuredHeight = 0;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View v = this.getChildAt(i);
                int paddedViewHeight = v.getMeasuredHeight() + verticalPadding;
                if (paddedViewHeight <= measuredHeight) continue;
                measuredHeight = paddedViewHeight;
            }
            this.setMeasuredDimension(contentWidth, measuredHeight);
        } else {
            this.setMeasuredDimension(contentWidth, maxHeight);
        }
    }

    public Animator makeInAnimation() {
        int count;
        this.mClose.setTranslationX(-this.mClose.getWidth());
        ObjectAnimator buttonAnimator = ObjectAnimator.ofFloat(this.mClose, "translationX", 0.0f);
        buttonAnimator.setDuration(200L);
        buttonAnimator.addListener(this);
        buttonAnimator.setInterpolator(new DecelerateInterpolator());
        AnimatorSet set = new AnimatorSet();
        AnimatorSet.Builder b = set.play(buttonAnimator);
        if (this.mMenuView != null && (count = this.mMenuView.getChildCount()) > 0) {
            int i = count - 1;
            int j = 0;
            while (i >= 0) {
                View child = this.mMenuView.getChildAt(i);
                child.setScaleY(0.0f);
                ObjectAnimator a = ObjectAnimator.ofFloat(child, "scaleY", 0.0f, 1.0f);
                a.setDuration(100L);
                a.setStartDelay(j * 70);
                b.with(a);
                --i;
                ++j;
            }
        }
        return set;
    }

    public Animator makeOutAnimation() {
        int count;
        ObjectAnimator buttonAnimator = ObjectAnimator.ofFloat(this.mClose, "translationX", 0.0f, -this.mClose.getWidth());
        buttonAnimator.setDuration(200L);
        buttonAnimator.addListener(this);
        buttonAnimator.setInterpolator(new DecelerateInterpolator());
        AnimatorSet set = new AnimatorSet();
        AnimatorSet.Builder b = set.play(buttonAnimator);
        if (this.mMenuView != null && (count = this.mMenuView.getChildCount()) > 0) {
            for (int i = 0; i < 0; ++i) {
                View child = this.mMenuView.getChildAt(i);
                child.setScaleY(0.0f);
                ObjectAnimator a = ObjectAnimator.ofFloat(child, "scaleY", 1.0f, 0.0f);
                a.setDuration(100L);
                a.setStartDelay(i * 70);
                b.with(a);
            }
        }
        return set;
    }

    public void onLayout(boolean changed, int l, int t, int r, int b) {
        int x = this.getPaddingLeft();
        int y = this.getPaddingTop();
        int contentHeight = b - t - this.getPaddingTop() - this.getPaddingBottom();
        if (this.mClose != null && this.mClose.getVisibility() != 8) {
            x += this.positionChild(this.mClose, x, y, contentHeight);
            if (this.mAnimateInOnLayout) {
                this.mAnimationMode = 1;
                this.mCurrentAnimation = this.makeInAnimation();
                this.mCurrentAnimation.start();
                this.mAnimateInOnLayout = false;
            }
        }
        if (this.mTitleLayout != null && this.mCustomView == null) {
            x += this.positionChild(this.mTitleLayout, x, y, contentHeight);
        }
        if (this.mCustomView != null) {
            x += this.positionChild(this.mCustomView, x, y, contentHeight);
        }
        x = r - l - this.getPaddingRight();
        if (this.mMenuView != null) {
            x -= this.positionChildInverse(this.mMenuView, x, y, contentHeight);
        }
    }

    public int measureChildView(View child, int availableWidth, int childSpecHeight, int spacing) {
        child.measure(View.MeasureSpec.makeMeasureSpec(availableWidth, Integer.MIN_VALUE), childSpecHeight);
        availableWidth -= child.getMeasuredWidth();
        return availableWidth -= spacing;
    }

    public int positionChild(View child, int x, int y, int contentHeight) {
        int childWidth = child.getMeasuredWidth();
        int childHeight = child.getMeasuredHeight();
        int childTop = y + (contentHeight - childHeight) / 2;
        child.layout(x, childTop, x + childWidth, childTop + childHeight);
        return childWidth;
    }

    public int positionChildInverse(View child, int x, int y, int contentHeight) {
        int childWidth = child.getMeasuredWidth();
        int childHeight = child.getMeasuredHeight();
        int childTop = y + (contentHeight - childHeight) / 2;
        child.layout(x - childWidth, childTop, x, childTop + childHeight);
        return childWidth;
    }

    public void onAnimationStart(Animator animation) {
    }

    public void onAnimationEnd(Animator animation) {
        if (this.mAnimationMode == 2) {
            this.killMode();
        }
        this.mAnimationMode = 0;
    }

    public void onAnimationCancel(Animator animation) {
    }

    public void onAnimationRepeat(Animator animation) {
    }
}

