/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.ActionMenuItem;
import com.android.internal.view.menu.ActionMenuView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.widget.ActionBarContextView;

public class ActionBarView
extends ViewGroup {
    public static final String TAG = "ActionBarView";
    public static final int DISPLAY_DEFAULT = 0;
    public static final int DISPLAY_RELAYOUT_MASK = 31;
    public static final int DEFAULT_CUSTOM_GRAVITY = 19;
    public final int mContentHeight;
    public int mNavigationMode;
    public int mDisplayOptions = 6;
    public CharSequence mTitle;
    public CharSequence mSubtitle;
    public Drawable mIcon;
    public Drawable mLogo;
    public Drawable mDivider;
    public View mHomeLayout;
    public View mHomeAsUpView;
    public ImageView mIconView;
    public LinearLayout mTitleLayout;
    public TextView mTitleView;
    public TextView mSubtitleView;
    public Spinner mSpinner;
    public LinearLayout mListNavLayout;
    public HorizontalScrollView mTabScrollView;
    public LinearLayout mTabLayout;
    public View mCustomNavView;
    public ProgressBar mProgressView;
    public ProgressBar mIndeterminateProgressView;
    public int mProgressBarPadding;
    public int mItemPadding;
    public int mTitleStyleRes;
    public int mSubtitleStyleRes;
    public int mProgressStyle;
    public int mIndeterminateProgressStyle;
    public boolean mShowMenu;
    public boolean mUserTitle;
    public MenuBuilder mOptionsMenu;
    public ActionMenuView mMenuView;
    public ActionBarContextView mContextView;
    public ActionMenuItem mLogoNavItem;
    public SpinnerAdapter mSpinnerAdapter;
    public ActionBar.OnNavigationListener mCallback;
    public final AdapterView.OnItemSelectedListener mNavItemSelectedListener = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(AdapterView parent, View view, int position, long id2) {
            if (ActionBarView.this.mCallback != null) {
                ActionBarView.this.mCallback.onNavigationItemSelected(position, id2);
            }
        }

        public void onNothingSelected(AdapterView parent) {
        }
    };
    public View.OnClickListener mTabClickListener = null;

    public ActionBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setBackgroundResource(0);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ActionBar);
        ApplicationInfo appInfo = context.getApplicationInfo();
        PackageManager pm = context.getPackageManager();
        this.mNavigationMode = a.getInt(7, 0);
        this.mTitle = a.getText(5);
        this.mSubtitle = a.getText(9);
        this.mLogo = a.getDrawable(6);
        if (this.mLogo == null) {
            if (context instanceof Activity) {
                try {
                    this.mLogo = pm.getActivityLogo(((Activity)context).getComponentName());
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(TAG, "Activity component name not found!", e);
                }
            }
            if (this.mLogo == null) {
                this.mLogo = appInfo.loadLogo(pm);
            }
        }
        this.mIcon = a.getDrawable(0);
        if (this.mIcon == null) {
            if (context instanceof Activity) {
                try {
                    this.mIcon = pm.getActivityIcon(((Activity)context).getComponentName());
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(TAG, "Activity component name not found!", e);
                }
            }
            if (this.mIcon == null) {
                this.mIcon = appInfo.loadIcon(pm);
            }
        }
        LayoutInflater inflater = LayoutInflater.from(context);
        int homeResId = a.getResourceId(15, 17367064);
        this.mHomeLayout = inflater.inflate(homeResId, (ViewGroup)this, false);
        this.mHomeAsUpView = this.mHomeLayout.findViewById(16908796);
        this.mIconView = (ImageView)this.mHomeLayout.findViewById(16908332);
        this.mTitleStyleRes = a.getResourceId(11, 0);
        this.mSubtitleStyleRes = a.getResourceId(12, 0);
        this.mProgressStyle = a.getResourceId(1, 0);
        this.mIndeterminateProgressStyle = a.getResourceId(13, 0);
        this.mProgressBarPadding = a.getDimensionPixelOffset(14, 0);
        this.mItemPadding = a.getDimensionPixelOffset(16, 0);
        this.setDisplayOptions(a.getInt(8, 0));
        int customNavId = a.getResourceId(10, 0);
        if (customNavId != 0) {
            this.mCustomNavView = inflater.inflate(customNavId, (ViewGroup)this, false);
            this.mNavigationMode = 0;
            this.setDisplayOptions(this.mDisplayOptions | 0x10);
        }
        this.mContentHeight = a.getLayoutDimension(4, 0);
        this.mDivider = a.getDrawable(3);
        a.recycle();
        this.mLogoNavItem = new ActionMenuItem(context, 0, 16908332, 0, 0, this.mTitle);
        this.mHomeLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Context context = ActionBarView.this.getContext();
                if (context instanceof Activity) {
                    Activity activity = (Activity)context;
                    activity.onMenuItemSelected(0, ActionBarView.this.mLogoNavItem);
                }
            }
        });
        this.mHomeLayout.setClickable(true);
        this.mHomeLayout.setFocusable(true);
    }

    public void initProgress() {
        this.mProgressView = new ProgressBar(this.mContext, null, 0, this.mProgressStyle);
        this.mProgressView.setId(16908965);
        this.mProgressView.setMax(10000);
        this.addView(this.mProgressView);
    }

    public void initIndeterminateProgress() {
        this.mIndeterminateProgressView = new ProgressBar(this.mContext, null, 0, this.mIndeterminateProgressStyle);
        this.mIndeterminateProgressView.setId(16908964);
        this.addView(this.mIndeterminateProgressView);
    }

    public ActionMode startActionModeForChild(View child, ActionMode.Callback callback) {
        return null;
    }

    public void setCallback(ActionBar.OnNavigationListener callback) {
        this.mCallback = callback;
    }

    public void setMenu(Menu menu2) {
        MenuBuilder builder;
        if (menu2 == this.mOptionsMenu) {
            return;
        }
        this.mOptionsMenu = builder = (MenuBuilder)menu2;
        if (this.mMenuView != null) {
            this.removeView(this.mMenuView);
        }
        ActionMenuView menuView = (ActionMenuView)builder.getMenuView(3, null);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        menuView.setLayoutParams(layoutParams);
        this.addView(menuView);
        this.mMenuView = menuView;
    }

    public boolean showOverflowMenu() {
        if (this.mMenuView != null) {
            return this.mMenuView.showOverflowMenu();
        }
        return false;
    }

    public void openOverflowMenu() {
        if (this.mMenuView != null) {
            this.mMenuView.openOverflowMenu();
        }
    }

    public void postShowOverflowMenu() {
        this.post(new Runnable(){

            public void run() {
                ActionBarView.this.showOverflowMenu();
            }
        });
    }

    public boolean hideOverflowMenu() {
        if (this.mMenuView != null) {
            return this.mMenuView.hideOverflowMenu();
        }
        return false;
    }

    public boolean isOverflowMenuShowing() {
        if (this.mMenuView != null) {
            return this.mMenuView.isOverflowMenuShowing();
        }
        return false;
    }

    public boolean isOverflowMenuOpen() {
        if (this.mMenuView != null) {
            return this.mMenuView.isOverflowMenuOpen();
        }
        return false;
    }

    public boolean isOverflowReserved() {
        return this.mMenuView != null && this.mMenuView.isOverflowReserved();
    }

    public void setCustomNavigationView(View view) {
        boolean showCustom;
        boolean bl = showCustom = (this.mDisplayOptions & 0x10) != 0;
        if (this.mCustomNavView != null && showCustom) {
            this.removeView(this.mCustomNavView);
        }
        this.mCustomNavView = view;
        if (this.mCustomNavView != null && showCustom) {
            this.addView(this.mCustomNavView);
        }
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public void setTitle(CharSequence title) {
        this.mUserTitle = true;
        this.setTitleImpl(title);
    }

    public void setWindowTitle(CharSequence title) {
        if (!this.mUserTitle) {
            this.setTitleImpl(title);
        }
    }

    public void setTitleImpl(CharSequence title) {
        this.mTitle = title;
        if (this.mTitleView != null) {
            this.mTitleView.setText(title);
            this.mTitleLayout.setVisibility(TextUtils.isEmpty(this.mTitle) && TextUtils.isEmpty(this.mSubtitle) ? 8 : 0);
        }
        if (this.mLogoNavItem != null) {
            this.mLogoNavItem.setTitle(title);
        }
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public void setSubtitle(CharSequence subtitle) {
        this.mSubtitle = subtitle;
        if (this.mSubtitleView != null) {
            this.mSubtitleView.setText(subtitle);
            this.mSubtitleView.setVisibility(subtitle != null ? 0 : 8);
            this.mTitleLayout.setVisibility(TextUtils.isEmpty(this.mTitle) && TextUtils.isEmpty(this.mSubtitle) ? 8 : 0);
        }
    }

    public void setDisplayOptions(int options) {
        int flagsChanged = options ^ this.mDisplayOptions;
        this.mDisplayOptions = options;
        if ((flagsChanged & 0x1F) != 0) {
            int vis = (options & 2) != 0 ? 0 : 8;
            this.mHomeLayout.setVisibility(vis);
            if ((flagsChanged & 4) != 0) {
                this.mHomeAsUpView.setVisibility((options & 4) != 0 ? 0 : 8);
            }
            if ((flagsChanged & 1) != 0) {
                boolean logoVis = this.mLogo != null && (options & 1) != 0;
                this.mIconView.setImageDrawable(logoVis ? this.mLogo : this.mIcon);
            }
            if ((flagsChanged & 8) != 0) {
                if ((options & 8) != 0) {
                    this.initTitle();
                } else {
                    this.removeView(this.mTitleLayout);
                }
            }
            if ((flagsChanged & 0x10) != 0 && this.mCustomNavView != null) {
                if ((options & 0x10) != 0) {
                    this.addView(this.mCustomNavView);
                } else {
                    this.removeView(this.mCustomNavView);
                }
            }
            this.requestLayout();
        } else {
            this.invalidate();
        }
    }

    public void setNavigationMode(int mode) {
        int oldMode = this.mNavigationMode;
        if (mode != oldMode) {
            switch (oldMode) {
                case 1: {
                    if (this.mSpinner == null) break;
                    this.removeView(this.mListNavLayout);
                    break;
                }
                case 2: {
                    if (this.mTabLayout == null) break;
                    this.removeView(this.mTabScrollView);
                }
            }
            switch (mode) {
                case 1: {
                    if (this.mSpinner == null) {
                        this.mSpinner = new Spinner(this.mContext, null, 16843479);
                        this.mListNavLayout = new LinearLayout(this.mContext, null, 16843508);
                        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
                        params.gravity = 17;
                        this.mListNavLayout.addView((View)this.mSpinner, params);
                    }
                    if (this.mSpinner.getAdapter() != this.mSpinnerAdapter) {
                        this.mSpinner.setAdapter(this.mSpinnerAdapter);
                    }
                    this.mSpinner.setOnItemSelectedListener(this.mNavItemSelectedListener);
                    this.addView(this.mListNavLayout);
                    break;
                }
                case 2: {
                    this.ensureTabsExist();
                    this.addView(this.mTabScrollView);
                }
            }
            this.mNavigationMode = mode;
            this.requestLayout();
        }
    }

    public void ensureTabsExist() {
        if (this.mTabScrollView == null) {
            this.mTabScrollView = new HorizontalScrollView(this.getContext());
            this.mTabScrollView.setHorizontalFadingEdgeEnabled(true);
            this.mTabLayout = new LinearLayout(this.getContext(), null, 16843508);
            this.mTabScrollView.addView(this.mTabLayout);
        }
    }

    public void setDropdownAdapter(SpinnerAdapter adapter) {
        this.mSpinnerAdapter = adapter;
        if (this.mSpinner != null) {
            this.mSpinner.setAdapter(adapter);
        }
    }

    public SpinnerAdapter getDropdownAdapter() {
        return this.mSpinnerAdapter;
    }

    public void setDropdownSelectedPosition(int position) {
        this.mSpinner.setSelection(position);
    }

    public int getDropdownSelectedPosition() {
        return this.mSpinner.getSelectedItemPosition();
    }

    public View getCustomNavigationView() {
        return this.mCustomNavView;
    }

    public int getNavigationMode() {
        return this.mNavigationMode;
    }

    public int getDisplayOptions() {
        return this.mDisplayOptions;
    }

    public TabView createTabView(ActionBar.Tab tab) {
        TabView tabView = new TabView(this.getContext(), tab);
        tabView.setFocusable(true);
        if (this.mTabClickListener == null) {
            this.mTabClickListener = new TabClickListener(null);
        }
        tabView.setOnClickListener(this.mTabClickListener);
        return tabView;
    }

    public void addTab(ActionBar.Tab tab, boolean setSelected) {
        this.ensureTabsExist();
        TabView tabView = this.createTabView(tab);
        this.mTabLayout.addView(tabView);
        if (setSelected) {
            tabView.setSelected(true);
        }
    }

    public void addTab(ActionBar.Tab tab, int position, boolean setSelected) {
        this.ensureTabsExist();
        TabView tabView = this.createTabView(tab);
        this.mTabLayout.addView((View)tabView, position);
        if (setSelected) {
            tabView.setSelected(true);
        }
    }

    public void removeTabAt(int position) {
        if (this.mTabLayout != null) {
            this.mTabLayout.removeViewAt(position);
        }
    }

    public void removeAllTabs() {
        if (this.mTabLayout != null) {
            this.mTabLayout.removeAllViews();
        }
    }

    public ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ActionBar.LayoutParams(19);
    }

    public void onFinishInflate() {
        ViewParent parent;
        super.onFinishInflate();
        this.addView(this.mHomeLayout);
        if (this.mCustomNavView != null && (this.mDisplayOptions & 0x10) != 0 && (parent = this.mCustomNavView.getParent()) != this) {
            if (parent instanceof ViewGroup) {
                ((ViewGroup)parent).removeView(this.mCustomNavView);
            }
            this.addView(this.mCustomNavView);
        }
    }

    public void initTitle() {
        LayoutInflater inflater = LayoutInflater.from(this.getContext());
        this.mTitleLayout = (LinearLayout)inflater.inflate(0x1090019, null);
        this.mTitleView = (TextView)this.mTitleLayout.findViewById(16908798);
        this.mSubtitleView = (TextView)this.mTitleLayout.findViewById(16908799);
        if (this.mTitleStyleRes != 0) {
            this.mTitleView.setTextAppearance(this.mContext, this.mTitleStyleRes);
        }
        if (this.mTitle != null) {
            this.mTitleView.setText(this.mTitle);
        }
        if (this.mSubtitleStyleRes != 0) {
            this.mSubtitleView.setTextAppearance(this.mContext, this.mSubtitleStyleRes);
        }
        if (this.mSubtitle != null) {
            this.mSubtitleView.setText(this.mSubtitle);
            this.mSubtitleView.setVisibility(0);
        }
        this.addView(this.mTitleLayout);
    }

    public void setTabSelected(int position) {
        this.ensureTabsExist();
        int tabCount = this.mTabLayout.getChildCount();
        for (int i = 0; i < tabCount; ++i) {
            View child = this.mTabLayout.getChildAt(i);
            child.setSelected(i == position);
        }
    }

    public void setContextView(ActionBarContextView view) {
        this.mContextView = view;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean showTitle;
        int leftOfCenter;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        if (widthMode != 0x40000000) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_width=\"match_parent\" (or fill_parent)");
        }
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        if (heightMode != Integer.MIN_VALUE) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_height=\"wrap_content\"");
        }
        int contentWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int maxHeight = this.mContentHeight > 0 ? this.mContentHeight : View.MeasureSpec.getSize(heightMeasureSpec);
        int verticalPadding = this.getPaddingTop() + this.getPaddingBottom();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int height = maxHeight - verticalPadding;
        int childSpecHeight = View.MeasureSpec.makeMeasureSpec(height, Integer.MIN_VALUE);
        int availableWidth = contentWidth - paddingLeft - paddingRight;
        int rightOfCenter = leftOfCenter = availableWidth / 2;
        if (this.mHomeLayout.getVisibility() != 8) {
            this.mHomeLayout.measure(View.MeasureSpec.makeMeasureSpec(availableWidth, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
            int homeWidth = this.mHomeLayout.getMeasuredWidth();
            availableWidth -= homeWidth;
            leftOfCenter -= homeWidth;
        }
        if (this.mMenuView != null) {
            availableWidth = this.measureChildView(this.mMenuView, availableWidth, childSpecHeight, 0);
            rightOfCenter -= this.mMenuView.getMeasuredWidth();
        }
        boolean bl = showTitle = this.mTitleLayout != null && this.mTitleLayout.getVisibility() != 8 && (this.mDisplayOptions & 8) != 0;
        if (showTitle) {
            availableWidth = this.measureChildView(this.mTitleLayout, availableWidth, childSpecHeight, 0);
            leftOfCenter -= this.mTitleLayout.getMeasuredWidth();
        }
        switch (this.mNavigationMode) {
            case 1: {
                if (this.mListNavLayout == null) break;
                int itemPaddingSize = showTitle ? this.mItemPadding * 2 : this.mItemPadding;
                leftOfCenter -= itemPaddingSize;
                this.mListNavLayout.measure(View.MeasureSpec.makeMeasureSpec(availableWidth -= itemPaddingSize, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
                int listNavWidth = this.mListNavLayout.getMeasuredWidth();
                availableWidth -= listNavWidth;
                leftOfCenter -= listNavWidth;
                break;
            }
            case 2: {
                if (this.mTabScrollView == null) break;
                int itemPaddingSize = showTitle ? this.mItemPadding * 2 : this.mItemPadding;
                leftOfCenter -= itemPaddingSize;
                this.mTabScrollView.measure(View.MeasureSpec.makeMeasureSpec(availableWidth -= itemPaddingSize, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
                int tabWidth = this.mTabScrollView.getMeasuredWidth();
                availableWidth -= tabWidth;
                leftOfCenter -= tabWidth;
            }
        }
        if (this.mIndeterminateProgressView != null && this.mIndeterminateProgressView.getVisibility() != 8) {
            availableWidth = this.measureChildView(this.mIndeterminateProgressView, availableWidth, childSpecHeight, 0);
            rightOfCenter -= this.mIndeterminateProgressView.getMeasuredWidth();
        }
        if ((this.mDisplayOptions & 0x10) != 0 && this.mCustomNavView != null) {
            ViewGroup.LayoutParams lp = this.generateLayoutParams(this.mCustomNavView.getLayoutParams());
            ActionBar.LayoutParams ablp = lp instanceof ActionBar.LayoutParams ? (ActionBar.LayoutParams)lp : null;
            int horizontalMargin = 0;
            int verticalMargin = 0;
            if (ablp != null) {
                horizontalMargin = ablp.leftMargin + ablp.rightMargin;
                verticalMargin = ablp.topMargin + ablp.bottomMargin;
            }
            int customNavHeightMode = this.mContentHeight <= 0 ? Integer.MIN_VALUE : (lp.height != -2 ? 0x40000000 : Integer.MIN_VALUE);
            int customNavHeight = Math.max(0, (lp.height >= 0 ? Math.min(lp.height, height) : height) - verticalMargin);
            int customNavWidthMode = lp.width != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int customNavWidth = Math.max(0, (lp.width >= 0 ? Math.min(lp.width, availableWidth) : availableWidth) - horizontalMargin);
            int hgrav = (ablp != null ? ablp.gravity : 19) & 7;
            if (hgrav == 1 && lp.width == -1) {
                customNavWidth = Math.min(leftOfCenter, rightOfCenter) * 2;
            }
            this.mCustomNavView.measure(View.MeasureSpec.makeMeasureSpec(customNavWidth, customNavWidthMode), View.MeasureSpec.makeMeasureSpec(customNavHeight, customNavHeightMode));
        }
        if (this.mContentHeight <= 0) {
            int measuredHeight = 0;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View v = this.getChildAt(i);
                int paddedViewHeight = v.getMeasuredHeight() + verticalPadding;
                if (paddedViewHeight <= measuredHeight) continue;
                measuredHeight = paddedViewHeight;
            }
            this.setMeasuredDimension(contentWidth, measuredHeight);
        } else {
            this.setMeasuredDimension(contentWidth, maxHeight);
        }
        if (this.mContextView != null) {
            this.mContextView.setHeight(this.getMeasuredHeight());
        }
        if (this.mProgressView != null && this.mProgressView.getVisibility() != 8) {
            this.mProgressView.measure(View.MeasureSpec.makeMeasureSpec(contentWidth - this.mProgressBarPadding * 2, 0x40000000), View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), Integer.MIN_VALUE));
        }
    }

    public int measureChildView(View child, int availableWidth, int childSpecHeight, int spacing) {
        child.measure(View.MeasureSpec.makeMeasureSpec(availableWidth, Integer.MIN_VALUE), childSpecHeight);
        availableWidth -= child.getMeasuredWidth();
        return availableWidth -= spacing;
    }

    public void onLayout(boolean changed, int l, int t, int r, int b) {
        boolean showTitle;
        int x = this.getPaddingLeft();
        int y = this.getPaddingTop();
        int contentHeight = b - t - this.getPaddingTop() - this.getPaddingBottom();
        if (this.mHomeLayout.getVisibility() != 8) {
            x += this.positionChild(this.mHomeLayout, x, y, contentHeight);
        }
        boolean bl = showTitle = this.mTitleLayout != null && this.mTitleLayout.getVisibility() != 8 && (this.mDisplayOptions & 8) != 0;
        if (showTitle) {
            x += this.positionChild(this.mTitleLayout, x, y, contentHeight);
        }
        switch (this.mNavigationMode) {
            case 0: {
                break;
            }
            case 1: {
                if (this.mListNavLayout == null) break;
                if (showTitle) {
                    x += this.mItemPadding;
                }
                x += this.positionChild(this.mListNavLayout, x, y, contentHeight) + this.mItemPadding;
                break;
            }
            case 2: {
                if (this.mTabScrollView == null) break;
                if (showTitle) {
                    x += this.mItemPadding;
                }
                x += this.positionChild(this.mTabScrollView, x, y, contentHeight) + this.mItemPadding;
            }
        }
        int menuLeft = r - l - this.getPaddingRight();
        if (this.mMenuView != null) {
            this.positionChildInverse(this.mMenuView, menuLeft, y, contentHeight);
            menuLeft -= this.mMenuView.getMeasuredWidth();
        }
        if (this.mIndeterminateProgressView != null && this.mIndeterminateProgressView.getVisibility() != 8) {
            this.positionChildInverse(this.mIndeterminateProgressView, menuLeft, y, contentHeight);
            menuLeft -= this.mIndeterminateProgressView.getMeasuredWidth();
        }
        if (this.mCustomNavView != null && (this.mDisplayOptions & 0x10) != 0) {
            int hgravity;
            ViewGroup.LayoutParams lp = this.mCustomNavView.getLayoutParams();
            ActionBar.LayoutParams ablp = lp instanceof ActionBar.LayoutParams ? (ActionBar.LayoutParams)lp : null;
            int gravity = ablp != null ? ablp.gravity : 19;
            int navWidth = this.mCustomNavView.getMeasuredWidth();
            int topMargin = 0;
            int bottomMargin = 0;
            if (ablp != null) {
                x += ablp.leftMargin;
                menuLeft -= ablp.rightMargin;
                topMargin = ablp.topMargin;
                bottomMargin = ablp.bottomMargin;
            }
            if ((hgravity = gravity & 7) == 1) {
                int centeredLeft = (this.mRight - this.mLeft - navWidth) / 2;
                if (centeredLeft < x) {
                    hgravity = 3;
                } else if (centeredLeft + navWidth > menuLeft) {
                    hgravity = 5;
                }
            }
            int xpos = 0;
            switch (hgravity) {
                case 1: {
                    xpos = (this.mRight - this.mLeft - navWidth) / 2;
                    break;
                }
                case 3: {
                    xpos = x;
                    break;
                }
                case 5: {
                    xpos = menuLeft - navWidth;
                }
            }
            int ypos = 0;
            switch (gravity & 0x70) {
                case 16: {
                    int paddedTop = this.mTop + this.getPaddingTop();
                    int paddedBottom = this.mBottom - this.getPaddingBottom();
                    ypos = (paddedBottom - paddedTop - this.mCustomNavView.getMeasuredHeight()) / 2;
                    break;
                }
                case 48: {
                    ypos = this.getPaddingTop() + topMargin;
                    break;
                }
                case 80: {
                    ypos = this.getHeight() - this.getPaddingBottom() - this.mCustomNavView.getMeasuredHeight() - bottomMargin;
                }
            }
            x += this.positionChild(this.mCustomNavView, xpos, ypos, contentHeight);
        }
        if (this.mProgressView != null) {
            this.mProgressView.bringToFront();
            int halfProgressHeight = this.mProgressView.getMeasuredHeight() / 2;
            this.mProgressView.layout(this.mProgressBarPadding, -halfProgressHeight, this.mProgressBarPadding + this.mProgressView.getMeasuredWidth(), halfProgressHeight);
        }
    }

    public int positionChild(View child, int x, int y, int contentHeight) {
        int childWidth = child.getMeasuredWidth();
        int childHeight = child.getMeasuredHeight();
        int childTop = y + (contentHeight - childHeight) / 2;
        child.layout(x, childTop, x + childWidth, childTop + childHeight);
        return childWidth;
    }

    public int positionChildInverse(View child, int x, int y, int contentHeight) {
        int childWidth = child.getMeasuredWidth();
        int childHeight = child.getMeasuredHeight();
        int childTop = y + (contentHeight - childHeight) / 2;
        child.layout(x - childWidth, childTop, x, childTop + childHeight);
        return childWidth;
    }

    public static class HomeView
    extends FrameLayout {
        public View mUpView;
        public View mIconView;

        public HomeView(Context context) {
            this(context, null);
        }

        public HomeView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public void onFinishInflate() {
            this.mUpView = this.findViewById(16908796);
            this.mIconView = (ImageView)this.findViewById(16908332);
        }

        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.measureChildWithMargins(this.mUpView, widthMeasureSpec, 0, heightMeasureSpec, 0);
            FrameLayout.LayoutParams upLp = (FrameLayout.LayoutParams)this.mUpView.getLayoutParams();
            int width = upLp.leftMargin + this.mUpView.getMeasuredWidth() + upLp.rightMargin;
            int height = upLp.topMargin + this.mUpView.getMeasuredHeight() + upLp.bottomMargin;
            this.measureChildWithMargins(this.mIconView, widthMeasureSpec, width, heightMeasureSpec, 0);
            FrameLayout.LayoutParams iconLp = (FrameLayout.LayoutParams)this.mIconView.getLayoutParams();
            height = Math.max(height, iconLp.topMargin + this.mIconView.getMeasuredHeight() + iconLp.bottomMargin);
            this.setMeasuredDimension(width += iconLp.leftMargin + this.mIconView.getMeasuredWidth() + iconLp.rightMargin, height);
        }

        public void onLayout(boolean changed, int l, int t, int r, int b) {
            int vCenter = (b - t) / 2;
            int width = r - l;
            if (this.mUpView.getVisibility() != 8) {
                FrameLayout.LayoutParams upLp = (FrameLayout.LayoutParams)this.mUpView.getLayoutParams();
                int upHeight = this.mUpView.getMeasuredHeight();
                int upWidth = this.mUpView.getMeasuredWidth();
                int upTop = t + vCenter - upHeight / 2;
                this.mUpView.layout(l, upTop, l + upWidth, upTop + upHeight);
                int upOffset = upLp.leftMargin + upWidth + upLp.rightMargin;
                width -= upOffset;
                l += upOffset;
            }
            FrameLayout.LayoutParams iconLp = (FrameLayout.LayoutParams)this.mIconView.getLayoutParams();
            int iconHeight = this.mIconView.getMeasuredHeight();
            int iconWidth = this.mIconView.getMeasuredWidth();
            int hCenter = (r - l) / 2;
            int iconLeft = l + iconLp.leftMargin + hCenter - iconWidth / 2;
            int iconTop = t + iconLp.topMargin + vCenter - iconHeight / 2;
            this.mIconView.layout(iconLeft, iconTop, iconLeft + iconWidth, iconTop + iconHeight);
        }
    }

    public class TabClickListener
    implements View.OnClickListener {
        public TabClickListener() {
        }

        public void onClick(View view) {
            TabView tabView = (TabView)view;
            tabView.getTab().select();
            int tabCount = ActionBarView.this.mTabLayout.getChildCount();
            for (int i = 0; i < tabCount; ++i) {
                View child;
                child.setSelected((child = ActionBarView.this.mTabLayout.getChildAt(i)) == view);
            }
        }

        public /* synthetic */ TabClickListener(1 x1) {
            this();
        }
    }

    public static class TabView
    extends LinearLayout {
        public ActionBar.Tab mTab;

        public TabView(Context context, ActionBar.Tab tab) {
            super(context, null, 16843507);
            this.mTab = tab;
            View custom = tab.getCustomView();
            if (custom != null) {
                this.addView(custom);
            } else {
                LinearLayout.LayoutParams lp;
                Drawable icon = tab.getIcon();
                CharSequence text = tab.getText();
                if (icon != null) {
                    ImageView iconView = new ImageView(context);
                    iconView.setImageDrawable(icon);
                    lp = new LinearLayout.LayoutParams(-2, -2);
                    lp.gravity = 16;
                    iconView.setLayoutParams(lp);
                    this.addView(iconView);
                }
                if (text != null) {
                    TextView textView = new TextView(context, null, 16843509);
                    textView.setText(text);
                    textView.setSingleLine();
                    textView.setEllipsize(TextUtils.TruncateAt.END);
                    lp = new LinearLayout.LayoutParams(-2, -2);
                    lp.gravity = 16;
                    textView.setLayoutParams(lp);
                    this.addView(textView);
                }
            }
            this.setLayoutParams(new LinearLayout.LayoutParams(-2, -1, 1.0f));
        }

        public ActionBar.Tab getTab() {
            return this.mTab;
        }
    }
}

