/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.view.animation.DecelerateInterpolator;
import java.util.ArrayList;

public class DrawableHolder
implements Animator.AnimatorListener {
    public static final DecelerateInterpolator EASE_OUT_INTERPOLATOR = new DecelerateInterpolator();
    public static final String TAG = "DrawableHolder";
    public static final boolean DBG = false;
    public float mX = 0.0f;
    public float mY = 0.0f;
    public float mScaleX = 1.0f;
    public float mScaleY = 1.0f;
    public BitmapDrawable mDrawable;
    public float mAlpha = 1.0f;
    public ArrayList<ObjectAnimator> mAnimators = new ArrayList();
    public ArrayList<ObjectAnimator> mNeedToStart = new ArrayList();

    public DrawableHolder(BitmapDrawable drawable2) {
        this(drawable2, 0.0f, 0.0f);
    }

    public DrawableHolder(BitmapDrawable drawable2, float x, float y) {
        this.mDrawable = drawable2;
        this.mX = x;
        this.mY = y;
        this.mDrawable.getPaint().setAntiAlias(true);
        this.mDrawable.setBounds(0, 0, this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
    }

    public ObjectAnimator addAnimTo(long duration, long delay, String property, float toValue, boolean replace) {
        if (replace) {
            this.removeAnimationFor(property);
        }
        ObjectAnimator anim2 = ObjectAnimator.ofFloat(this, property, toValue);
        anim2.setDuration(duration);
        anim2.setStartDelay(delay);
        anim2.setInterpolator(EASE_OUT_INTERPOLATOR);
        this.addAnimation(anim2, replace);
        return anim2;
    }

    public void removeAnimationFor(String property) {
        ArrayList removalList = (ArrayList)this.mAnimators.clone();
        for (ObjectAnimator currentAnim : removalList) {
            if (!property.equals(currentAnim.getPropertyName())) continue;
            currentAnim.cancel();
        }
    }

    public void clearAnimations() {
        for (ObjectAnimator currentAnim : this.mAnimators) {
            currentAnim.cancel();
        }
        this.mAnimators.clear();
    }

    public DrawableHolder addAnimation(ObjectAnimator anim2, boolean overwrite) {
        if (anim2 != null) {
            this.mAnimators.add(anim2);
        }
        this.mNeedToStart.add(anim2);
        return this;
    }

    public void draw(Canvas canvas) {
        float threshold = 0.00390625f;
        if (this.mAlpha <= 0.00390625f) {
            return;
        }
        canvas.save(1);
        canvas.translate(this.mX, this.mY);
        canvas.scale(this.mScaleX, this.mScaleY);
        canvas.translate(-0.5f * (float)this.getWidth(), -0.5f * (float)this.getHeight());
        this.mDrawable.setAlpha(Math.round(this.mAlpha * 255.0f));
        this.mDrawable.draw(canvas);
        canvas.restore();
    }

    public void startAnimations(ValueAnimator.AnimatorUpdateListener listener) {
        for (int i = 0; i < this.mNeedToStart.size(); ++i) {
            ObjectAnimator anim2 = this.mNeedToStart.get(i);
            anim2.addUpdateListener(listener);
            anim2.addListener(this);
            anim2.start();
        }
        this.mNeedToStart.clear();
    }

    public void setX(float value) {
        this.mX = value;
    }

    public void setY(float value) {
        this.mY = value;
    }

    public void setScaleX(float value) {
        this.mScaleX = value;
    }

    public void setScaleY(float value) {
        this.mScaleY = value;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public BitmapDrawable getDrawable() {
        return this.mDrawable;
    }

    public int getWidth() {
        return this.mDrawable.getIntrinsicWidth();
    }

    public int getHeight() {
        return this.mDrawable.getIntrinsicHeight();
    }

    public void onAnimationCancel(Animator animation) {
    }

    public void onAnimationEnd(Animator animation) {
        this.mAnimators.remove(animation);
    }

    public void onAnimationRepeat(Animator animation) {
    }

    public void onAnimationStart(Animator animation) {
    }
}

