/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.content.Context;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import java.io.File;
import org.xmlpull.v1.XmlPullParser;

public final class BridgeInflater
extends LayoutInflater {
    private final IProjectCallback mProjectCallback;
    private boolean mIsInMerge = false;
    private ResourceReference mResourceReference;
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit."};

    protected BridgeInflater(LayoutInflater layoutInflater, Context context) {
        super(layoutInflater, context);
        this.mProjectCallback = null;
    }

    public BridgeInflater(Context context, IProjectCallback iProjectCallback) {
        super(context);
        this.mProjectCallback = iProjectCallback;
        this.mConstructorArgs[0] = context;
    }

    public View onCreateView(String string2, AttributeSet attributeSet) throws ClassNotFoundException {
        View view = null;
        try {
            for (String string3 : sClassPrefixList) {
                try {
                    view = this.createView(string2, string3, attributeSet);
                    if (view == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            try {
                if (view == null) {
                    view = super.onCreateView(string2, attributeSet);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (view == null) {
                view = this.loadCustomView(string2, attributeSet);
            }
        }
        catch (Exception exception) {
            ClassNotFoundException classNotFoundException = new ClassNotFoundException("onCreateView", exception);
            throw classNotFoundException;
        }
        this.setupViewInContext(view, attributeSet);
        return view;
    }

    public View createViewFromTag(View view, String string2, AttributeSet attributeSet) {
        View view2 = null;
        try {
            view2 = super.createViewFromTag(view, string2, attributeSet);
        }
        catch (InflateException inflateException) {
            try {
                view2 = this.loadCustomView(string2, attributeSet);
            }
            catch (Exception exception) {
                InflateException inflateException2 = new InflateException();
                if (!exception.getClass().equals(ClassNotFoundException.class)) {
                    inflateException2.initCause(exception);
                } else {
                    inflateException2.initCause(inflateException);
                }
                throw inflateException2;
            }
        }
        this.setupViewInContext(view2, attributeSet);
        return view2;
    }

    public View inflate(int n, ViewGroup viewGroup) {
        Context context = this.getContext();
        if (context instanceof BridgeContext) {
            File file;
            BridgeContext bridgeContext = (BridgeContext)context;
            ResourceValue resourceValue = null;
            Pair pair = Bridge.resolveResourceId(n);
            if (pair != null) {
                resourceValue = bridgeContext.getRenderResources().getFrameworkResource(ResourceType.LAYOUT, (String)pair.getSecond());
            } else {
                pair = this.mProjectCallback.resolveResourceId(n);
                if (pair != null) {
                    resourceValue = bridgeContext.getRenderResources().getProjectResource(ResourceType.LAYOUT, (String)pair.getSecond());
                }
            }
            if (resourceValue != null && (file = new File(resourceValue.getValue())).isFile()) {
                try {
                    XmlPullParser xmlPullParser = ParserFactory.create(file);
                    BridgeXmlBlockParser bridgeXmlBlockParser = new BridgeXmlBlockParser(xmlPullParser, bridgeContext, false);
                    return this.inflate(bridgeXmlBlockParser, viewGroup);
                }
                catch (Exception exception) {
                    Bridge.getLog().error("resources.read", "Failed to parse file " + file.getAbsolutePath(), (Throwable)exception, null);
                    return null;
                }
            }
        }
        return null;
    }

    private View loadCustomView(String string2, AttributeSet attributeSet) throws ClassNotFoundException, Exception {
        if (this.mProjectCallback != null) {
            if (string2.equals("view")) {
                string2 = attributeSet.getAttributeValue(null, "class");
            }
            this.mConstructorArgs[1] = attributeSet;
            Object object = this.mProjectCallback.loadView(string2, mConstructorSignature, this.mConstructorArgs);
            if (object instanceof View) {
                return (View)object;
            }
        }
        return null;
    }

    private void setupViewInContext(View view, AttributeSet attributeSet) {
        if (this.getContext() instanceof BridgeContext) {
            BridgeContext bridgeContext = (BridgeContext)this.getContext();
            if (attributeSet instanceof BridgeXmlBlockParser) {
                BridgeXmlBlockParser bridgeXmlBlockParser = (BridgeXmlBlockParser)attributeSet;
                Object object = bridgeXmlBlockParser.getViewCookie();
                if (object == null) {
                    int n = bridgeXmlBlockParser.getDepth();
                    BridgeXmlBlockParser bridgeXmlBlockParser2 = bridgeContext.getPreviousParser();
                    if (bridgeXmlBlockParser2 != null) {
                        int n2;
                        int n3 = n2 = this.mIsInMerge ? 2 : 1;
                        if (n == n2 && (object = bridgeXmlBlockParser2.getViewCookie()) != null && this.mIsInMerge) {
                            object = new MergeCookie(object);
                        }
                    } else if (this.mResourceReference != null && n == 1) {
                        object = this.mResourceReference;
                    }
                }
                if (object != null) {
                    bridgeContext.addViewKey(view, object);
                }
            }
        }
    }

    public void setIsInMerge(boolean bl) {
        this.mIsInMerge = bl;
    }

    public void setResourceReference(ResourceReference resourceReference) {
        this.mResourceReference = resourceReference;
    }

    public LayoutInflater cloneInContext(Context context) {
        return new BridgeInflater(this, context);
    }
}

