/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.LayoutInflater_Delegate;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeResources;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class BridgeTypedArray
extends TypedArray {
    private final BridgeResources mBridgeResources;
    private final BridgeContext mContext;
    private final boolean mPlatformFile;
    private final boolean mPlatformStyleable;
    private final String mStyleableName;
    private ResourceValue[] mResourceData;
    private String[] mNames;

    public BridgeTypedArray(BridgeResources bridgeResources, BridgeContext bridgeContext, int n, boolean bl, boolean bl2, String string2) {
        super(null, null, null, 0);
        this.mBridgeResources = bridgeResources;
        this.mContext = bridgeContext;
        this.mPlatformFile = bl;
        this.mPlatformStyleable = bl2;
        this.mStyleableName = string2;
        this.mResourceData = new ResourceValue[n];
        this.mNames = new String[n];
    }

    public void bridgeSetValue(int n, String string2, ResourceValue resourceValue) {
        this.mResourceData[n] = resourceValue;
        this.mNames[n] = string2;
    }

    public void sealArray() {
        int n = 0;
        ResourceValue[] resourceValueArray = this.mResourceData;
        int n2 = resourceValueArray.length;
        for (int i = 0; i < n2; ++i) {
            ResourceValue resourceValue = resourceValueArray[i];
            if (resourceValue == null) continue;
            ++n;
        }
        this.mIndices = new int[n + 1];
        this.mIndices[0] = n;
        int n3 = 1;
        for (n2 = 0; n2 < this.mResourceData.length; ++n2) {
            if (this.mResourceData[n2] == null) continue;
            this.mIndices[n3++] = n2;
        }
    }

    public int length() {
        return this.mResourceData.length;
    }

    public Resources getResources() {
        return this.mBridgeResources;
    }

    public CharSequence getText(int n) {
        if (n < 0 || n >= this.mResourceData.length) {
            return null;
        }
        if (this.mResourceData[n] != null) {
            return this.mResourceData[n].getValue();
        }
        return null;
    }

    public String getString(int n) {
        if (n < 0 || n >= this.mResourceData.length) {
            return null;
        }
        if (this.mResourceData[n] != null) {
            return this.mResourceData[n].getValue();
        }
        return null;
    }

    public boolean getBoolean(int n, boolean bl) {
        if (n < 0 || n >= this.mResourceData.length) {
            return bl;
        }
        if (this.mResourceData[n] == null) {
            return bl;
        }
        String string2 = this.mResourceData[n].getValue();
        if (string2 != null) {
            return XmlUtils.convertValueToBoolean(string2, bl);
        }
        return bl;
    }

    public int getInt(int n, int n2) {
        if (n < 0 || n >= this.mResourceData.length) {
            return n2;
        }
        if (this.mResourceData[n] == null) {
            return n2;
        }
        String string2 = this.mResourceData[n].getValue();
        if ("@null".equals(string2)) {
            return n2;
        }
        try {
            return string2 == null ? n2 : XmlUtils.convertValueToInt(string2, n2);
        }
        catch (NumberFormatException numberFormatException) {
            RenderResources renderResources;
            ResourceValue resourceValue;
            Map map = null;
            if (this.mPlatformStyleable) {
                map = Bridge.getEnumValues(this.mNames[n]);
            } else if (this.mStyleableName != null && (resourceValue = (renderResources = this.mContext.getRenderResources()).getProjectResource(ResourceType.DECLARE_STYLEABLE, this.mStyleableName)) instanceof DeclareStyleableResourceValue) {
                map = ((DeclareStyleableResourceValue)resourceValue).getAttributeValues(this.mNames[n]);
            }
            if (map != null) {
                int n3 = 0;
                for (ResourceValue resourceValue2 : resourceValue = string2.split("\\|")) {
                    Integer n4 = (Integer)map.get(resourceValue2.trim());
                    if (n4 != null) {
                        n3 |= n4.intValue();
                        continue;
                    }
                    Bridge.getLog().warning("resources.format", String.format("\"%s\" in attribute \"%2$s\" is not a valid value", resourceValue2, this.mNames[n]), null);
                }
                return n3;
            }
            return n2;
        }
    }

    public float getFloat(int n, float f) {
        if (n < 0 || n >= this.mResourceData.length) {
            return f;
        }
        if (this.mResourceData[n] == null) {
            return f;
        }
        String string2 = this.mResourceData[n].getValue();
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Bridge.getLog().warning("resources.format", String.format("\"%s\" in attribute \"%2$s\" cannot be converted to float.", string2, this.mNames[n]), null);
            }
        }
        return f;
    }

    public int getColor(int n, int n2) {
        if (n < 0 || n >= this.mResourceData.length) {
            return n2;
        }
        if (this.mResourceData[n] == null) {
            return n2;
        }
        ColorStateList colorStateList = ResourceHelper.getColorStateList(this.mResourceData[n], this.mContext);
        if (colorStateList != null) {
            return colorStateList.getDefaultColor();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorStateList getColorStateList(int n) {
        if (n < 0 || n >= this.mResourceData.length) {
            return null;
        }
        if (this.mResourceData[n] == null) {
            return null;
        }
        ResourceValue resourceValue = this.mResourceData[n];
        String string2 = resourceValue.getValue();
        if (string2 == null) {
            return null;
        }
        if ("@null".equals(string2)) {
            return null;
        }
        File file = new File(string2);
        if (file.isFile()) {
            XmlPullParser xmlPullParser = ParserFactory.create(file);
            BridgeXmlBlockParser bridgeXmlBlockParser = new BridgeXmlBlockParser(xmlPullParser, this.mContext, resourceValue.isFramework());
            try {
                ColorStateList colorStateList = ColorStateList.createFromXml(this.mContext.getResources(), bridgeXmlBlockParser);
                bridgeXmlBlockParser.ensurePopped();
                return colorStateList;
            }
            catch (Throwable throwable) {
                try {
                    bridgeXmlBlockParser.ensurePopped();
                    throw throwable;
                }
                catch (XmlPullParserException xmlPullParserException) {
                    Bridge.getLog().error("broken", "Failed to configure parser for " + string2, (Throwable)xmlPullParserException, null);
                    return null;
                }
                catch (Exception exception) {
                    Bridge.getLog().error("resources.read", "Failed to parse file " + string2, (Throwable)exception, null);
                    return null;
                }
            }
        }
        try {
            int n2 = ResourceHelper.getColor(string2);
            return ColorStateList.valueOf(n2);
        }
        catch (NumberFormatException numberFormatException) {
            Bridge.getLog().error("resources.format", numberFormatException.getMessage(), (Throwable)numberFormatException, null);
            return null;
        }
    }

    public int getInteger(int n, int n2) {
        return this.getInt(n, n2);
    }

    public float getDimension(int n, float f) {
        if (n < 0 || n >= this.mResourceData.length) {
            return f;
        }
        if (this.mResourceData[n] == null) {
            return f;
        }
        String string2 = this.mResourceData[n].getValue();
        if (string2 == null) {
            return f;
        }
        if (string2.equals("match_parent") || string2.equals("fill_parent")) {
            return -1.0f;
        }
        if (string2.equals("wrap_content")) {
            return -2.0f;
        }
        if ("@null".equals(string2)) {
            return f;
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[n], string2, this.mValue, true)) {
            return this.mValue.getDimension(this.mBridgeResources.mMetrics);
        }
        Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" is not a valid format.", string2, this.mNames[n]), null);
        return f;
    }

    public int getDimensionPixelOffset(int n, int n2) {
        return (int)this.getDimension(n, n2);
    }

    public int getDimensionPixelSize(int n, int n2) {
        try {
            return this.getDimension(n);
        }
        catch (RuntimeException runtimeException) {
            String string2;
            if (this.mResourceData[n] != null && (string2 = this.mResourceData[n].getValue()) != null) {
                Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" is not a valid format.", string2, this.mNames[n]), null);
            }
            return n2;
        }
    }

    public int getLayoutDimension(int n, String string2) {
        try {
            return this.getDimension(n);
        }
        catch (RuntimeException runtimeException) {
            if (LayoutInflater_Delegate.sIsInInclude) {
                throw new RuntimeException();
            }
            Bridge.getLog().warning("resources.format", "You must supply a " + string2 + " attribute.", null);
            return 0;
        }
    }

    public int getLayoutDimension(int n, int n2) {
        return this.getDimensionPixelSize(n, n2);
    }

    private int getDimension(int n) {
        if (this.mResourceData[n] == null) {
            throw new RuntimeException();
        }
        String string2 = this.mResourceData[n].getValue();
        if (string2 == null) {
            throw new RuntimeException();
        }
        if (string2.equals("match_parent") || string2.equals("fill_parent")) {
            return -1;
        }
        if (string2.equals("wrap_content")) {
            return -2;
        }
        if ("@null".equals(string2)) {
            throw new RuntimeException();
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[n], string2, this.mValue, true)) {
            float f = this.mValue.getDimension(this.mBridgeResources.mMetrics);
            int n2 = (int)(f + 0.5f);
            if (n2 != 0) {
                return n2;
            }
            if (f == 0.0f) {
                return 0;
            }
            if (f > 0.0f) {
                return 1;
            }
        }
        throw new RuntimeException();
    }

    public float getFraction(int n, int n2, int n3, float f) {
        if (n < 0 || n >= this.mResourceData.length) {
            return f;
        }
        if (this.mResourceData[n] == null) {
            return f;
        }
        String string2 = this.mResourceData[n].getValue();
        if (string2 == null) {
            return f;
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[n], string2, this.mValue, false)) {
            return this.mValue.getFraction(n2, n3);
        }
        Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" cannot be converted to a fraction.", string2, this.mNames[n]), null);
        return f;
    }

    public int getResourceId(int n, int n2) {
        int n3;
        if (n < 0 || n >= this.mResourceData.length) {
            return n2;
        }
        ResourceValue resourceValue = this.mResourceData[n];
        if (resourceValue == null) {
            return n2;
        }
        if (resourceValue instanceof StyleResourceValue) {
            return this.mContext.getDynamicIdByStyle((StyleResourceValue)resourceValue);
        }
        if ("@null".equals(resourceValue.getValue())) {
            return n2;
        }
        if (resourceValue.getResourceType() != null) {
            if (this.mPlatformFile || resourceValue.isFramework()) {
                return this.mContext.getFrameworkResourceValue(resourceValue.getResourceType(), resourceValue.getName(), n2);
            }
            return this.mContext.getProjectResourceValue(resourceValue.getResourceType(), resourceValue.getName(), n2);
        }
        String string2 = resourceValue.getValue();
        if (string2 == null) {
            return n2;
        }
        try {
            n3 = Integer.parseInt(string2);
            if (Integer.toString(n3).equals(string2)) {
                return n3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string2.startsWith("@id/") || string2.startsWith("@+") || string2.startsWith("@android:id/")) {
            n3 = string2.indexOf(47);
            String string3 = string2.substring(n3 + 1);
            if (this.mPlatformFile || string2.startsWith("@android") || string2.startsWith("@+android")) {
                return this.mContext.getFrameworkResourceValue(ResourceType.ID, string3, n2);
            }
            return this.mContext.getProjectResourceValue(ResourceType.ID, string3, n2);
        }
        Integer n4 = null;
        n4 = resourceValue.isFramework() ? Bridge.getResourceId(resourceValue.getResourceType(), resourceValue.getName()) : this.mContext.getProjectCallback().getResourceId(resourceValue.getResourceType(), resourceValue.getName());
        if (n4 != null) {
            return n4;
        }
        Bridge.getLog().warning("resources.resolve", String.format("Unable to resolve id \"%1$s\" for attribute \"%2$s\"", string2, this.mNames[n]), (Object)resourceValue);
        return n2;
    }

    public Drawable getDrawable(int n) {
        if (n < 0 || n >= this.mResourceData.length) {
            return null;
        }
        if (this.mResourceData[n] == null) {
            return null;
        }
        ResourceValue resourceValue = this.mResourceData[n];
        String string2 = resourceValue.getValue();
        if (string2 == null || "@null".equals(string2)) {
            return null;
        }
        return ResourceHelper.getDrawable(resourceValue, this.mContext);
    }

    public CharSequence[] getTextArray(int n) {
        if (n < 0 || n >= this.mResourceData.length) {
            return null;
        }
        if (this.mResourceData[n] == null) {
            return null;
        }
        String string2 = this.mResourceData[n].getValue();
        if (string2 != null) {
            if ("@null".equals(string2)) {
                return null;
            }
            return new CharSequence[]{string2};
        }
        Bridge.getLog().warning("resources.format", String.format(String.format("Unknown value for getTextArray(%d) => %s", n, this.mResourceData[n].getName()), new Object[0]), null);
        return null;
    }

    public boolean getValue(int n, TypedValue typedValue) {
        if (n < 0 || n >= this.mResourceData.length) {
            return false;
        }
        if (this.mResourceData[n] == null) {
            return false;
        }
        String string2 = this.mResourceData[n].getValue();
        return ResourceHelper.parseFloatAttribute(this.mNames[n], string2, typedValue, false);
    }

    public boolean hasValue(int n) {
        if (n < 0 || n >= this.mResourceData.length) {
            return false;
        }
        return this.mResourceData[n] != null;
    }

    public TypedValue peekValue(int n) {
        if (n < 0 || n >= this.mResourceData.length) {
            return null;
        }
        if (this.getValue(n, this.mValue)) {
            return this.mValue;
        }
        return null;
    }

    public String getPositionDescription() {
        return "<internal -- stub if needed>";
    }

    public void recycle() {
    }

    public boolean getValueAt(int n, TypedValue typedValue) {
        return false;
    }

    public String toString() {
        return Arrays.toString(this.mResourceData);
    }
}

