/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import com.android.layoutlib.bridge.util.SparseWeakArray;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegateManager<T> {
    private final Class<T> mClass;
    private final SparseWeakArray<T> mDelegates = new SparseWeakArray();
    private final List<T> mJavaReferences = new ArrayList<T>();
    private int mDelegateCounter = 0;

    public DelegateManager(Class<T> clazz) {
        this.mClass = clazz;
    }

    public T getDelegate(int n) {
        if (n > 0) {
            T t = this.mDelegates.get(n);
            assert (t != null);
            return t;
        }
        return null;
    }

    public int addNewDelegate(T t) {
        int n = ++this.mDelegateCounter;
        this.mDelegates.put(n, t);
        assert (!this.mJavaReferences.contains(t));
        this.mJavaReferences.add(t);
        return n;
    }

    public void removeJavaReferenceFor(int n) {
        T t = this.getDelegate(n);
        this.mJavaReferences.remove(t);
    }
}

