/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import java.util.logging.Level;
import java.util.logging.Logger;

public class CloseGuard {
    public static final CloseGuard NOOP = new CloseGuard();
    public static volatile boolean ENABLED = true;
    public static volatile Reporter REPORTER = new DefaultReporter(null);
    public Throwable allocationSite;

    public static CloseGuard get() {
        if (!ENABLED) {
            return NOOP;
        }
        return new CloseGuard();
    }

    public static void setEnabled(boolean enabled) {
        ENABLED = enabled;
    }

    public static void setReporter(Reporter reporter) {
        if (reporter == null) {
            throw new NullPointerException("reporter == null");
        }
        REPORTER = reporter;
    }

    public static Reporter getReporter() {
        return REPORTER;
    }

    public void open(String closer) {
        if (closer == null) {
            throw new NullPointerException("closer == null");
        }
        if (this == NOOP || !ENABLED) {
            return;
        }
        String message = "Explicit termination method '" + closer + "' not called";
        this.allocationSite = new Throwable(message);
    }

    public void close() {
        this.allocationSite = null;
    }

    public void warnIfOpen() {
        if (this.allocationSite == null || !ENABLED) {
            return;
        }
        String message = "A resource was acquired at attached stack trace but never released. See java.io.Closeable for information on avoiding resource leaks.";
        REPORTER.report(message, this.allocationSite);
    }

    public static class 1 {
    }

    public static class DefaultReporter
    implements Reporter {
        public DefaultReporter() {
        }

        public void report(String message, Throwable allocationSite) {
            Logger.getLogger(CloseGuard.class.getName()).log(Level.WARNING, message, allocationSite);
        }

        public /* synthetic */ DefaultReporter(1 x0) {
            this();
        }
    }

    public static interface Reporter {
        public void report(String var1, Throwable var2);
    }
}

