/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;

public class IoUtils {
    public static void close(FileDescriptor fileDescriptor) throws IOException {
        OverrideMethod.invokeV("libcore.io.IoUtils#close(Ljava/io/FileDescriptor;)V", true, null);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getFd(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("libcore.io.IoUtils#getFd(Ljava/io/FileDescriptor;)I", true, null);
    }

    public static FileDescriptor newFileDescriptor(int fd) {
        FileDescriptor result = new FileDescriptor();
        IoUtils.setFd(result, fd);
        return result;
    }

    public static void pipe(int[] nArray) throws IOException {
        OverrideMethod.invokeV("libcore.io.IoUtils#pipe([I)V", true, null);
    }

    public static void setFd(FileDescriptor fileDescriptor, int n) {
        OverrideMethod.invokeV("libcore.io.IoUtils#setFd(Ljava/io/FileDescriptor;I)V", true, null);
    }

    public static void setBlocking(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        OverrideMethod.invokeV("libcore.io.IoUtils#setBlocking(Ljava/io/FileDescriptor;Z)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsByteArray(String path) throws IOException {
        byte[] byArray;
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(path, "r");
            byte[] buf = new byte[(int)f.length()];
            f.readFully(buf);
            byArray = buf;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(f);
            throw throwable;
        }
        IoUtils.closeQuietly(f);
        return byArray;
    }
}

