/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.NioUtils;
import java.nio.channels.FileChannel;
import libcore.io.BufferIterator;
import libcore.io.IoUtils;
import libcore.io.NioBufferIterator;
import org.apache.harmony.luni.platform.OSMemory;

public class MemoryMappedFile
implements Closeable {
    public int address;
    public final int size;

    public MemoryMappedFile(int address, int size) {
        this.address = address;
        this.size = size;
    }

    public static MemoryMappedFile mmap(FileChannel fc, FileChannel.MapMode mapMode, long start, long size) throws IOException {
        return MemoryMappedFile.mmap(NioUtils.getFd(fc), mapMode, start, size);
    }

    public static MemoryMappedFile mmap(FileDescriptor fd, FileChannel.MapMode mapMode, long start, long size) throws IOException {
        return MemoryMappedFile.mmap(IoUtils.getFd(fd), mapMode, start, size);
    }

    public static MemoryMappedFile mmap(int fd, FileChannel.MapMode mapMode, long start, long size) throws IOException {
        if (start < 0L) {
            throw new IllegalArgumentException("start < 0: " + start);
        }
        if (size <= 0L) {
            throw new IllegalArgumentException("size <= 0: " + size);
        }
        if (start + size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("(start + size) > Integer.MAX_VALUE");
        }
        int address = OSMemory.mmap(fd, start, size, mapMode);
        return new MemoryMappedFile(address, (int)size);
    }

    public synchronized void close() throws IOException {
        if (this.address != 0) {
            OSMemory.munmap(this.address, this.size);
            this.address = 0;
        }
    }

    public BufferIterator bigEndianIterator() {
        return new NioBufferIterator(this.address, this.size, ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN);
    }

    public BufferIterator littleEndianIterator() {
        return new NioBufferIterator(this.address, this.size, ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN);
    }

    public int size() {
        return this.size;
    }
}

