/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.internal.util;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.TimeZone;

public class ZoneInfo
extends TimeZone {
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final long MILLISECONDS_PER_400_YEARS = 12622780800000L;
    public static final long UNIX_OFFSET = 62167219200000L;
    public static final int[] NORMAL = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    public static final int[] LEAP = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    public int mRawOffset;
    public final int[] mTransitions;
    public final int[] mOffsets;
    public final byte[] mTypes;
    public final byte[] mIsDsts;
    public final boolean mUseDst;

    public ZoneInfo(String name, int[] transitions, byte[] type, int[] gmtOffsets, byte[] isDsts) {
        long latestScheduleTime;
        int lastStd;
        this.mTransitions = transitions;
        this.mTypes = type;
        this.mIsDsts = isDsts;
        this.setID(name);
        for (lastStd = this.mTransitions.length - 1; lastStd >= 0 && this.mIsDsts[this.mTypes[lastStd] & 0xFF] != 0; --lastStd) {
        }
        if (lastStd < 0) {
            lastStd = 0;
        }
        this.mRawOffset = lastStd >= this.mTypes.length ? gmtOffsets[0] : gmtOffsets[this.mTypes[lastStd] & 0xFF];
        this.mOffsets = gmtOffsets;
        int i = 0;
        while (i < this.mOffsets.length) {
            int n = i++;
            this.mOffsets[n] = this.mOffsets[n] - this.mRawOffset;
        }
        boolean usesDst = false;
        long currentUnixTime = System.currentTimeMillis() / 1000L;
        if (this.mTransitions.length > 0 && currentUnixTime < (latestScheduleTime = (long)(this.mTransitions[this.mTransitions.length - 1] & 0xFFFFFFFF))) {
            usesDst = true;
        }
        this.mUseDst = usesDst;
        this.mRawOffset *= 1000;
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        long calc = (long)(year / 400) * 12622780800000L;
        calc += (long)(year %= 400) * 31536000000L;
        calc += (long)((year + 3) / 4) * 86400000L;
        if (year > 0) {
            calc -= (long)((year - 1) / 100) * 86400000L;
        }
        boolean isLeap = year == 0 || year % 4 == 0 && year % 100 != 0;
        int[] mlen = isLeap ? LEAP : NORMAL;
        calc += (long)mlen[month] * 86400000L;
        calc += (long)(day - 1) * 86400000L;
        calc += (long)millis;
        calc -= (long)this.mRawOffset;
        return this.getOffset(calc -= 62167219200000L);
    }

    public int getOffset(long when) {
        int unix = (int)(when / 1000L);
        int trans = Arrays.binarySearch(this.mTransitions, unix);
        if (trans == -1) {
            return this.mRawOffset + this.mOffsets[0] * 1000;
        }
        if (trans < 0) {
            trans = ~trans - 1;
        }
        return this.mRawOffset + this.mOffsets[this.mTypes[trans] & 0xFF] * 1000;
    }

    public int getRawOffset() {
        return this.mRawOffset;
    }

    public void setRawOffset(int off) {
        this.mRawOffset = off;
    }

    public boolean inDaylightTime(Date when) {
        int unix = (int)(when.getTime() / 1000L);
        int trans = Arrays.binarySearch(this.mTransitions, unix);
        if (trans == -1) {
            return this.mIsDsts[0] != 0;
        }
        if (trans < 0) {
            trans = ~trans - 1;
        }
        return this.mIsDsts[this.mTypes[trans] & 0xFF] != 0;
    }

    public boolean useDaylightTime() {
        return this.mUseDst;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (!(timeZone instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo other = (ZoneInfo)timeZone;
        if (this.mUseDst != other.mUseDst) {
            return false;
        }
        if (!this.mUseDst) {
            return this.mRawOffset == other.mRawOffset;
        }
        return this.mRawOffset == other.mRawOffset && Arrays.equals(this.mOffsets, other.mOffsets) && Arrays.equals(this.mIsDsts, other.mIsDsts) && Arrays.equals(this.mTypes, other.mTypes) && Arrays.equals(this.mTransitions, other.mTransitions);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo other = (ZoneInfo)obj;
        return this.getID().equals(other.getID()) && this.hasSameRules(other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getID().hashCode();
        result = 31 * result + Arrays.hashCode(this.mOffsets);
        result = 31 * result + Arrays.hashCode(this.mIsDsts);
        result = 31 * result + this.mRawOffset;
        result = 31 * result + Arrays.hashCode(this.mTransitions);
        result = 31 * result + Arrays.hashCode(this.mTypes);
        result = 31 * result + (this.mUseDst ? 1231 : 1237);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName() + "[" + this.getID() + ",mRawOffset=" + this.mRawOffset + ",mUseDst=" + this.mUseDst + "]");
        sb.append("\n");
        Formatter f = new Formatter(sb);
        for (int i = 0; i < this.mTransitions.length; ++i) {
            int type = this.mTypes[i] & 0xFF;
            String utcTime = ZoneInfo.formatTime(this.mTransitions[i], TimeZone.getTimeZone("UTC"));
            String localTime = ZoneInfo.formatTime(this.mTransitions[i], this);
            int offset = this.mOffsets[type];
            int gmtOffset = this.mRawOffset / 1000 + offset;
            f.format("%4d : time=%10d %s = %s isDst=%d offset=%5d gmtOffset=%d\n", i, this.mTransitions[i], utcTime, localTime, this.mIsDsts[type], offset, gmtOffset);
        }
        return sb.toString();
    }

    public static String formatTime(int s, TimeZone tz) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy zzz");
        sdf.setTimeZone(tz);
        long ms = (long)s * 1000L;
        return sdf.format(new Date(ms));
    }
}

