/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x501;

import java.io.IOException;
import java.nio.charset.Charsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.harmony.security.Util;
import org.apache.harmony.security.asn1.ASN1Oid;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.asn1.ObjectIdentifier;
import org.apache.harmony.security.x501.AttributeValue;
import org.apache.harmony.security.x501.DirectoryString;

public class AttributeTypeAndValue {
    public static final org.apache.harmony.security.utils.ObjectIdentifier C;
    public static final org.apache.harmony.security.utils.ObjectIdentifier CN;
    public static final org.apache.harmony.security.utils.ObjectIdentifier DC;
    public static final org.apache.harmony.security.utils.ObjectIdentifier DNQ;
    public static final org.apache.harmony.security.utils.ObjectIdentifier DNQUALIFIER;
    public static final org.apache.harmony.security.utils.ObjectIdentifier EMAILADDRESS;
    public static final org.apache.harmony.security.utils.ObjectIdentifier GENERATION;
    public static final org.apache.harmony.security.utils.ObjectIdentifier GIVENNAME;
    public static final org.apache.harmony.security.utils.ObjectIdentifier INITIALS;
    public static final org.apache.harmony.security.utils.ObjectIdentifier L;
    public static final org.apache.harmony.security.utils.ObjectIdentifier O;
    public static final org.apache.harmony.security.utils.ObjectIdentifier OU;
    public static final org.apache.harmony.security.utils.ObjectIdentifier SERIALNUMBER;
    public static final org.apache.harmony.security.utils.ObjectIdentifier ST;
    public static final org.apache.harmony.security.utils.ObjectIdentifier STREET;
    public static final org.apache.harmony.security.utils.ObjectIdentifier SURNAME;
    public static final org.apache.harmony.security.utils.ObjectIdentifier T;
    public static final org.apache.harmony.security.utils.ObjectIdentifier UID;
    public static final int CAPACITY;
    public static final int SIZE;
    public static final org.apache.harmony.security.utils.ObjectIdentifier[][] KNOWN_OIDS;
    public static final HashMap KNOWN_NAMES;
    public static final HashMap RFC1779_NAMES;
    public static final HashMap RFC2253_NAMES;
    public static final HashMap RFC2459_NAMES;
    public final org.apache.harmony.security.utils.ObjectIdentifier oid;
    public final AttributeValue value;
    public static final ASN1Type attributeValue;
    public static final ASN1Sequence ASN1;

    public AttributeTypeAndValue(int[] oid, AttributeValue value) throws IOException {
        org.apache.harmony.security.utils.ObjectIdentifier thisOid = AttributeTypeAndValue.getOID(oid);
        if (thisOid == null) {
            thisOid = new org.apache.harmony.security.utils.ObjectIdentifier(oid);
        }
        this.oid = thisOid;
        this.value = value;
    }

    public AttributeTypeAndValue(String sOid, AttributeValue value) throws IOException {
        if (sOid.charAt(0) >= '0' && sOid.charAt(0) <= '9') {
            int[] array2 = ObjectIdentifier.toIntArray(sOid);
            org.apache.harmony.security.utils.ObjectIdentifier thisOid = AttributeTypeAndValue.getOID(array2);
            if (thisOid == null) {
                thisOid = new org.apache.harmony.security.utils.ObjectIdentifier(array2);
            }
            this.oid = thisOid;
        } else {
            this.oid = (org.apache.harmony.security.utils.ObjectIdentifier)KNOWN_NAMES.get(Util.toUpperCase(sOid));
            if (this.oid == null) {
                throw new IOException("Unrecognizable attribute name: " + sOid);
            }
        }
        this.value = value;
    }

    public void appendName(String attrFormat, StringBuffer buf) {
        boolean hexFormat = false;
        if ("RFC1779".equals(attrFormat)) {
            if (RFC1779_NAMES == this.oid.getGroup()) {
                buf.append(this.oid.getName());
            } else {
                buf.append(this.oid.toOIDString());
            }
            buf.append('=');
            if (this.value.escapedString == this.value.getHexString()) {
                buf.append(Util.toUpperCase(this.value.getHexString()));
            } else if (this.value.escapedString.length() != this.value.rawString.length()) {
                this.value.appendQEString(buf);
            } else {
                buf.append(this.value.escapedString);
            }
        } else {
            Object group = this.oid.getGroup();
            if (RFC1779_NAMES == group || RFC2253_NAMES == group) {
                int tag;
                buf.append(this.oid.getName());
                if ("CANONICAL".equals(attrFormat) && !ASN1StringType.UTF8STRING.checkTag(tag = this.value.getTag()) && !ASN1StringType.PRINTABLESTRING.checkTag(tag) && !ASN1StringType.TELETEXSTRING.checkTag(tag)) {
                    hexFormat = true;
                }
            } else {
                buf.append(this.oid.toString());
                hexFormat = true;
            }
            buf.append('=');
            if (hexFormat) {
                buf.append(this.value.getHexString());
            } else if ("CANONICAL".equals(attrFormat)) {
                buf.append(this.value.makeCanonical());
            } else {
                buf.append(this.value.escapedString);
            }
        }
    }

    public org.apache.harmony.security.utils.ObjectIdentifier getType() {
        return this.oid;
    }

    public static org.apache.harmony.security.utils.ObjectIdentifier getOID(int[] oid) {
        int index = AttributeTypeAndValue.hashIntArray(oid) % CAPACITY;
        org.apache.harmony.security.utils.ObjectIdentifier[] list = KNOWN_OIDS[index];
        int i = 0;
        while (list[i] != null) {
            if (Arrays.equals(oid, list[i].getOid())) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    public static void addOID(org.apache.harmony.security.utils.ObjectIdentifier oid) {
        int[] newOid = oid.getOid();
        int index = AttributeTypeAndValue.hashIntArray(newOid) % CAPACITY;
        org.apache.harmony.security.utils.ObjectIdentifier[] list = KNOWN_OIDS[index];
        int i = 0;
        while (list[i] != null) {
            if (Arrays.equals(newOid, list[i].getOid())) {
                throw new Error("ObjectIdentifier: invalid static initialization; duplicate OIDs: " + oid.getName() + " " + list[i].getName());
            }
            ++i;
        }
        if (i == CAPACITY - 1) {
            throw new Error("ObjectIdentifier: invalid static initialization; small OID pool capacity");
        }
        list[i] = oid;
    }

    public static int hashIntArray(int[] oid) {
        int intHash = 0;
        for (int i = 0; i < oid.length && i < 4; ++i) {
            intHash += oid[i] << 8 * i;
        }
        return intHash & Integer.MAX_VALUE;
    }

    public /* synthetic */ AttributeTypeAndValue(int[] x0, AttributeValue x1, 1 x2) throws IOException {
        this(x0, x1);
    }

    static {
        KNOWN_NAMES = new HashMap(30);
        RFC1779_NAMES = new HashMap(10);
        RFC2253_NAMES = new HashMap(10);
        RFC2459_NAMES = new HashMap(10);
        CAPACITY = 10;
        SIZE = 10;
        KNOWN_OIDS = new org.apache.harmony.security.utils.ObjectIdentifier[SIZE][CAPACITY];
        C = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 6}, "C", RFC1779_NAMES);
        CN = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 3}, "CN", RFC1779_NAMES);
        DC = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{0, 9, 2342, 19200300, 100, 1, 25}, "DC", RFC2253_NAMES);
        DNQ = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 46}, "DNQ", RFC2459_NAMES);
        DNQUALIFIER = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 46}, "DNQUALIFIER", RFC2459_NAMES);
        EMAILADDRESS = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 9, 1}, "EMAILADDRESS", RFC2459_NAMES);
        GENERATION = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 44}, "GENERATION", RFC2459_NAMES);
        GIVENNAME = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 42}, "GIVENNAME", RFC2459_NAMES);
        INITIALS = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 43}, "INITIALS", RFC2459_NAMES);
        L = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 7}, "L", RFC1779_NAMES);
        O = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 10}, "O", RFC1779_NAMES);
        OU = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 11}, "OU", RFC1779_NAMES);
        SERIALNUMBER = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 5}, "SERIALNUMBER", RFC2459_NAMES);
        ST = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 8}, "ST", RFC1779_NAMES);
        STREET = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 9}, "STREET", RFC1779_NAMES);
        SURNAME = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 4}, "SURNAME", RFC2459_NAMES);
        T = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{2, 5, 4, 12}, "T", RFC2459_NAMES);
        UID = new org.apache.harmony.security.utils.ObjectIdentifier(new int[]{0, 9, 2342, 19200300, 100, 1, 1}, "UID", RFC2253_NAMES);
        RFC1779_NAMES.put(CN.getName(), CN);
        RFC1779_NAMES.put(L.getName(), L);
        RFC1779_NAMES.put(ST.getName(), ST);
        RFC1779_NAMES.put(O.getName(), O);
        RFC1779_NAMES.put(OU.getName(), OU);
        RFC1779_NAMES.put(C.getName(), C);
        RFC1779_NAMES.put(STREET.getName(), STREET);
        RFC2253_NAMES.putAll(RFC1779_NAMES);
        RFC2253_NAMES.put(DC.getName(), DC);
        RFC2253_NAMES.put(UID.getName(), UID);
        RFC2459_NAMES.put(DNQ.getName(), DNQ);
        RFC2459_NAMES.put(DNQUALIFIER.getName(), DNQUALIFIER);
        RFC2459_NAMES.put(EMAILADDRESS.getName(), EMAILADDRESS);
        RFC2459_NAMES.put(GENERATION.getName(), GENERATION);
        RFC2459_NAMES.put(GIVENNAME.getName(), GIVENNAME);
        RFC2459_NAMES.put(INITIALS.getName(), INITIALS);
        RFC2459_NAMES.put(SERIALNUMBER.getName(), SERIALNUMBER);
        RFC2459_NAMES.put(SURNAME.getName(), SURNAME);
        RFC2459_NAMES.put(T.getName(), T);
        Iterator it = RFC2253_NAMES.values().iterator();
        while (it.hasNext()) {
            AttributeTypeAndValue.addOID((org.apache.harmony.security.utils.ObjectIdentifier)it.next());
        }
        for (Object o : RFC2459_NAMES.values()) {
            if (o == DNQUALIFIER) continue;
            AttributeTypeAndValue.addOID((org.apache.harmony.security.utils.ObjectIdentifier)o);
        }
        KNOWN_NAMES.putAll(RFC2253_NAMES);
        KNOWN_NAMES.putAll(RFC2459_NAMES);
        attributeValue = new ASN1Type(19){

            public boolean checkTag(int tag) {
                return true;
            }

            public Object decode(BerInputStream in) throws IOException {
                String str = null;
                if (DirectoryString.ASN1.checkTag(in.tag)) {
                    str = (String)DirectoryString.ASN1.decode(in);
                } else {
                    in.readContent();
                }
                byte[] bytesEncoded = new byte[in.getOffset() - in.getTagOffset()];
                System.arraycopy(in.getBuffer(), in.getTagOffset(), bytesEncoded, 0, bytesEncoded.length);
                return new AttributeValue(str, bytesEncoded, in.tag);
            }

            public Object getDecodedObject(BerInputStream in) throws IOException {
                throw new RuntimeException("AttributeValue getDecodedObject MUST NOT be invoked");
            }

            public void encodeASN(BerOutputStream out) {
                AttributeValue av = (AttributeValue)out.content;
                if (av.encoded != null) {
                    out.content = av.encoded;
                    out.encodeANY();
                } else {
                    out.encodeTag(av.getTag());
                    out.content = av.bytes;
                    out.encodeString();
                }
            }

            public void setEncodingContent(BerOutputStream out) {
                AttributeValue av = (AttributeValue)out.content;
                if (av.encoded != null) {
                    out.length = av.encoded.length;
                } else if (av.getTag() == 12) {
                    out.content = av.rawString;
                    ASN1StringType.UTF8STRING.setEncodingContent(out);
                    av.bytes = (byte[])out.content;
                    out.content = av;
                } else {
                    av.bytes = av.rawString.getBytes(Charsets.UTF_8);
                    out.length = av.bytes.length;
                }
            }

            public void encodeContent(BerOutputStream out) {
                throw new RuntimeException("AttributeValue encodeContent MUST NOT be invoked");
            }

            public int getEncodedLength(BerOutputStream out) {
                AttributeValue av = (AttributeValue)out.content;
                if (av.encoded != null) {
                    return out.length;
                }
                return super.getEncodedLength(out);
            }
        };
        ASN1 = new ASN1Sequence(new ASN1Type[]{ASN1Oid.getInstance(), attributeValue}){

            public Object getDecodedObject(BerInputStream in) throws IOException {
                Object[] values = (Object[])in.content;
                return new AttributeTypeAndValue((int[])values[0], (AttributeValue)values[1], null);
            }

            public void getValues(Object object, Object[] values) {
                AttributeTypeAndValue atav = (AttributeTypeAndValue)object;
                values[0] = atav.oid.getOid();
                values[1] = atav.value;
            }
        };
    }
}

