/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.provider.cert.X509CertImpl;
import org.apache.harmony.xnet.provider.jsse.AbstractSessionContext;
import org.apache.harmony.xnet.provider.jsse.CipherSuite;
import org.apache.harmony.xnet.provider.jsse.ClientSessionContext;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSessionImpl;
import org.apache.harmony.xnet.provider.jsse.SSLParametersImpl;
import org.apache.harmony.xnet.provider.jsse.SSLSessionImpl;

public class OpenSSLSocketImpl
extends SSLSocket
implements NativeCrypto.SSLHandshakeCallbacks {
    public int sslNativePointer;
    public InputStream is;
    public OutputStream os;
    public final Object handshakeLock = new Object();
    public final Object readLock = new Object();
    public final Object writeLock = new Object();
    public SSLParametersImpl sslParameters;
    public String[] enabledProtocols;
    public String[] enabledCipherSuites;
    public String[] enabledCompressionMethods;
    public boolean useSessionTickets;
    public String hostname;
    public OpenSSLSessionImpl sslSession;
    public final Socket socket;
    public final FileDescriptor fd;
    public boolean autoClose;
    public boolean handshakeStarted = false;
    public final CloseGuard guard = CloseGuard.get();
    public boolean handshakeCompleted = false;
    public ArrayList<HandshakeCompletedListener> listeners;
    public int timeoutMilliseconds = 0;
    public int handshakeTimeoutMilliseconds = -1;
    public String wrappedHost;
    public int wrappedPort;

    public OpenSSLSocketImpl(SSLParametersImpl sslParameters) throws IOException {
        this.socket = this;
        this.fd = NativeCrypto.getFileDescriptor(this.socket);
        this.init(sslParameters);
    }

    public OpenSSLSocketImpl(SSLParametersImpl sslParameters, String[] enabledProtocols, String[] enabledCipherSuites, String[] enabledCompressionMethods) throws IOException {
        this.socket = this;
        this.fd = NativeCrypto.getFileDescriptor(this.socket);
        this.init(sslParameters, enabledProtocols, enabledCipherSuites, enabledCompressionMethods);
    }

    public OpenSSLSocketImpl(String host, int port, SSLParametersImpl sslParameters) throws IOException {
        super(host, port);
        this.socket = this;
        this.fd = NativeCrypto.getFileDescriptor(this.socket);
        this.init(sslParameters);
    }

    public OpenSSLSocketImpl(InetAddress address, int port, SSLParametersImpl sslParameters) throws IOException {
        super(address, port);
        this.socket = this;
        this.fd = NativeCrypto.getFileDescriptor(this.socket);
        this.init(sslParameters);
    }

    public OpenSSLSocketImpl(String host, int port, InetAddress clientAddress, int clientPort, SSLParametersImpl sslParameters) throws IOException {
        super(host, port, clientAddress, clientPort);
        this.socket = this;
        this.fd = NativeCrypto.getFileDescriptor(this.socket);
        this.init(sslParameters);
    }

    public OpenSSLSocketImpl(InetAddress address, int port, InetAddress clientAddress, int clientPort, SSLParametersImpl sslParameters) throws IOException {
        super(address, port, clientAddress, clientPort);
        this.socket = this;
        this.fd = NativeCrypto.getFileDescriptor(this.socket);
        this.init(sslParameters);
    }

    public OpenSSLSocketImpl(Socket socket, String host, int port, boolean autoClose, SSLParametersImpl sslParameters) throws IOException {
        this.socket = socket;
        this.fd = NativeCrypto.getFileDescriptor(socket);
        this.wrappedHost = host;
        this.wrappedPort = port;
        this.autoClose = autoClose;
        this.init(sslParameters);
    }

    public void init(SSLParametersImpl sslParameters) throws IOException {
        this.init(sslParameters, NativeCrypto.getSupportedProtocols(), NativeCrypto.getDefaultCipherSuites(), NativeCrypto.getDefaultCompressionMethods());
    }

    public void init(SSLParametersImpl sslParameters, String[] enabledProtocols, String[] enabledCipherSuites, String[] enabledCompressionMethods) throws IOException {
        this.sslParameters = sslParameters;
        this.enabledProtocols = enabledProtocols;
        this.enabledCipherSuites = enabledCipherSuites;
        this.enabledCompressionMethods = enabledCompressionMethods;
    }

    public OpenSSLSessionImpl getCachedClientSession(ClientSessionContext sessionContext) {
        if (super.getInetAddress() == null || super.getInetAddress().getHostAddress() == null || super.getInetAddress().getHostName() == null) {
            return null;
        }
        OpenSSLSessionImpl session = (OpenSSLSessionImpl)sessionContext.getSession(super.getInetAddress().getHostName(), super.getPort());
        if (session == null) {
            return null;
        }
        String protocol = session.getProtocol();
        boolean protocolFound = false;
        for (String enabledProtocol : this.enabledProtocols) {
            if (!protocol.equals(enabledProtocol)) continue;
            protocolFound = true;
            break;
        }
        if (!protocolFound) {
            return null;
        }
        String cipherSuite = session.getCipherSuite();
        boolean cipherSuiteFound = false;
        for (String enabledCipherSuite : this.enabledCipherSuites) {
            if (!cipherSuite.equals(enabledCipherSuite)) continue;
            cipherSuiteFound = true;
            break;
        }
        if (!cipherSuiteFound) {
            return null;
        }
        String compressionMethod = session.getCompressionMethod();
        boolean compressionMethodFound = false;
        for (String enabledCompressionMethod : this.enabledCompressionMethods) {
            if (!compressionMethod.equals(enabledCompressionMethod)) continue;
            compressionMethodFound = true;
            break;
        }
        if (!compressionMethodFound) {
            return null;
        }
        return session;
    }

    public void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    public void checkOpen() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startHandshake(boolean full) throws IOException {
        Object object = this.handshakeLock;
        synchronized (object) {
            this.checkOpen();
            if (this.handshakeStarted) {
                return;
            }
            this.handshakeStarted = true;
        }
        int seedLengthInBytes = 1024;
        SecureRandom secureRandom = this.sslParameters.getSecureRandomMember();
        if (secureRandom == null) {
            NativeCrypto.RAND_load_file("/dev/urandom", 1024L);
        } else {
            NativeCrypto.RAND_seed(secureRandom.generateSeed(1024));
        }
        boolean client = this.sslParameters.getUseClientMode();
        int sslCtxNativePointer = client ? this.sslParameters.getClientSessionContext().sslCtxNativePointer : this.sslParameters.getServerSessionContext().sslCtxNativePointer;
        this.sslNativePointer = 0;
        boolean exception = true;
        try {
            int sslSessionNativePointer;
            AbstractSessionContext sessionContext;
            boolean enableSessionCreation;
            this.sslNativePointer = NativeCrypto.SSL_new(sslCtxNativePointer);
            this.guard.open("close");
            if (!client) {
                HashSet<String> keyTypes = new HashSet<String>();
                for (String enabledCipherSuite : this.enabledCipherSuites) {
                    String keyType;
                    if (enabledCipherSuite.equals(NativeCrypto.TLS_EMPTY_RENEGOTIATION_INFO_SCSV) || (keyType = CipherSuite.getByName(enabledCipherSuite).getServerKeyType()) == null) continue;
                    keyTypes.add(keyType);
                }
                for (String keyType : keyTypes) {
                    try {
                        this.setCertificate(this.sslParameters.getKeyManager().chooseServerAlias(keyType, null, this));
                    }
                    catch (CertificateEncodingException e) {
                        throw new IOException(e);
                    }
                }
            }
            NativeCrypto.setEnabledProtocols(this.sslNativePointer, this.enabledProtocols);
            NativeCrypto.setEnabledCipherSuites(this.sslNativePointer, this.enabledCipherSuites);
            if (this.enabledCompressionMethods.length != 0) {
                NativeCrypto.setEnabledCompressionMethods(this.sslNativePointer, this.enabledCompressionMethods);
            }
            if (this.useSessionTickets) {
                NativeCrypto.SSL_clear_options(this.sslNativePointer, NativeCrypto.SSL_OP_NO_TICKET);
            }
            if (this.hostname != null) {
                NativeCrypto.SSL_set_tlsext_host_name(this.sslNativePointer, this.hostname);
            }
            if (!(enableSessionCreation = this.sslParameters.getEnableSessionCreation())) {
                NativeCrypto.SSL_set_session_creation_enabled(this.sslNativePointer, enableSessionCreation);
            }
            if (client) {
                ClientSessionContext clientSessionContext = this.sslParameters.getClientSessionContext();
                sessionContext = clientSessionContext;
                OpenSSLSessionImpl session = this.getCachedClientSession(clientSessionContext);
                if (session != null) {
                    NativeCrypto.SSL_set_session(this.sslNativePointer, session.sslSessionNativePointer);
                }
            } else {
                sessionContext = this.sslParameters.getServerSessionContext();
                Object session = null;
            }
            if (!client) {
                X509TrustManager trustManager;
                X509Certificate[] issuers;
                boolean certRequested = false;
                if (this.sslParameters.getNeedClientAuth()) {
                    NativeCrypto.SSL_set_verify(this.sslNativePointer, 3);
                    certRequested = true;
                } else if (this.sslParameters.getWantClientAuth()) {
                    NativeCrypto.SSL_set_verify(this.sslNativePointer, 1);
                    certRequested = true;
                } else {
                    certRequested = false;
                }
                if (certRequested && (issuers = (trustManager = this.sslParameters.getTrustManager()).getAcceptedIssuers()) != null && issuers.length != 0) {
                    byte[][] issuersBytes;
                    try {
                        issuersBytes = NativeCrypto.encodeIssuerX509Principals(issuers);
                    }
                    catch (CertificateEncodingException e) {
                        throw new IOException("Problem encoding principals", e);
                    }
                    NativeCrypto.SSL_set_client_CA_list(this.sslNativePointer, issuersBytes);
                }
            }
            if (client && full) {
                NativeCrypto.SSL_clear_mode(this.sslNativePointer, NativeCrypto.SSL_MODE_HANDSHAKE_CUTTHROUGH);
            }
            int savedTimeoutMilliseconds = this.getSoTimeout();
            if (this.handshakeTimeoutMilliseconds >= 0) {
                this.setSoTimeout(this.handshakeTimeoutMilliseconds);
            }
            try {
                sslSessionNativePointer = NativeCrypto.SSL_do_handshake(this.sslNativePointer, this.fd, this, this.getSoTimeout(), client);
            }
            catch (CertificateException e) {
                SSLHandshakeException wrapper = new SSLHandshakeException(e.getMessage());
                wrapper.initCause(e);
                throw wrapper;
            }
            byte[] sessionId = NativeCrypto.SSL_SESSION_session_id(sslSessionNativePointer);
            this.sslSession = (OpenSSLSessionImpl)sessionContext.getSession(sessionId);
            if (this.sslSession != null) {
                this.sslSession.lastAccessedTime = System.currentTimeMillis();
                LoggerHolder.logger.fine("Reused cached session for " + this.getInetAddress() + ".");
                NativeCrypto.SSL_SESSION_free(sslSessionNativePointer);
            } else {
                if (!enableSessionCreation) {
                    throw new IllegalStateException("SSL Session may not be created");
                }
                X509Certificate[] localCertificates = OpenSSLSocketImpl.createCertChain(NativeCrypto.SSL_get_certificate(this.sslNativePointer));
                X509Certificate[] peerCertificates = OpenSSLSocketImpl.createCertChain(NativeCrypto.SSL_get_peer_cert_chain(this.sslNativePointer));
                this.sslSession = this.wrappedHost == null ? new OpenSSLSessionImpl(sslSessionNativePointer, localCertificates, peerCertificates, super.getInetAddress().getHostName(), super.getPort(), sessionContext) : new OpenSSLSessionImpl(sslSessionNativePointer, localCertificates, peerCertificates, this.wrappedHost, this.wrappedPort, sessionContext);
                if (this.handshakeCompleted) {
                    sessionContext.putSession(this.sslSession);
                }
                LoggerHolder.logger.fine("Created new session for " + this.getInetAddress().getHostName() + ".");
            }
            if (this.handshakeTimeoutMilliseconds >= 0) {
                this.setSoTimeout(savedTimeoutMilliseconds);
            }
            if (this.handshakeCompleted) {
                this.notifyHandshakeCompletedListeners();
            }
            exception = false;
        }
        finally {
            if (exception) {
                this.close();
            }
        }
    }

    public static X509Certificate[] createCertChain(byte[][] certificatesBytes) {
        if (certificatesBytes == null) {
            return null;
        }
        X509Certificate[] certificates = new X509Certificate[certificatesBytes.length];
        for (int i = 0; i < certificatesBytes.length; ++i) {
            try {
                certificates[i] = new X509CertImpl(certificatesBytes[i]);
                continue;
            }
            catch (IOException e) {
                return null;
            }
        }
        return certificates;
    }

    public void setCertificate(String alias) throws CertificateEncodingException, SSLException {
        if (alias == null) {
            return;
        }
        PrivateKey privateKey = this.sslParameters.getKeyManager().getPrivateKey(alias);
        byte[] privateKeyBytes = privateKey.getEncoded();
        NativeCrypto.SSL_use_PrivateKey(this.sslNativePointer, privateKeyBytes);
        Certificate[] certificates = this.sslParameters.getKeyManager().getCertificateChain(alias);
        byte[][] certificateBytes = NativeCrypto.encodeCertificates(certificates);
        NativeCrypto.SSL_use_certificate(this.sslNativePointer, certificateBytes);
        NativeCrypto.SSL_check_private_key(this.sslNativePointer);
    }

    public void clientCertificateRequested(byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals) throws CertificateEncodingException, SSLException {
        Principal[] issuers;
        String[] keyTypes = new String[keyTypeBytes.length];
        for (int i = 0; i < keyTypeBytes.length; ++i) {
            keyTypes[i] = CipherSuite.getClientKeyType(keyTypeBytes[i]);
        }
        if (asn1DerEncodedPrincipals == null) {
            issuers = null;
        } else {
            issuers = new X500Principal[asn1DerEncodedPrincipals.length];
            for (int i = 0; i < asn1DerEncodedPrincipals.length; ++i) {
                issuers[i] = new X500Principal(asn1DerEncodedPrincipals[i]);
            }
        }
        this.setCertificate(this.sslParameters.getKeyManager().chooseClientAlias(keyTypes, issuers, this));
    }

    public void handshakeCompleted() {
        this.handshakeCompleted = true;
        if (this.sslSession == null) {
            return;
        }
        this.sslSession.resetId();
        AbstractSessionContext sessionContext = this.sslParameters.getUseClientMode() ? this.sslParameters.getClientSessionContext() : this.sslParameters.getServerSessionContext();
        sessionContext.putSession(this.sslSession);
        this.notifyHandshakeCompletedListeners();
    }

    public void notifyHandshakeCompletedListeners() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.sslSession);
            for (HandshakeCompletedListener listener : this.listeners) {
                try {
                    listener.handshakeCompleted(event);
                }
                catch (RuntimeException e) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                }
            }
        }
    }

    public void verifyCertificateChain(byte[][] bytes, String authMethod) throws CertificateException {
        try {
            if (bytes == null || bytes.length == 0) {
                throw new SSLException("Peer sent no certificate");
            }
            X509Certificate[] peerCertificateChain = new X509Certificate[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                peerCertificateChain[i] = new X509CertImpl(bytes[i]);
            }
            boolean client = this.sslParameters.getUseClientMode();
            if (client) {
                this.sslParameters.getTrustManager().checkServerTrusted(peerCertificateChain, authMethod);
            } else {
                String authType = peerCertificateChain[0].getPublicKey().getAlgorithm();
                this.sslParameters.getTrustManager().checkClientTrusted(peerCertificateChain, authType);
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        this.checkOpen();
        OpenSSLSocketImpl openSSLSocketImpl = this;
        synchronized (openSSLSocketImpl) {
            if (this.is == null) {
                this.is = new SSLInputStream();
            }
            return this.is;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        this.checkOpen();
        OpenSSLSocketImpl openSSLSocketImpl = this;
        synchronized (openSSLSocketImpl) {
            if (this.os == null) {
                this.os = new SSLOutputStream();
            }
            return this.os;
        }
    }

    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException();
    }

    public SSLSession getSession() {
        if (this.sslSession == null) {
            try {
                this.startHandshake(true);
            }
            catch (IOException e) {
                return SSLSessionImpl.NULL_SESSION;
            }
        }
        return this.sslSession;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
    }

    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledCipherSuites.clone();
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = NativeCrypto.checkEnabledCipherSuites(suites);
    }

    public String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    public String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = NativeCrypto.checkEnabledProtocols(protocols);
    }

    public String[] getSupportedCompressionMethods() {
        return NativeCrypto.getSupportedCompressionMethods();
    }

    public String[] getEnabledCompressionMethods() {
        return (String[])this.enabledCompressionMethods.clone();
    }

    public void setEnabledCompressionMethods(String[] methods) {
        this.enabledCompressionMethods = NativeCrypto.checkEnabledCompressionMethods(methods);
    }

    public void setUseSessionTickets(boolean useSessionTickets) {
        this.useSessionTickets = useSessionTickets;
    }

    public boolean getUseSessionTickets() {
        return this.useSessionTickets;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    public void setUseClientMode(boolean mode) {
        if (this.handshakeStarted) {
            throw new IllegalArgumentException("Could not change the mode after the initial handshake has begun.");
        }
        this.sslParameters.setUseClientMode(mode);
    }

    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Method sendUrgentData() is not supported.");
    }

    public void setOOBInline(boolean on) throws SocketException {
        throw new SocketException("Methods sendUrgentData, setOOBInline are not supported.");
    }

    public void setSoTimeout(int timeoutMilliseconds) throws SocketException {
        super.setSoTimeout(timeoutMilliseconds);
        this.timeoutMilliseconds = timeoutMilliseconds;
    }

    public int getSoTimeout() throws SocketException {
        return this.timeoutMilliseconds;
    }

    public void setHandshakeTimeout(int timeoutMilliseconds) throws SocketException {
        this.handshakeTimeoutMilliseconds = timeoutMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (!this.handshakeStarted) {
                this.handshakeStarted = true;
                OpenSSLSocketImpl openSSLSocketImpl = this;
                synchronized (openSSLSocketImpl) {
                    this.free();
                    if (this.socket != this) {
                        if (this.autoClose && !this.socket.isClosed()) {
                            this.socket.close();
                        }
                    } else if (!super.isClosed()) {
                        super.close();
                    }
                }
                return;
            }
        }
        NativeCrypto.SSL_interrupt(this.sslNativePointer);
        object = this;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.readLock;
                synchronized (object3) {
                    try {
                        if (this.handshakeStarted) {
                            BlockGuard.getThreadPolicy().onNetwork();
                            NativeCrypto.SSL_shutdown(this.sslNativePointer, this.fd, this);
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    this.free();
                    if (this.socket != this) {
                        if (this.autoClose && !this.socket.isClosed()) {
                            this.socket.close();
                        }
                    } else if (!super.isClosed()) {
                        super.close();
                    }
                }
            }
        }
    }

    public void free() {
        if (this.sslNativePointer == 0) {
            return;
        }
        NativeCrypto.SSL_free(this.sslNativePointer);
        this.sslNativePointer = 0;
        this.guard.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    public class SSLOutputStream
    extends OutputStream {
        public SSLOutputStream() throws IOException {
            OpenSSLSocketImpl.this.startHandshake(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            Object object = OpenSSLSocketImpl.this.writeLock;
            synchronized (object) {
                OpenSSLSocketImpl.this.checkOpen();
                NativeCrypto.SSL_write_byte(OpenSSLSocketImpl.this.sslNativePointer, OpenSSLSocketImpl.this.fd, OpenSSLSocketImpl.this, b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int offset, int byteCount) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            Object object = OpenSSLSocketImpl.this.writeLock;
            synchronized (object) {
                OpenSSLSocketImpl.this.checkOpen();
                Arrays.checkOffsetAndCount((int)buf.length, (int)offset, (int)byteCount);
                if (byteCount == 0) {
                    return;
                }
                NativeCrypto.SSL_write(OpenSSLSocketImpl.this.sslNativePointer, OpenSSLSocketImpl.this.fd, OpenSSLSocketImpl.this, buf, offset, byteCount);
            }
        }
    }

    public class SSLInputStream
    extends InputStream {
        public SSLInputStream() throws IOException {
            OpenSSLSocketImpl.this.startHandshake(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            Object object = OpenSSLSocketImpl.this.readLock;
            synchronized (object) {
                OpenSSLSocketImpl.this.checkOpen();
                return NativeCrypto.SSL_read_byte(OpenSSLSocketImpl.this.sslNativePointer, OpenSSLSocketImpl.this.fd, OpenSSLSocketImpl.this, OpenSSLSocketImpl.this.getSoTimeout());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] buf, int offset, int byteCount) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            Object object = OpenSSLSocketImpl.this.readLock;
            synchronized (object) {
                OpenSSLSocketImpl.this.checkOpen();
                Arrays.checkOffsetAndCount((int)buf.length, (int)offset, (int)byteCount);
                if (byteCount == 0) {
                    return 0;
                }
                return NativeCrypto.SSL_read(OpenSSLSocketImpl.this.sslNativePointer, OpenSSLSocketImpl.this.fd, OpenSSLSocketImpl.this, buf, offset, byteCount, OpenSSLSocketImpl.this.getSoTimeout());
            }
        }
    }

    public static class LoggerHolder {
        public static final Logger logger = Logger.getLogger(OpenSSLSocketImpl.class.getName());
    }
}

