/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.FloatEvaluator;
import android.animation.FloatKeyframeSet;
import android.animation.IntEvaluator;
import android.animation.IntKeyframeSet;
import android.animation.Keyframe;
import android.animation.KeyframeSet;
import android.animation.PropertyValuesHolder_Delegate;
import android.animation.TypeEvaluator;
import android.util.Log;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyValuesHolder
implements Cloneable {
    public String mPropertyName;
    public Method mSetter = null;
    public Method mGetter = null;
    public Class mValueType;
    public KeyframeSet mKeyframeSet = null;
    public static final TypeEvaluator sIntEvaluator = new IntEvaluator();
    public static final TypeEvaluator sFloatEvaluator = new FloatEvaluator();
    public static Class[] FLOAT_VARIANTS = new Class[]{Float.TYPE, Float.class, Double.TYPE, Integer.TYPE, Double.class, Integer.class};
    public static Class[] INTEGER_VARIANTS = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Double.TYPE, Float.class, Double.class};
    public static Class[] DOUBLE_VARIANTS = new Class[]{Double.TYPE, Double.class, Float.TYPE, Integer.TYPE, Float.class, Integer.class};
    public static final HashMap<Class, HashMap<String, Method>> sSetterPropertyMap = new HashMap();
    public static final HashMap<Class, HashMap<String, Method>> sGetterPropertyMap = new HashMap();
    public final ReentrantReadWriteLock mPropertyMapLock = new ReentrantReadWriteLock();
    public final Object[] mTmpValueArray = new Object[1];
    public TypeEvaluator mEvaluator;
    public Object mAnimatedValue;

    public PropertyValuesHolder(String propertyName) {
        this.mPropertyName = propertyName;
    }

    public static PropertyValuesHolder ofInt(String propertyName, int ... values) {
        IntPropertyValuesHolder pvh = new IntPropertyValuesHolder(propertyName, values);
        return pvh;
    }

    public static PropertyValuesHolder ofFloat(String propertyName, float ... values) {
        FloatPropertyValuesHolder pvh = new FloatPropertyValuesHolder(propertyName, values);
        return pvh;
    }

    public static PropertyValuesHolder ofObject(String propertyName, TypeEvaluator evaluator, Object ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    public static PropertyValuesHolder ofKeyframe(String propertyName, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        if (keyframeSet instanceof IntKeyframeSet) {
            return new IntPropertyValuesHolder(propertyName, (IntKeyframeSet)keyframeSet);
        }
        if (keyframeSet instanceof FloatKeyframeSet) {
            return new FloatPropertyValuesHolder(propertyName, (FloatKeyframeSet)keyframeSet);
        }
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.mKeyframeSet = keyframeSet;
        pvh.mValueType = values[0].getType();
        return pvh;
    }

    public void setIntValues(int ... values) {
        this.mValueType = Integer.TYPE;
        this.mKeyframeSet = KeyframeSet.ofInt(values);
    }

    public void setFloatValues(float ... values) {
        this.mValueType = Float.TYPE;
        this.mKeyframeSet = KeyframeSet.ofFloat(values);
    }

    public void setKeyframes(Keyframe ... values) {
        int numKeyframes = values.length;
        Keyframe[] keyframes = new Keyframe[Math.max(numKeyframes, 2)];
        this.mValueType = values[0].getType();
        for (int i = 0; i < numKeyframes; ++i) {
            keyframes[i] = values[i];
        }
        this.mKeyframeSet = new KeyframeSet(keyframes);
    }

    public void setObjectValues(Object ... values) {
        this.mValueType = values[0].getClass();
        this.mKeyframeSet = KeyframeSet.ofObject(values);
    }

    public Method getPropertyFunction(Class targetClass, String prefix, Class valueType) {
        Method returnVal = null;
        String methodName = PropertyValuesHolder.getMethodName(prefix, this.mPropertyName);
        Class[] args = null;
        if (valueType == null) {
            try {
                returnVal = targetClass.getMethod(methodName, args);
            }
            catch (NoSuchMethodException e) {
                Log.e("PropertyValuesHolder", "Couldn't find no-arg method for property " + this.mPropertyName + ": " + e);
            }
        } else {
            args = new Class[1];
            Class[] typeVariants = this.mValueType.equals(Float.class) ? FLOAT_VARIANTS : (this.mValueType.equals(Integer.class) ? INTEGER_VARIANTS : (this.mValueType.equals(Double.class) ? DOUBLE_VARIANTS : new Class[]{this.mValueType}));
            Class[] arr$ = typeVariants;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Class typeVariant;
                args[0] = typeVariant = arr$[i$];
                try {
                    returnVal = targetClass.getMethod(methodName, args);
                    this.mValueType = typeVariant;
                    return returnVal;
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
            Log.e("PropertyValuesHolder", "Couldn't find setter/getter for property " + this.mPropertyName + " with value type " + this.mValueType);
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method setupSetterOrGetter(Class targetClass, HashMap<Class, HashMap<String, Method>> propertyMapMap, String prefix, Class valueType) {
        Method setterOrGetter = null;
        try {
            this.mPropertyMapLock.writeLock().lock();
            HashMap<String, Method> propertyMap = propertyMapMap.get(targetClass);
            if (propertyMap != null) {
                setterOrGetter = propertyMap.get(this.mPropertyName);
            }
            if (setterOrGetter == null) {
                setterOrGetter = this.getPropertyFunction(targetClass, prefix, valueType);
                if (propertyMap == null) {
                    propertyMap = new HashMap();
                    propertyMapMap.put(targetClass, propertyMap);
                }
                propertyMap.put(this.mPropertyName, setterOrGetter);
            }
        }
        finally {
            this.mPropertyMapLock.writeLock().unlock();
        }
        return setterOrGetter;
    }

    public void setupSetter(Class targetClass) {
        this.mSetter = this.setupSetterOrGetter(targetClass, sSetterPropertyMap, "set", this.mValueType);
    }

    public void setupGetter(Class targetClass) {
        this.mGetter = this.setupSetterOrGetter(targetClass, sGetterPropertyMap, "get", null);
    }

    public void setupSetterAndGetter(Object target) {
        Class<?> targetClass = target.getClass();
        if (this.mSetter == null) {
            this.setupSetter(targetClass);
        }
        for (Keyframe kf : this.mKeyframeSet.mKeyframes) {
            if (kf.hasValue()) continue;
            if (this.mGetter == null) {
                this.setupGetter(targetClass);
            }
            try {
                kf.setValue(this.mGetter.invoke(target, new Object[0]));
            }
            catch (InvocationTargetException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
            catch (IllegalAccessException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
        }
    }

    public void setupValue(Object target, Keyframe kf) {
        try {
            if (this.mGetter == null) {
                Class<?> targetClass = target.getClass();
                this.setupGetter(targetClass);
            }
            kf.setValue(this.mGetter.invoke(target, new Object[0]));
        }
        catch (InvocationTargetException e) {
            Log.e("PropertyValuesHolder", e.toString());
        }
        catch (IllegalAccessException e) {
            Log.e("PropertyValuesHolder", e.toString());
        }
    }

    public void setupStartValue(Object target) {
        this.setupValue(target, this.mKeyframeSet.mKeyframes.get(0));
    }

    public void setupEndValue(Object target) {
        this.setupValue(target, this.mKeyframeSet.mKeyframes.get(this.mKeyframeSet.mKeyframes.size() - 1));
    }

    public PropertyValuesHolder clone() {
        try {
            PropertyValuesHolder newPVH = (PropertyValuesHolder)super.clone();
            newPVH.mPropertyName = this.mPropertyName;
            newPVH.mKeyframeSet = this.mKeyframeSet.clone();
            newPVH.mEvaluator = this.mEvaluator;
            return newPVH;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setAnimatedValue(Object target) {
        if (this.mSetter != null) {
            try {
                this.mTmpValueArray[0] = this.getAnimatedValue();
                this.mSetter.invoke(target, this.mTmpValueArray);
            }
            catch (InvocationTargetException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
            catch (IllegalAccessException e) {
                Log.e("PropertyValuesHolder", e.toString());
            }
        }
    }

    public void init() {
        if (this.mEvaluator == null) {
            TypeEvaluator typeEvaluator = this.mValueType == Integer.class ? sIntEvaluator : (this.mEvaluator = this.mValueType == Float.class ? sFloatEvaluator : null);
        }
        if (this.mEvaluator != null) {
            this.mKeyframeSet.setEvaluator(this.mEvaluator);
        }
    }

    public void setEvaluator(TypeEvaluator evaluator) {
        this.mEvaluator = evaluator;
        this.mKeyframeSet.setEvaluator(evaluator);
    }

    public void calculateValue(float fraction2) {
        this.mAnimatedValue = this.mKeyframeSet.getValue(fraction2);
    }

    public void setPropertyName(String propertyName) {
        this.mPropertyName = propertyName;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    public Object getAnimatedValue() {
        return this.mAnimatedValue;
    }

    public String toString() {
        return this.mPropertyName + ": " + this.mKeyframeSet.toString();
    }

    public static String getMethodName(String prefix, String propertyName) {
        char firstLetter = propertyName.charAt(0);
        String theRest = propertyName.substring(1);
        firstLetter = Character.toUpperCase(firstLetter);
        return prefix + firstLetter + theRest;
    }

    @LayoutlibDelegate
    public static int nGetIntMethod(Class clazz, String string2) {
        return PropertyValuesHolder_Delegate.nGetIntMethod(clazz, string2);
    }

    @LayoutlibDelegate
    public static int nGetFloatMethod(Class clazz, String string2) {
        return PropertyValuesHolder_Delegate.nGetFloatMethod(clazz, string2);
    }

    @LayoutlibDelegate
    public static void nCallIntMethod(Object object, int n, int n2) {
        PropertyValuesHolder_Delegate.nCallIntMethod(object, n, n2);
    }

    @LayoutlibDelegate
    public static void nCallFloatMethod(Object object, int n, float f) {
        PropertyValuesHolder_Delegate.nCallFloatMethod(object, n, f);
    }

    public /* synthetic */ PropertyValuesHolder(String x0, 1 x1) {
        this(x0);
    }

    public static class 1 {
    }

    public static class FloatPropertyValuesHolder
    extends PropertyValuesHolder {
        public static final HashMap<Class, HashMap<String, Integer>> sJNISetterPropertyMap = new HashMap();
        public int mJniSetter;
        public FloatKeyframeSet mFloatKeyframeSet;
        public float mFloatAnimatedValue;

        public FloatPropertyValuesHolder(String propertyName, FloatKeyframeSet keyframeSet) {
            super(propertyName, null);
            this.mValueType = Float.TYPE;
            this.mKeyframeSet = keyframeSet;
            this.mFloatKeyframeSet = (FloatKeyframeSet)this.mKeyframeSet;
        }

        public FloatPropertyValuesHolder(String propertyName, float ... values) {
            super(propertyName, null);
            this.setFloatValues(values);
        }

        public void setFloatValues(float ... values) {
            super.setFloatValues(values);
            this.mFloatKeyframeSet = (FloatKeyframeSet)this.mKeyframeSet;
        }

        public void calculateValue(float fraction2) {
            this.mFloatAnimatedValue = this.mFloatKeyframeSet.getFloatValue(fraction2);
        }

        public Object getAnimatedValue() {
            return Float.valueOf(this.mFloatAnimatedValue);
        }

        public FloatPropertyValuesHolder clone() {
            FloatPropertyValuesHolder newPVH = (FloatPropertyValuesHolder)super.clone();
            newPVH.mFloatKeyframeSet = (FloatKeyframeSet)newPVH.mKeyframeSet;
            return newPVH;
        }

        public void setAnimatedValue(Object target) {
            if (this.mJniSetter != 0) {
                PropertyValuesHolder.nCallFloatMethod(target, this.mJniSetter, this.mFloatAnimatedValue);
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = Float.valueOf(this.mFloatAnimatedValue);
                    this.mSetter.invoke(target, this.mTmpValueArray);
                }
                catch (InvocationTargetException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupSetter(Class targetClass) {
            try {
                Integer mJniSetterInteger;
                this.mPropertyMapLock.writeLock().lock();
                HashMap<String, Integer> propertyMap = sJNISetterPropertyMap.get(targetClass);
                if (propertyMap != null && (mJniSetterInteger = propertyMap.get(this.mPropertyName)) != null) {
                    this.mJniSetter = mJniSetterInteger;
                }
                if (this.mJniSetter == 0) {
                    String methodName = FloatPropertyValuesHolder.getMethodName("set", this.mPropertyName);
                    this.mJniSetter = PropertyValuesHolder.nGetFloatMethod(targetClass, methodName);
                    if (this.mJniSetter != 0) {
                        if (propertyMap == null) {
                            propertyMap = new HashMap();
                            sJNISetterPropertyMap.put(targetClass, propertyMap);
                        }
                        propertyMap.put(this.mPropertyName, this.mJniSetter);
                    }
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            finally {
                this.mPropertyMapLock.writeLock().unlock();
            }
            if (this.mJniSetter == 0) {
                super.setupSetter(targetClass);
            }
        }
    }

    public static class IntPropertyValuesHolder
    extends PropertyValuesHolder {
        public static final HashMap<Class, HashMap<String, Integer>> sJNISetterPropertyMap = new HashMap();
        public int mJniSetter;
        public IntKeyframeSet mIntKeyframeSet;
        public int mIntAnimatedValue;

        public IntPropertyValuesHolder(String propertyName, IntKeyframeSet keyframeSet) {
            super(propertyName, null);
            this.mValueType = Integer.TYPE;
            this.mKeyframeSet = keyframeSet;
            this.mIntKeyframeSet = (IntKeyframeSet)this.mKeyframeSet;
        }

        public IntPropertyValuesHolder(String propertyName, int ... values) {
            super(propertyName, null);
            this.setIntValues(values);
        }

        public void setIntValues(int ... values) {
            super.setIntValues(values);
            this.mIntKeyframeSet = (IntKeyframeSet)this.mKeyframeSet;
        }

        public void calculateValue(float fraction2) {
            this.mIntAnimatedValue = this.mIntKeyframeSet.getIntValue(fraction2);
        }

        public Object getAnimatedValue() {
            return this.mIntAnimatedValue;
        }

        public IntPropertyValuesHolder clone() {
            IntPropertyValuesHolder newPVH = (IntPropertyValuesHolder)super.clone();
            newPVH.mIntKeyframeSet = (IntKeyframeSet)newPVH.mKeyframeSet;
            return newPVH;
        }

        public void setAnimatedValue(Object target) {
            if (this.mJniSetter != 0) {
                PropertyValuesHolder.nCallIntMethod(target, this.mJniSetter, this.mIntAnimatedValue);
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = this.mIntAnimatedValue;
                    this.mSetter.invoke(target, this.mTmpValueArray);
                }
                catch (InvocationTargetException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e("PropertyValuesHolder", e.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupSetter(Class targetClass) {
            try {
                Integer mJniSetterInteger;
                this.mPropertyMapLock.writeLock().lock();
                HashMap<String, Integer> propertyMap = sJNISetterPropertyMap.get(targetClass);
                if (propertyMap != null && (mJniSetterInteger = propertyMap.get(this.mPropertyName)) != null) {
                    this.mJniSetter = mJniSetterInteger;
                }
                if (this.mJniSetter == 0) {
                    String methodName = IntPropertyValuesHolder.getMethodName("set", this.mPropertyName);
                    this.mJniSetter = PropertyValuesHolder.nGetIntMethod(targetClass, methodName);
                    if (this.mJniSetter != 0) {
                        if (propertyMap == null) {
                            propertyMap = new HashMap();
                            sJNISetterPropertyMap.put(targetClass, propertyMap);
                        }
                        propertyMap.put(this.mPropertyName, this.mJniSetter);
                    }
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            finally {
                this.mPropertyMapLock.writeLock().unlock();
            }
            if (this.mJniSetter == 0) {
                super.setupSetter(targetClass);
            }
        }
    }
}

