/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.FloatEvaluator;
import android.animation.IntEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AndroidRuntimeException;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;
import java.util.HashMap;

public class ValueAnimator
extends Animator {
    public static final long DEFAULT_FRAME_DELAY = 10L;
    public static final int ANIMATION_START = 0;
    public static final int ANIMATION_FRAME = 1;
    public static final int STOPPED = 0;
    public static final int RUNNING = 1;
    public static final int SEEKED = 2;
    public long mStartTime;
    public long mSeekTime = -1L;
    public static ThreadLocal<AnimationHandler> sAnimationHandler = new ThreadLocal();
    public static final ThreadLocal<ArrayList<ValueAnimator>> sAnimations = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        public ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    public static final ThreadLocal<ArrayList<ValueAnimator>> sPendingAnimations = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        public ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    public static final ThreadLocal<ArrayList<ValueAnimator>> sDelayedAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        public ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    public static final ThreadLocal<ArrayList<ValueAnimator>> sEndingAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        public ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    public static final ThreadLocal<ArrayList<ValueAnimator>> sReadyAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        public ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    public static final TimeInterpolator sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    public static final TypeEvaluator sIntEvaluator = new IntEvaluator();
    public static final TypeEvaluator sFloatEvaluator = new FloatEvaluator();
    public boolean mPlayingBackwards = false;
    public int mCurrentIteration = 0;
    public float mCurrentFraction = 0.0f;
    public boolean mStartedDelay = false;
    public long mDelayStartTime;
    public int mPlayingState = 0;
    public boolean mInitialized = false;
    public long mDuration = 300L;
    public long mStartDelay = 0L;
    public static long sFrameDelay = 10L;
    public int mRepeatCount = 0;
    public int mRepeatMode = 1;
    public TimeInterpolator mInterpolator = sDefaultInterpolator;
    public ArrayList<AnimatorUpdateListener> mUpdateListeners = null;
    public PropertyValuesHolder[] mValues;
    public HashMap<String, PropertyValuesHolder> mValuesMap;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    public static ValueAnimator ofInt(int ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setIntValues(values);
        return anim2;
    }

    public static ValueAnimator ofFloat(float ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setFloatValues(values);
        return anim2;
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setValues(values);
        return anim2;
    }

    public static ValueAnimator ofObject(TypeEvaluator evaluator, Object ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    public void setIntValues(int ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofInt("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setIntValues(values);
        }
        this.mInitialized = false;
    }

    public void setFloatValues(float ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofFloat("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setFloatValues(values);
        }
        this.mInitialized = false;
    }

    public void setObjectValues(Object ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofObject("", null, values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setObjectValues(values);
        }
        this.mInitialized = false;
    }

    public void setValues(PropertyValuesHolder ... values) {
        int numValues = values.length;
        this.mValues = values;
        this.mValuesMap = new HashMap(numValues);
        for (int i = 0; i < numValues; ++i) {
            PropertyValuesHolder valuesHolder = values[i];
            this.mValuesMap.put(valuesHolder.getPropertyName(), valuesHolder);
        }
        this.mInitialized = false;
    }

    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    public void initAnimation() {
        if (!this.mInitialized) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].init();
            }
            this.mInitialized = true;
        }
    }

    public ValueAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mDuration = duration;
        return this;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setCurrentPlayTime(long playTime) {
        this.initAnimation();
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        if (this.mPlayingState != 1) {
            this.mSeekTime = playTime;
            this.mPlayingState = 2;
        }
        this.mStartTime = currentTime - playTime;
        this.animationFrame(currentTime);
    }

    public long getCurrentPlayTime() {
        if (!this.mInitialized || this.mPlayingState == 0) {
            return 0L;
        }
        return AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
    }

    public long getStartDelay() {
        return this.mStartDelay;
    }

    public void setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
    }

    public static long getFrameDelay() {
        return sFrameDelay;
    }

    public static void setFrameDelay(long frameDelay) {
        sFrameDelay = frameDelay;
    }

    public Object getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    public Object getAnimatedValue(String propertyName) {
        PropertyValuesHolder valuesHolder = this.mValuesMap.get(propertyName);
        if (valuesHolder != null) {
            return valuesHolder.getAnimatedValue();
        }
        return null;
    }

    public void setRepeatCount(int value) {
        this.mRepeatCount = value;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatMode(int value) {
        this.mRepeatMode = value;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public void addUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(listener);
    }

    public void removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    public void removeUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(listener);
        if (this.mUpdateListeners.size() == 0) {
            this.mUpdateListeners = null;
        }
    }

    public void setInterpolator(TimeInterpolator value) {
        this.mInterpolator = value != null ? value : new LinearInterpolator();
    }

    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setEvaluator(TypeEvaluator value) {
        if (value != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(value);
        }
    }

    public void start(boolean playBackwards) {
        AnimationHandler animationHandler;
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mPlayingBackwards = playBackwards;
        this.mCurrentIteration = 0;
        this.mPlayingState = 0;
        this.mStartedDelay = false;
        sPendingAnimations.get().add(this);
        if (this.mStartDelay == 0L) {
            this.setCurrentPlayTime(this.getCurrentPlayTime());
            this.mPlayingState = 0;
            if (this.mListeners != null) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this);
                }
            }
        }
        if ((animationHandler = sAnimationHandler.get()) == null) {
            animationHandler = new AnimationHandler(null);
            sAnimationHandler.set(animationHandler);
        }
        animationHandler.sendEmptyMessage(0);
    }

    public void start() {
        this.start(false);
    }

    public void cancel() {
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            for (Animator.AnimatorListener listener : tmpListeners) {
                listener.onAnimationCancel(this);
            }
        }
        if (this.mPlayingState != 0 || sPendingAnimations.get().contains(this) || sDelayedAnims.get().contains(this)) {
            this.endAnimation();
        }
    }

    public void end() {
        if (!sAnimations.get().contains(this) && !sPendingAnimations.get().contains(this)) {
            this.mStartedDelay = false;
            this.startAnimation();
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        if (this.mRepeatCount > 0 && (this.mRepeatCount & 1) == 1) {
            this.animateValue(0.0f);
        } else {
            this.animateValue(1.0f);
        }
        this.endAnimation();
    }

    public boolean isRunning() {
        return this.mPlayingState == 1;
    }

    public void reverse() {
        boolean bl = this.mPlayingBackwards = !this.mPlayingBackwards;
        if (this.mPlayingState == 1) {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            long currentPlayTime = currentTime - this.mStartTime;
            long timeLeft = this.mDuration - currentPlayTime;
            this.mStartTime = currentTime - timeLeft;
        } else {
            this.start(true);
        }
    }

    public void endAnimation() {
        sAnimations.get().remove(this);
        sPendingAnimations.get().remove(this);
        sDelayedAnims.get().remove(this);
        this.mPlayingState = 0;
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
            }
        }
    }

    public void startAnimation() {
        this.initAnimation();
        sAnimations.get().add(this);
        if (this.mStartDelay > 0L && this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this);
            }
        }
    }

    public boolean delayedAnimationFrame(long currentTime) {
        if (!this.mStartedDelay) {
            this.mStartedDelay = true;
            this.mDelayStartTime = currentTime;
        } else {
            long deltaTime = currentTime - this.mDelayStartTime;
            if (deltaTime > this.mStartDelay) {
                this.mStartTime = currentTime - (deltaTime - this.mStartDelay);
                this.mPlayingState = 1;
                return true;
            }
        }
        return false;
    }

    public boolean animationFrame(long currentTime) {
        boolean done = false;
        if (this.mPlayingState == 0) {
            this.mPlayingState = 1;
            if (this.mSeekTime < 0L) {
                this.mStartTime = currentTime;
            } else {
                this.mStartTime = currentTime - this.mSeekTime;
                this.mSeekTime = -1L;
            }
        }
        switch (this.mPlayingState) {
            case 1: 
            case 2: {
                float fraction2;
                float f = fraction2 = this.mDuration > 0L ? (float)(currentTime - this.mStartTime) / (float)this.mDuration : 1.0f;
                if (fraction2 >= 1.0f) {
                    if (this.mCurrentIteration < this.mRepeatCount || this.mRepeatCount == -1) {
                        if (this.mListeners != null) {
                            int numListeners = this.mListeners.size();
                            for (int i = 0; i < numListeners; ++i) {
                                ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                            }
                        }
                        if (this.mRepeatMode == 2) {
                            this.mPlayingBackwards = !this.mPlayingBackwards;
                        }
                        this.mCurrentIteration += (int)fraction2;
                        fraction2 %= 1.0f;
                        this.mStartTime += this.mDuration;
                    } else {
                        done = true;
                        fraction2 = Math.min(fraction2, 1.0f);
                    }
                }
                if (this.mPlayingBackwards) {
                    fraction2 = 1.0f - fraction2;
                }
                this.animateValue(fraction2);
            }
        }
        return done;
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    public void animateValue(float fraction2) {
        this.mCurrentFraction = fraction2 = this.mInterpolator.getInterpolation(fraction2);
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].calculateValue(fraction2);
        }
        if (this.mUpdateListeners != null) {
            int numListeners = this.mUpdateListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                this.mUpdateListeners.get(i).onAnimationUpdate(this);
            }
        }
    }

    public ValueAnimator clone() {
        int i;
        ValueAnimator anim2 = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            ArrayList<AnimatorUpdateListener> oldListeners = this.mUpdateListeners;
            anim2.mUpdateListeners = new ArrayList();
            int numListeners = oldListeners.size();
            for (i = 0; i < numListeners; ++i) {
                anim2.mUpdateListeners.add(oldListeners.get(i));
            }
        }
        anim2.mSeekTime = -1L;
        anim2.mPlayingBackwards = false;
        anim2.mCurrentIteration = 0;
        anim2.mInitialized = false;
        anim2.mPlayingState = 0;
        anim2.mStartedDelay = false;
        PropertyValuesHolder[] oldValues = this.mValues;
        if (oldValues != null) {
            int numValues = oldValues.length;
            anim2.mValues = new PropertyValuesHolder[numValues];
            for (i = 0; i < numValues; ++i) {
                anim2.mValues[i] = oldValues[i].clone();
            }
            anim2.mValuesMap = new HashMap(numValues);
            for (i = 0; i < numValues; ++i) {
                PropertyValuesHolder valuesHolder = this.mValues[i];
                anim2.mValuesMap.put(valuesHolder.getPropertyName(), valuesHolder);
            }
        }
        return anim2;
    }

    public static int getCurrentAnimationsCount() {
        return sAnimations.get().size();
    }

    public static void clearAllAnimations() {
        sAnimations.get().clear();
        sPendingAnimations.get().clear();
        sDelayedAnims.get().clear();
    }

    public String toString() {
        String returnVal = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                returnVal = returnVal + "\n    " + this.mValues[i].toString();
            }
        }
        return returnVal;
    }

    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(ValueAnimator var1);
    }

    public static class AnimationHandler
    extends Handler {
        public AnimationHandler() {
        }

        public void handleMessage(Message msg) {
            boolean callAgain = true;
            ArrayList animations = (ArrayList)sAnimations.get();
            ArrayList delayedAnims = (ArrayList)sDelayedAnims.get();
            switch (msg.what) {
                case 0: {
                    ArrayList pendingAnimations = (ArrayList)sPendingAnimations.get();
                    if (animations.size() > 0 || delayedAnims.size() > 0) {
                        callAgain = false;
                    }
                    while (pendingAnimations.size() > 0) {
                        ArrayList pendingCopy = (ArrayList)pendingAnimations.clone();
                        pendingAnimations.clear();
                        int count = pendingCopy.size();
                        for (int i = 0; i < count; ++i) {
                            ValueAnimator anim2 = (ValueAnimator)pendingCopy.get(i);
                            if (anim2.mStartDelay == 0L) {
                                anim2.startAnimation();
                                continue;
                            }
                            delayedAnims.add(anim2);
                        }
                    }
                }
                case 1: {
                    long currentTime = AnimationUtils.currentAnimationTimeMillis();
                    ArrayList readyAnims = (ArrayList)sReadyAnims.get();
                    ArrayList endingAnims = (ArrayList)sEndingAnims.get();
                    int numDelayedAnims = delayedAnims.size();
                    for (int i = 0; i < numDelayedAnims; ++i) {
                        ValueAnimator anim3 = (ValueAnimator)delayedAnims.get(i);
                        if (!anim3.delayedAnimationFrame(currentTime)) continue;
                        readyAnims.add(anim3);
                    }
                    int numReadyAnims = readyAnims.size();
                    if (numReadyAnims > 0) {
                        for (int i = 0; i < numReadyAnims; ++i) {
                            ValueAnimator anim4 = (ValueAnimator)readyAnims.get(i);
                            anim4.startAnimation();
                            delayedAnims.remove(anim4);
                        }
                        readyAnims.clear();
                    }
                    int numAnims = animations.size();
                    int i = 0;
                    while (i < numAnims) {
                        ValueAnimator anim5 = (ValueAnimator)animations.get(i);
                        if (anim5.animationFrame(currentTime)) {
                            endingAnims.add(anim5);
                        }
                        if (animations.size() == numAnims) {
                            ++i;
                            continue;
                        }
                        --numAnims;
                        endingAnims.remove(anim5);
                    }
                    if (endingAnims.size() > 0) {
                        for (i = 0; i < endingAnims.size(); ++i) {
                            ((ValueAnimator)endingAnims.get(i)).endAnimation();
                        }
                        endingAnims.clear();
                    }
                    if (!callAgain || animations.isEmpty() && delayedAnims.isEmpty()) break;
                    this.sendEmptyMessageDelayed(1, Math.max(0L, sFrameDelay - (AnimationUtils.currentAnimationTimeMillis() - currentTime)));
                }
            }
        }

        public /* synthetic */ AnimationHandler(1 x0) {
            this();
        }
    }
}

