/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Application;
import android.app.Fragment;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Debug;
import android.os.IBinder;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.PerformanceCollector;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.IWindowManager;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instrumentation {
    public static final String REPORT_KEY_IDENTIFIER = "id";
    public static final String REPORT_KEY_STREAMRESULT = "stream";
    public static final String TAG = "Instrumentation";
    public final Object mSync = new Object();
    public ActivityThread mThread = null;
    public MessageQueue mMessageQueue = null;
    public Context mInstrContext;
    public Context mAppContext;
    public ComponentName mComponent;
    public Thread mRunner;
    public List<ActivityWaiter> mWaitingActivities;
    public List<ActivityMonitor> mActivityMonitors;
    public IInstrumentationWatcher mWatcher;
    public boolean mAutomaticPerformanceSnapshots = false;
    public PerformanceCollector mPerformanceCollector;
    public Bundle mPerfMetrics = new Bundle();

    public void onCreate(Bundle arguments) {
    }

    public void start() {
        if (this.mRunner != null) {
            throw new RuntimeException("Instrumentation already started");
        }
        this.mRunner = new InstrumentationThread("Instr: " + this.getClass().getName());
        this.mRunner.start();
    }

    public void onStart() {
    }

    public boolean onException(Object obj, Throwable e) {
        return false;
    }

    public void sendStatus(int resultCode, Bundle results) {
        if (this.mWatcher != null) {
            try {
                this.mWatcher.instrumentationStatus(this.mComponent, resultCode, results);
            }
            catch (RemoteException e) {
                this.mWatcher = null;
            }
        }
    }

    public void finish(int resultCode, Bundle results) {
        if (this.mAutomaticPerformanceSnapshots) {
            this.endPerformanceSnapshot();
        }
        if (this.mPerfMetrics != null) {
            results.putAll(this.mPerfMetrics);
        }
        this.mThread.finishInstrumentation(resultCode, results);
    }

    public void setAutomaticPerformanceSnapshots() {
        this.mAutomaticPerformanceSnapshots = true;
        this.mPerformanceCollector = new PerformanceCollector();
    }

    public void startPerformanceSnapshot() {
        if (!this.isProfiling()) {
            this.mPerformanceCollector.beginSnapshot(null);
        }
    }

    public void endPerformanceSnapshot() {
        if (!this.isProfiling()) {
            this.mPerfMetrics = this.mPerformanceCollector.endSnapshot();
        }
    }

    public void onDestroy() {
    }

    public Context getContext() {
        return this.mInstrContext;
    }

    public ComponentName getComponentName() {
        return this.mComponent;
    }

    public Context getTargetContext() {
        return this.mAppContext;
    }

    public boolean isProfiling() {
        return this.mThread.isProfiling();
    }

    public void startProfiling() {
        if (this.mThread.isProfiling()) {
            File file = new File(this.mThread.getProfileFilePath());
            file.getParentFile().mkdirs();
            Debug.startMethodTracing(file.toString(), 0x800000);
        }
    }

    public void stopProfiling() {
        if (this.mThread.isProfiling()) {
            Debug.stopMethodTracing();
        }
    }

    public void setInTouchMode(boolean inTouch) {
        try {
            IWindowManager.Stub.asInterface(ServiceManager.getService("window")).setInTouchMode(inTouch);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void waitForIdle(Runnable recipient) {
        this.mMessageQueue.addIdleHandler(new Idler(recipient));
        this.mThread.getHandler().post(new EmptyRunnable(null));
    }

    public void waitForIdleSync() {
        this.validateNotAppThread();
        Idler idler = new Idler(null);
        this.mMessageQueue.addIdleHandler(idler);
        this.mThread.getHandler().post(new EmptyRunnable(null));
        idler.waitForIdle();
    }

    public void runOnMainSync(Runnable runner) {
        this.validateNotAppThread();
        SyncRunnable sr = new SyncRunnable(runner);
        this.mThread.getHandler().post(sr);
        sr.waitForComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity startActivitySync(Intent intent) {
        this.validateNotAppThread();
        Object object = this.mSync;
        synchronized (object) {
            intent = new Intent(intent);
            ActivityInfo ai = intent.resolveActivityInfo(this.getTargetContext().getPackageManager(), 0);
            if (ai == null) {
                throw new RuntimeException("Unable to resolve activity for: " + intent);
            }
            String myProc = this.mThread.getProcessName();
            if (!ai.processName.equals(myProc)) {
                throw new RuntimeException("Intent in process " + myProc + " resolved to different process " + ai.processName + ": " + intent);
            }
            intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
            ActivityWaiter aw = new ActivityWaiter(intent);
            if (this.mWaitingActivities == null) {
                this.mWaitingActivities = new ArrayList<ActivityWaiter>();
            }
            this.mWaitingActivities.add(aw);
            this.getTargetContext().startActivity(intent);
            do {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (this.mWaitingActivities.contains(aw));
            return aw.activity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(ActivityMonitor monitor) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mActivityMonitors == null) {
                this.mActivityMonitors = new ArrayList<ActivityMonitor>();
            }
            this.mActivityMonitors.add(monitor);
        }
    }

    public ActivityMonitor addMonitor(IntentFilter filter, ActivityResult result, boolean block) {
        ActivityMonitor am = new ActivityMonitor(filter, result, block);
        this.addMonitor(am);
        return am;
    }

    public ActivityMonitor addMonitor(String cls, ActivityResult result, boolean block) {
        ActivityMonitor am = new ActivityMonitor(cls, result, block);
        this.addMonitor(am);
        return am;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkMonitorHit(ActivityMonitor monitor, int minHits) {
        this.waitForIdleSync();
        Object object = this.mSync;
        synchronized (object) {
            if (monitor.getHits() < minHits) {
                return false;
            }
            this.mActivityMonitors.remove(monitor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity waitForMonitor(ActivityMonitor monitor) {
        Activity activity = monitor.waitForActivity();
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(monitor);
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity waitForMonitorWithTimeout(ActivityMonitor monitor, long timeOut) {
        Activity activity = monitor.waitForActivityWithTimeout(timeOut);
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(monitor);
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitor(ActivityMonitor monitor) {
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(monitor);
        }
    }

    public boolean invokeMenuActionSync(Activity targetActivity, int id2, int flag) {
        public class MenuRunnable
        implements Runnable {
            public final Activity activity;
            public final int identifier;
            public final int flags;
            public boolean returnValue;

            public MenuRunnable(Activity _activity, int _identifier, int _flags) {
                this.activity = _activity;
                this.identifier = _identifier;
                this.flags = _flags;
            }

            public void run() {
                Window win = this.activity.getWindow();
                this.returnValue = win.performPanelIdentifierAction(0, this.identifier, this.flags);
            }
        }
        MenuRunnable mr = new MenuRunnable(targetActivity, id2, flag);
        this.runOnMainSync(mr);
        return mr.returnValue;
    }

    public boolean invokeContextMenuAction(Activity targetActivity, int id2, int flag) {
        this.validateNotAppThread();
        KeyEvent downEvent = new KeyEvent(0, 23);
        this.sendKeySync(downEvent);
        this.waitForIdleSync();
        try {
            Thread.sleep(ViewConfiguration.getLongPressTimeout());
        }
        catch (InterruptedException e) {
            Log.e(TAG, "Could not sleep for long press timeout", e);
            return false;
        }
        KeyEvent upEvent = new KeyEvent(1, 23);
        this.sendKeySync(upEvent);
        this.waitForIdleSync();
        public class ContextMenuRunnable
        implements Runnable {
            public final Activity activity;
            public final int identifier;
            public final int flags;
            public boolean returnValue;

            public ContextMenuRunnable(Activity _activity, int _identifier, int _flags) {
                this.activity = _activity;
                this.identifier = _identifier;
                this.flags = _flags;
            }

            public void run() {
                Window win = this.activity.getWindow();
                this.returnValue = win.performContextMenuIdentifierAction(this.identifier, this.flags);
            }
        }
        ContextMenuRunnable cmr = new ContextMenuRunnable(targetActivity, id2, flag);
        this.runOnMainSync(cmr);
        return cmr.returnValue;
    }

    public void sendStringSync(String text) {
        if (text == null) {
            return;
        }
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(-1);
        KeyEvent[] events = keyCharacterMap.getEvents(text.toCharArray());
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                this.sendKeySync(events[i]);
            }
        }
    }

    public void sendKeySync(KeyEvent event) {
        this.validateNotAppThread();
        try {
            IWindowManager.Stub.asInterface(ServiceManager.getService("window")).injectKeyEvent(event, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendKeyDownUpSync(int key) {
        this.sendKeySync(new KeyEvent(0, key));
        this.sendKeySync(new KeyEvent(1, key));
    }

    public void sendCharacterSync(int keyCode) {
        this.sendKeySync(new KeyEvent(0, keyCode));
        this.sendKeySync(new KeyEvent(1, keyCode));
    }

    public void sendPointerSync(MotionEvent event) {
        this.validateNotAppThread();
        try {
            IWindowManager.Stub.asInterface(ServiceManager.getService("window")).injectPointerEvent(event, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendTrackballEventSync(MotionEvent event) {
        this.validateNotAppThread();
        try {
            IWindowManager.Stub.asInterface(ServiceManager.getService("window")).injectTrackballEvent(event, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Application newApplication(ClassLoader cl, String className, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Instrumentation.newApplication(cl.loadClass(className), context);
    }

    public static Application newApplication(Class<?> clazz, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Application app = (Application)clazz.newInstance();
        app.attach(context);
        return app;
    }

    public void callApplicationOnCreate(Application app) {
        app.onCreate();
    }

    public Activity newActivity(Class<?> clazz, Context context, IBinder token, Application application, Intent intent, ActivityInfo info, CharSequence title, Activity parent, String id2, Object lastNonConfigurationInstance) throws InstantiationException, IllegalAccessException {
        Activity activity = (Activity)clazz.newInstance();
        ActivityThread aThread = null;
        activity.attach(context, aThread, this, token, application, intent, info, title, parent, id2, (Activity.NonConfigurationInstances)lastNonConfigurationInstance, new Configuration());
        return activity;
    }

    public Activity newActivity(ClassLoader cl, String className, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (Activity)cl.loadClass(className).newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callActivityOnCreate(Activity activity, Bundle icicle) {
        int i;
        int N;
        Object object;
        if (this.mWaitingActivities != null) {
            object = this.mSync;
            synchronized (object) {
                N = this.mWaitingActivities.size();
                for (i = 0; i < N; ++i) {
                    ActivityWaiter aw = this.mWaitingActivities.get(i);
                    Intent intent = aw.intent;
                    if (!intent.filterEquals(activity.getIntent())) continue;
                    aw.activity = activity;
                    this.mMessageQueue.addIdleHandler(new ActivityGoing(aw));
                }
            }
        }
        activity.performCreate(icicle);
        if (this.mActivityMonitors != null) {
            object = this.mSync;
            synchronized (object) {
                N = this.mActivityMonitors.size();
                for (i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    am.match(activity, activity, activity.getIntent());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callActivityOnDestroy(Activity activity) {
        activity.performDestroy();
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    am.match(activity, activity, activity.getIntent());
                }
            }
        }
    }

    public void callActivityOnRestoreInstanceState(Activity activity, Bundle savedInstanceState) {
        activity.performRestoreInstanceState(savedInstanceState);
    }

    public void callActivityOnPostCreate(Activity activity, Bundle icicle) {
        activity.onPostCreate(icicle);
    }

    public void callActivityOnNewIntent(Activity activity, Intent intent) {
        activity.onNewIntent(intent);
    }

    public void callActivityOnStart(Activity activity) {
        activity.onStart();
    }

    public void callActivityOnRestart(Activity activity) {
        activity.onRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callActivityOnResume(Activity activity) {
        activity.mResumed = true;
        activity.onResume();
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    am.match(activity, activity, activity.getIntent());
                }
            }
        }
    }

    public void callActivityOnStop(Activity activity) {
        activity.onStop();
    }

    public void callActivityOnSaveInstanceState(Activity activity, Bundle outState) {
        activity.performSaveInstanceState(outState);
    }

    public void callActivityOnPause(Activity activity) {
        activity.performPause();
    }

    public void callActivityOnUserLeaving(Activity activity) {
        activity.performUserLeaving();
    }

    public void startAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.resetAllCounts();
        Debug.startAllocCounting();
    }

    public void stopAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.stopAllocCounting();
    }

    public void addValue(String key, int value, Bundle results) {
        if (results.containsKey(key)) {
            ArrayList<Integer> list = results.getIntegerArrayList(key);
            if (list != null) {
                list.add(value);
            }
        } else {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(value);
            results.putIntegerArrayList(key, list);
        }
    }

    public Bundle getAllocCounts() {
        Bundle results = new Bundle();
        results.putLong("global_alloc_count", Debug.getGlobalAllocCount());
        results.putLong("global_alloc_size", Debug.getGlobalAllocSize());
        results.putLong("global_freed_count", Debug.getGlobalFreedCount());
        results.putLong("global_freed_size", Debug.getGlobalFreedSize());
        results.putLong("gc_invocation_count", Debug.getGlobalGcInvocationCount());
        return results;
    }

    public Bundle getBinderCounts() {
        Bundle results = new Bundle();
        results.putLong("sent_transactions", Debug.getBinderSentTransactions());
        results.putLong("received_transactions", Debug.getBinderReceivedTransactions());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode) {
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return requestCode >= 0 ? am.getResult() : null;
                }
            }
        }
        try {
            int result = ActivityManagerNative.getDefault().startActivity(whoThread, intent, intent.resolveTypeIfNeeded(who.getContentResolver()), null, 0, token, target != null ? target.mEmbeddedID : null, requestCode, false, false);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execStartActivities(Context who, IBinder contextThread, IBinder token, Activity target, Intent[] intents) {
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    if (!am.match(who, null, intents[0])) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return;
                }
            }
        }
        try {
            String[] resolvedTypes = new String[intents.length];
            for (int i = 0; i < intents.length; ++i) {
                resolvedTypes[i] = intents[i].resolveTypeIfNeeded(who.getContentResolver());
            }
            int result = ActivityManagerNative.getDefault().startActivities(whoThread, intents, resolvedTypes, token);
            Instrumentation.checkStartActivityResult(result, intents[0]);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Fragment target, Intent intent, int requestCode) {
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return requestCode >= 0 ? am.getResult() : null;
                }
            }
        }
        try {
            int result = ActivityManagerNative.getDefault().startActivity(whoThread, intent, intent.resolveTypeIfNeeded(who.getContentResolver()), null, 0, token, target != null ? target.mWho : null, requestCode, false, false);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return null;
    }

    public void init(ActivityThread thread, Context instrContext, Context appContext, ComponentName component, IInstrumentationWatcher watcher) {
        this.mThread = thread;
        this.mThread.getLooper();
        this.mMessageQueue = Looper.myQueue();
        this.mInstrContext = instrContext;
        this.mAppContext = appContext;
        this.mComponent = component;
        this.mWatcher = watcher;
    }

    public static void checkStartActivityResult(int res, Object intent) {
        if (res >= 0) {
            return;
        }
        switch (res) {
            case -2: 
            case -1: {
                if (intent instanceof Intent && ((Intent)intent).getComponent() != null) {
                    throw new ActivityNotFoundException("Unable to find explicit activity class " + ((Intent)intent).getComponent().toShortString() + "; have you declared this activity in your AndroidManifest.xml?");
                }
                throw new ActivityNotFoundException("No Activity found to handle " + intent);
            }
            case -4: {
                throw new SecurityException("Not allowed to start activity " + intent);
            }
            case -3: {
                throw new AndroidRuntimeException("FORWARD_RESULT_FLAG used while also requesting a result");
            }
            case -5: {
                throw new IllegalArgumentException("PendingIntent is not an activity");
            }
        }
        throw new AndroidRuntimeException("Unknown error code " + res + " when starting " + intent);
    }

    public void validateNotAppThread() {
        if (ActivityThread.currentActivityThread() != null) {
            throw new RuntimeException("This method can not be called from the main application thread");
        }
    }

    public static class 1 {
    }

    public static class Idler
    implements MessageQueue.IdleHandler {
        public final Runnable mCallback;
        public boolean mIdle;

        public Idler(Runnable callback) {
            this.mCallback = callback;
            this.mIdle = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queueIdle() {
            if (this.mCallback != null) {
                this.mCallback.run();
            }
            Idler idler = this;
            synchronized (idler) {
                this.mIdle = true;
                this.notifyAll();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForIdle() {
            Idler idler = this;
            synchronized (idler) {
                while (!this.mIdle) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public class ActivityGoing
    implements MessageQueue.IdleHandler {
        public final ActivityWaiter mWaiter;

        public ActivityGoing(ActivityWaiter waiter) {
            this.mWaiter = waiter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queueIdle() {
            Object object = Instrumentation.this.mSync;
            synchronized (object) {
                Instrumentation.this.mWaitingActivities.remove(this.mWaiter);
                Instrumentation.this.mSync.notifyAll();
            }
            return false;
        }
    }

    public static class ActivityWaiter {
        public final Intent intent;
        public Activity activity;

        public ActivityWaiter(Intent _intent) {
            this.intent = _intent;
        }
    }

    public static class SyncRunnable
    implements Runnable {
        public final Runnable mTarget;
        public boolean mComplete;

        public SyncRunnable(Runnable target) {
            this.mTarget = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.mTarget.run();
            SyncRunnable syncRunnable = this;
            synchronized (syncRunnable) {
                this.mComplete = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForComplete() {
            SyncRunnable syncRunnable = this;
            synchronized (syncRunnable) {
                while (!this.mComplete) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public static class EmptyRunnable
    implements Runnable {
        public EmptyRunnable() {
        }

        public void run() {
        }

        public /* synthetic */ EmptyRunnable(1 x0) {
            this();
        }
    }

    public class InstrumentationThread
    extends Thread {
        public InstrumentationThread(String name) {
            super(name);
        }

        public void run() {
            IActivityManager am = ActivityManagerNative.getDefault();
            try {
                Process.setThreadPriority(-8);
            }
            catch (RuntimeException e) {
                Log.w(Instrumentation.TAG, "Exception setting priority of instrumentation thread " + Process.myTid(), e);
            }
            if (Instrumentation.this.mAutomaticPerformanceSnapshots) {
                Instrumentation.this.startPerformanceSnapshot();
            }
            Instrumentation.this.onStart();
        }
    }

    public static class ActivityResult {
        public final int mResultCode;
        public final Intent mResultData;

        public ActivityResult(int resultCode, Intent resultData) {
            this.mResultCode = resultCode;
            this.mResultData = resultData;
        }

        public int getResultCode() {
            return this.mResultCode;
        }

        public Intent getResultData() {
            return this.mResultData;
        }
    }

    public static class ActivityMonitor {
        public final IntentFilter mWhich;
        public final String mClass;
        public final ActivityResult mResult;
        public final boolean mBlock;
        public int mHits = 0;
        public Activity mLastActivity = null;

        public ActivityMonitor(IntentFilter which, ActivityResult result, boolean block) {
            this.mWhich = which;
            this.mClass = null;
            this.mResult = result;
            this.mBlock = block;
        }

        public ActivityMonitor(String cls, ActivityResult result, boolean block) {
            this.mWhich = null;
            this.mClass = cls;
            this.mResult = result;
            this.mBlock = block;
        }

        public IntentFilter getFilter() {
            return this.mWhich;
        }

        public ActivityResult getResult() {
            return this.mResult;
        }

        public boolean isBlocking() {
            return this.mBlock;
        }

        public int getHits() {
            return this.mHits;
        }

        public Activity getLastActivity() {
            return this.mLastActivity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Activity waitForActivity() {
            ActivityMonitor activityMonitor = this;
            synchronized (activityMonitor) {
                while (this.mLastActivity == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                Activity res = this.mLastActivity;
                this.mLastActivity = null;
                return res;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Activity waitForActivityWithTimeout(long timeOut) {
            ActivityMonitor activityMonitor = this;
            synchronized (activityMonitor) {
                try {
                    this.wait(timeOut);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.mLastActivity == null) {
                    return null;
                }
                Activity res = this.mLastActivity;
                this.mLastActivity = null;
                return res;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean match(Context who, Activity activity, Intent intent) {
            ActivityMonitor activityMonitor = this;
            synchronized (activityMonitor) {
                if (this.mWhich != null && this.mWhich.match(who.getContentResolver(), intent, true, Instrumentation.TAG) < 0) {
                    return false;
                }
                if (this.mClass != null) {
                    String cls = null;
                    if (activity != null) {
                        cls = activity.getClass().getName();
                    } else if (intent.getComponent() != null) {
                        cls = intent.getComponent().getClassName();
                    }
                    if (cls == null || !this.mClass.equals(cls)) {
                        return false;
                    }
                }
                if (activity != null) {
                    this.mLastActivity = activity;
                    this.notifyAll();
                }
                return true;
            }
        }
    }
}

