/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Application;
import android.app.ApplicationLoaders;
import android.app.ContextImpl;
import android.app.IActivityManager;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.IntentReceiverLeaked;
import android.app.ServiceConnectionLeaked;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Slog;
import android.view.CompatibilityInfoHolder;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;

public class LoadedApk {
    public final ActivityThread mActivityThread;
    public final ApplicationInfo mApplicationInfo;
    public final String mPackageName;
    public final String mAppDir;
    public final String mResDir;
    public final String[] mSharedLibraries;
    public final String mDataDir;
    public final String mLibDir;
    public final File mDataDirFile;
    public final ClassLoader mBaseClassLoader;
    public final boolean mSecurityViolation;
    public final boolean mIncludeCode;
    public final CompatibilityInfoHolder mCompatibilityInfo = new CompatibilityInfoHolder();
    public Resources mResources;
    public ClassLoader mClassLoader;
    public Application mApplication;
    public final HashMap<Context, HashMap<BroadcastReceiver, ReceiverDispatcher>> mReceivers = new HashMap();
    public final HashMap<Context, HashMap<BroadcastReceiver, ReceiverDispatcher>> mUnregisteredReceivers = new HashMap();
    public final HashMap<Context, HashMap<ServiceConnection, ServiceDispatcher>> mServices = new HashMap();
    public final HashMap<Context, HashMap<ServiceConnection, ServiceDispatcher>> mUnboundServices = new HashMap();
    public int mClientCount = 0;

    public Application getApplication() {
        return this.mApplication;
    }

    public LoadedApk(ActivityThread activityThread, ApplicationInfo aInfo, CompatibilityInfo compatInfo, ActivityThread mainThread, ClassLoader baseLoader, boolean securityViolation, boolean includeCode) {
        this.mActivityThread = activityThread;
        this.mApplicationInfo = aInfo;
        this.mPackageName = aInfo.packageName;
        this.mAppDir = aInfo.sourceDir;
        this.mResDir = aInfo.uid == Process.myUid() ? aInfo.sourceDir : aInfo.publicSourceDir;
        this.mSharedLibraries = aInfo.sharedLibraryFiles;
        this.mDataDir = aInfo.dataDir;
        this.mDataDirFile = this.mDataDir != null ? new File(this.mDataDir) : null;
        this.mLibDir = aInfo.nativeLibraryDir;
        this.mBaseClassLoader = baseLoader;
        this.mSecurityViolation = securityViolation;
        this.mIncludeCode = includeCode;
        this.mCompatibilityInfo.set(compatInfo);
        if (this.mAppDir == null) {
            if (ActivityThread.mSystemContext == null) {
                ActivityThread.mSystemContext = ContextImpl.createSystemContext(mainThread);
                ActivityThread.mSystemContext.getResources().updateConfiguration(mainThread.getConfiguration(), mainThread.getDisplayMetricsLocked(compatInfo, false), compatInfo);
            }
            this.mClassLoader = ActivityThread.mSystemContext.getClassLoader();
            this.mResources = ActivityThread.mSystemContext.getResources();
        }
    }

    public LoadedApk(ActivityThread activityThread, String name, Context systemContext, ApplicationInfo info, CompatibilityInfo compatInfo) {
        this.mActivityThread = activityThread;
        this.mApplicationInfo = info != null ? info : new ApplicationInfo();
        this.mApplicationInfo.packageName = name;
        this.mPackageName = name;
        this.mAppDir = null;
        this.mResDir = null;
        this.mSharedLibraries = null;
        this.mDataDir = null;
        this.mDataDirFile = null;
        this.mLibDir = null;
        this.mBaseClassLoader = null;
        this.mSecurityViolation = false;
        this.mIncludeCode = true;
        this.mClassLoader = systemContext.getClassLoader();
        this.mResources = systemContext.getResources();
        this.mCompatibilityInfo.set(compatInfo);
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mApplicationInfo;
    }

    public boolean isSecurityViolation() {
        return this.mSecurityViolation;
    }

    public static String[] getLibrariesFor(String packageName) {
        ApplicationInfo ai = null;
        try {
            ai = ActivityThread.getPackageManager().getApplicationInfo(packageName, 1024);
        }
        catch (RemoteException e) {
            throw new AssertionError((Object)e);
        }
        if (ai == null) {
            return null;
        }
        return ai.sharedLibraryFiles;
    }

    public static String combineLibs(String[] list1, String[] list2) {
        boolean dupCheck;
        StringBuilder result = new StringBuilder(300);
        boolean first = true;
        if (list1 != null) {
            for (String s : list1) {
                if (first) {
                    first = false;
                } else {
                    result.append(':');
                }
                result.append(s);
            }
        }
        boolean bl = dupCheck = !first;
        if (list2 != null) {
            for (String s : list2) {
                if (dupCheck && ArrayUtils.contains(list1, s)) continue;
                if (first) {
                    first = false;
                } else {
                    result.append(':');
                }
                result.append(s);
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        LoadedApk loadedApk = this;
        synchronized (loadedApk) {
            if (this.mClassLoader != null) {
                return this.mClassLoader;
            }
            if (this.mIncludeCode && !this.mPackageName.equals("android")) {
                String zip = this.mAppDir;
                String instrumentationAppDir = this.mActivityThread.mInstrumentationAppDir;
                String instrumentationAppPackage = this.mActivityThread.mInstrumentationAppPackage;
                String instrumentedAppDir = this.mActivityThread.mInstrumentedAppDir;
                String[] instrumentationLibs = null;
                if (this.mAppDir.equals(instrumentationAppDir) || this.mAppDir.equals(instrumentedAppDir)) {
                    zip = instrumentationAppDir + ":" + instrumentedAppDir;
                    if (!instrumentedAppDir.equals(instrumentationAppDir)) {
                        instrumentationLibs = LoadedApk.getLibrariesFor(instrumentationAppPackage);
                    }
                }
                if (this.mSharedLibraries != null || instrumentationLibs != null) {
                    zip = LoadedApk.combineLibs(this.mSharedLibraries, instrumentationLibs) + ':' + zip;
                }
                StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
                this.mClassLoader = ApplicationLoaders.getDefault().getClassLoader(zip, this.mLibDir, this.mBaseClassLoader);
                this.initializeJavaContextClassLoader();
                StrictMode.setThreadPolicy(oldPolicy);
            } else {
                this.mClassLoader = this.mBaseClassLoader == null ? ClassLoader.getSystemClassLoader() : this.mBaseClassLoader;
            }
            return this.mClassLoader;
        }
    }

    public void initializeJavaContextClassLoader() {
        PackageInfo pi;
        IPackageManager pm = ActivityThread.getPackageManager();
        try {
            pi = pm.getPackageInfo(this.mPackageName, 0);
        }
        catch (RemoteException e) {
            throw new AssertionError((Object)e);
        }
        boolean sharedUserIdSet = pi.sharedUserId != null;
        boolean processNameNotDefault = pi.applicationInfo != null && !this.mPackageName.equals(pi.applicationInfo.processName);
        boolean sharable = sharedUserIdSet || processNameNotDefault;
        ClassLoader contextClassLoader = sharable ? new WarningContextClassLoader(null) : this.mClassLoader;
        Thread.currentThread().setContextClassLoader(contextClassLoader);
    }

    public String getAppDir() {
        return this.mAppDir;
    }

    public String getResDir() {
        return this.mResDir;
    }

    public String getDataDir() {
        return this.mDataDir;
    }

    public File getDataDirFile() {
        return this.mDataDirFile;
    }

    public AssetManager getAssets(ActivityThread mainThread) {
        return this.getResources(mainThread).getAssets();
    }

    public Resources getResources(ActivityThread mainThread) {
        if (this.mResources == null) {
            this.mResources = mainThread.getTopLevelResources(this.mResDir, this);
        }
        return this.mResources;
    }

    public Application makeApplication(boolean forceDefaultAppClass, Instrumentation instrumentation) {
        Application app;
        block8: {
            block7: {
                if (this.mApplication != null) {
                    return this.mApplication;
                }
                app = null;
                String appClass = this.mApplicationInfo.className;
                if (forceDefaultAppClass || appClass == null) {
                    appClass = "android.app.Application";
                }
                try {
                    ClassLoader cl = this.getClassLoader();
                    ContextImpl appContext = new ContextImpl();
                    appContext.init(this, null, this.mActivityThread);
                    app = this.mActivityThread.mInstrumentation.newApplication(cl, appClass, appContext);
                    appContext.setOuterContext(app);
                }
                catch (Exception e) {
                    if (this.mActivityThread.mInstrumentation.onException(app, e)) break block7;
                    throw new RuntimeException("Unable to instantiate application " + appClass + ": " + e.toString(), e);
                }
            }
            this.mActivityThread.mAllApplications.add(app);
            this.mApplication = app;
            if (instrumentation != null) {
                try {
                    instrumentation.callApplicationOnCreate(app);
                }
                catch (Exception e) {
                    if (instrumentation.onException(app, e)) break block8;
                    throw new RuntimeException("Unable to create application " + app.getClass().getName() + ": " + e.toString(), e);
                }
            }
        }
        return app;
    }

    public void removeContextRegistrations(Context context, String who, String what) {
        HashMap<BroadcastReceiver, ReceiverDispatcher> rmap = this.mReceivers.remove(context);
        if (rmap != null) {
            for (ReceiverDispatcher rd : rmap.values()) {
                IntentReceiverLeaked leak = new IntentReceiverLeaked(what + " " + who + " has leaked IntentReceiver " + rd.getIntentReceiver() + " that was " + "originally registered here. Are you missing a " + "call to unregisterReceiver()?");
                leak.setStackTrace(rd.getLocation().getStackTrace());
                Slog.e("ActivityThread", leak.getMessage(), leak);
                try {
                    ActivityManagerNative.getDefault().unregisterReceiver(rd.getIIntentReceiver());
                }
                catch (RemoteException e) {}
            }
        }
        this.mUnregisteredReceivers.remove(context);
        HashMap<ServiceConnection, ServiceDispatcher> smap = this.mServices.remove(context);
        if (smap != null) {
            for (ServiceDispatcher sd : smap.values()) {
                ServiceConnectionLeaked leak = new ServiceConnectionLeaked(what + " " + who + " has leaked ServiceConnection " + sd.getServiceConnection() + " that was originally bound here");
                leak.setStackTrace(sd.getLocation().getStackTrace());
                Slog.e("ActivityThread", leak.getMessage(), leak);
                try {
                    ActivityManagerNative.getDefault().unbindService(sd.getIServiceConnection());
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                sd.doForget();
            }
        }
        this.mUnboundServices.remove(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIntentReceiver getReceiverDispatcher(BroadcastReceiver r, Context context, Handler handler, Instrumentation instrumentation, boolean registered) {
        HashMap<Context, HashMap<BroadcastReceiver, ReceiverDispatcher>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ReceiverDispatcher rd = null;
            HashMap<BroadcastReceiver, ReceiverDispatcher> map = null;
            if (registered && (map = this.mReceivers.get(context)) != null) {
                rd = map.get(r);
            }
            if (rd == null) {
                rd = new ReceiverDispatcher(r, context, handler, instrumentation, registered);
                if (registered) {
                    if (map == null) {
                        map = new HashMap();
                        this.mReceivers.put(context, map);
                    }
                    map.put(r, rd);
                }
            } else {
                rd.validate(context, handler);
            }
            rd.mForgotten = false;
            return rd.getIIntentReceiver();
        }
    }

    public IIntentReceiver forgetReceiverDispatcher(Context context, BroadcastReceiver r) {
        HashMap<Context, HashMap<BroadcastReceiver, ReceiverDispatcher>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            HashMap<BroadcastReceiver, ReceiverDispatcher> map = this.mReceivers.get(context);
            ReceiverDispatcher rd = null;
            if (map != null && (rd = map.get(r)) != null) {
                map.remove(r);
                if (map.size() == 0) {
                    this.mReceivers.remove(context);
                }
                if (r.getDebugUnregister()) {
                    HashMap<BroadcastReceiver, ReceiverDispatcher> holder = this.mUnregisteredReceivers.get(context);
                    if (holder == null) {
                        holder = new HashMap();
                        this.mUnregisteredReceivers.put(context, holder);
                    }
                    IllegalArgumentException ex = new IllegalArgumentException("Originally unregistered here:");
                    ex.fillInStackTrace();
                    rd.setUnregisterLocation(ex);
                    holder.put(r, rd);
                }
                rd.mForgotten = true;
                return rd.getIIntentReceiver();
            }
            HashMap<BroadcastReceiver, ReceiverDispatcher> holder = this.mUnregisteredReceivers.get(context);
            if (holder != null && (rd = holder.get(r)) != null) {
                RuntimeException ex = rd.getUnregisterLocation();
                throw new IllegalArgumentException("Unregistering Receiver " + r + " that was already unregistered", ex);
            }
            if (context == null) {
                throw new IllegalStateException("Unbinding Receiver " + r + " from Context that is no longer in use: " + context);
            }
            throw new IllegalArgumentException("Receiver not registered: " + r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceConnection getServiceDispatcher(ServiceConnection c, Context context, Handler handler, int flags) {
        HashMap<Context, HashMap<ServiceConnection, ServiceDispatcher>> hashMap = this.mServices;
        synchronized (hashMap) {
            ServiceDispatcher sd = null;
            HashMap<ServiceConnection, ServiceDispatcher> map = this.mServices.get(context);
            if (map != null) {
                sd = map.get(c);
            }
            if (sd == null) {
                sd = new ServiceDispatcher(c, context, handler, flags);
                if (map == null) {
                    map = new HashMap();
                    this.mServices.put(context, map);
                }
                map.put(c, sd);
            } else {
                sd.validate(context, handler);
            }
            return sd.getIServiceConnection();
        }
    }

    public IServiceConnection forgetServiceDispatcher(Context context, ServiceConnection c) {
        HashMap<Context, HashMap<ServiceConnection, ServiceDispatcher>> hashMap = this.mServices;
        synchronized (hashMap) {
            HashMap<ServiceConnection, ServiceDispatcher> map = this.mServices.get(context);
            ServiceDispatcher sd = null;
            if (map != null && (sd = map.get(c)) != null) {
                map.remove(c);
                sd.doForget();
                if (map.size() == 0) {
                    this.mServices.remove(context);
                }
                if ((sd.getFlags() & 2) != 0) {
                    HashMap<ServiceConnection, ServiceDispatcher> holder = this.mUnboundServices.get(context);
                    if (holder == null) {
                        holder = new HashMap();
                        this.mUnboundServices.put(context, holder);
                    }
                    IllegalArgumentException ex = new IllegalArgumentException("Originally unbound here:");
                    ex.fillInStackTrace();
                    sd.setUnbindLocation(ex);
                    holder.put(c, sd);
                }
                return sd.getIServiceConnection();
            }
            HashMap<ServiceConnection, ServiceDispatcher> holder = this.mUnboundServices.get(context);
            if (holder != null && (sd = holder.get(c)) != null) {
                RuntimeException ex = sd.getUnbindLocation();
                throw new IllegalArgumentException("Unbinding Service " + c + " that was already unbound", ex);
            }
            if (context == null) {
                throw new IllegalStateException("Unbinding Service " + c + " from Context that is no longer in use: " + context);
            }
            throw new IllegalArgumentException("Service not registered: " + c);
        }
    }

    public static class 1 {
    }

    public static class ServiceDispatcher {
        public final InnerConnection mIServiceConnection;
        public final ServiceConnection mConnection;
        public final Context mContext;
        public final Handler mActivityThread;
        public final ServiceConnectionLeaked mLocation;
        public final int mFlags;
        public RuntimeException mUnbindLocation;
        public boolean mDied;
        public final HashMap<ComponentName, ConnectionInfo> mActiveConnections = new HashMap();

        public ServiceDispatcher(ServiceConnection conn, Context context, Handler activityThread, int flags) {
            this.mIServiceConnection = new InnerConnection(this);
            this.mConnection = conn;
            this.mContext = context;
            this.mActivityThread = activityThread;
            this.mLocation = new ServiceConnectionLeaked(null);
            this.mLocation.fillInStackTrace();
            this.mFlags = flags;
        }

        public void validate(Context context, Handler activityThread) {
            if (this.mContext != context) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != activityThread) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing handler (was " + this.mActivityThread + " now " + activityThread + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doForget() {
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                for (ConnectionInfo ci : this.mActiveConnections.values()) {
                    ci.binder.unlinkToDeath(ci.deathMonitor, 0);
                }
                this.mActiveConnections.clear();
            }
        }

        public ServiceConnectionLeaked getLocation() {
            return this.mLocation;
        }

        public ServiceConnection getServiceConnection() {
            return this.mConnection;
        }

        public IServiceConnection getIServiceConnection() {
            return this.mIServiceConnection;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public void setUnbindLocation(RuntimeException ex) {
            this.mUnbindLocation = ex;
        }

        public RuntimeException getUnbindLocation() {
            return this.mUnbindLocation;
        }

        public void connected(ComponentName name, IBinder service) {
            if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(name, service, 0));
            } else {
                this.doConnected(name, service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void death(ComponentName name, IBinder service) {
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                this.mDied = true;
                ConnectionInfo old = this.mActiveConnections.remove(name);
                if (old == null || old.binder != service) {
                    return;
                }
                old.binder.unlinkToDeath(old.deathMonitor, 0);
            }
            if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(name, service, 1));
            } else {
                this.doDeath(name, service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doConnected(ComponentName name, IBinder service) {
            ConnectionInfo old;
            ServiceDispatcher serviceDispatcher = this;
            synchronized (serviceDispatcher) {
                old = this.mActiveConnections.get(name);
                if (old != null && old.binder == service) {
                    return;
                }
                if (service != null) {
                    this.mDied = false;
                    ConnectionInfo info = new ConnectionInfo(null);
                    info.binder = service;
                    info.deathMonitor = new DeathMonitor(name, service);
                    try {
                        service.linkToDeath(info.deathMonitor, 0);
                        this.mActiveConnections.put(name, info);
                    }
                    catch (RemoteException e) {
                        this.mActiveConnections.remove(name);
                        return;
                    }
                } else {
                    this.mActiveConnections.remove(name);
                }
                if (old != null) {
                    old.binder.unlinkToDeath(old.deathMonitor, 0);
                }
            }
            if (old != null) {
                this.mConnection.onServiceDisconnected(name);
            }
            if (service != null) {
                this.mConnection.onServiceConnected(name, service);
            }
        }

        public void doDeath(ComponentName name, IBinder service) {
            this.mConnection.onServiceDisconnected(name);
        }

        public class DeathMonitor
        implements IBinder.DeathRecipient {
            public final ComponentName mName;
            public final IBinder mService;

            public DeathMonitor(ComponentName name, IBinder service) {
                this.mName = name;
                this.mService = service;
            }

            public void binderDied() {
                ServiceDispatcher.this.death(this.mName, this.mService);
            }
        }

        public class RunConnection
        implements Runnable {
            public final ComponentName mName;
            public final IBinder mService;
            public final int mCommand;

            public RunConnection(ComponentName name, IBinder service, int command) {
                this.mName = name;
                this.mService = service;
                this.mCommand = command;
            }

            public void run() {
                if (this.mCommand == 0) {
                    ServiceDispatcher.this.doConnected(this.mName, this.mService);
                } else if (this.mCommand == 1) {
                    ServiceDispatcher.this.doDeath(this.mName, this.mService);
                }
            }
        }

        public static class InnerConnection
        extends IServiceConnection.Stub {
            public final WeakReference<ServiceDispatcher> mDispatcher;

            public InnerConnection(ServiceDispatcher sd) {
                this.mDispatcher = new WeakReference<ServiceDispatcher>(sd);
            }

            public void connected(ComponentName name, IBinder service) throws RemoteException {
                ServiceDispatcher sd = (ServiceDispatcher)this.mDispatcher.get();
                if (sd != null) {
                    sd.connected(name, service);
                }
            }
        }

        public static class ConnectionInfo {
            public IBinder binder;
            public IBinder.DeathRecipient deathMonitor;

            public ConnectionInfo() {
            }

            public /* synthetic */ ConnectionInfo(1 x0) {
                this();
            }
        }
    }

    public static class ReceiverDispatcher {
        public final IIntentReceiver.Stub mIIntentReceiver;
        public final BroadcastReceiver mReceiver;
        public final Context mContext;
        public final Handler mActivityThread;
        public final Instrumentation mInstrumentation;
        public final boolean mRegistered;
        public final IntentReceiverLeaked mLocation;
        public RuntimeException mUnregisterLocation;
        public boolean mForgotten;

        public ReceiverDispatcher(BroadcastReceiver receiver, Context context, Handler activityThread, Instrumentation instrumentation, boolean registered) {
            if (activityThread == null) {
                throw new NullPointerException("Handler must not be null");
            }
            this.mIIntentReceiver = new InnerReceiver(this, !registered);
            this.mReceiver = receiver;
            this.mContext = context;
            this.mActivityThread = activityThread;
            this.mInstrumentation = instrumentation;
            this.mRegistered = registered;
            this.mLocation = new IntentReceiverLeaked(null);
            this.mLocation.fillInStackTrace();
        }

        public void validate(Context context, Handler activityThread) {
            if (this.mContext != context) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != activityThread) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing handler (was " + this.mActivityThread + " now " + activityThread + ")");
            }
        }

        public IntentReceiverLeaked getLocation() {
            return this.mLocation;
        }

        public BroadcastReceiver getIntentReceiver() {
            return this.mReceiver;
        }

        public IIntentReceiver getIIntentReceiver() {
            return this.mIIntentReceiver;
        }

        public void setUnregisterLocation(RuntimeException ex) {
            this.mUnregisterLocation = ex;
        }

        public RuntimeException getUnregisterLocation() {
            return this.mUnregisterLocation;
        }

        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky) {
            Args args = new Args(intent, resultCode, data, extras, ordered, sticky);
            if (!this.mActivityThread.post(args) && this.mRegistered && ordered) {
                IActivityManager mgr = ActivityManagerNative.getDefault();
                args.sendFinished(mgr);
            }
        }

        public class Args
        extends BroadcastReceiver.PendingResult
        implements Runnable {
            public Intent mCurIntent;
            public final boolean mOrdered;

            public Args(Intent intent, int resultCode, String resultData, Bundle resultExtras, boolean ordered, boolean sticky) {
                super(resultCode, resultData, resultExtras, ReceiverDispatcher.this.mRegistered ? 1 : 2, ordered, sticky, ReceiverDispatcher.this.mIIntentReceiver.asBinder());
                this.mCurIntent = intent;
                this.mOrdered = ordered;
            }

            public void run() {
                BroadcastReceiver receiver;
                block6: {
                    receiver = ReceiverDispatcher.this.mReceiver;
                    boolean ordered = this.mOrdered;
                    IActivityManager mgr = ActivityManagerNative.getDefault();
                    Intent intent = this.mCurIntent;
                    this.mCurIntent = null;
                    if (receiver == null || ReceiverDispatcher.this.mForgotten) {
                        if (ReceiverDispatcher.this.mRegistered && ordered) {
                            this.sendFinished(mgr);
                        }
                        return;
                    }
                    try {
                        ClassLoader cl = ReceiverDispatcher.this.mReceiver.getClass().getClassLoader();
                        intent.setExtrasClassLoader(cl);
                        this.setExtrasClassLoader(cl);
                        receiver.setPendingResult(this);
                        receiver.onReceive(ReceiverDispatcher.this.mContext, intent);
                    }
                    catch (Exception e) {
                        if (ReceiverDispatcher.this.mRegistered && ordered) {
                            this.sendFinished(mgr);
                        }
                        if (ReceiverDispatcher.this.mInstrumentation != null && ReceiverDispatcher.this.mInstrumentation.onException(ReceiverDispatcher.this.mReceiver, e)) break block6;
                        throw new RuntimeException("Error receiving broadcast " + intent + " in " + ReceiverDispatcher.this.mReceiver, e);
                    }
                }
                if (receiver.getPendingResult() != null) {
                    this.finish();
                }
            }
        }

        public static class InnerReceiver
        extends IIntentReceiver.Stub {
            public final WeakReference<ReceiverDispatcher> mDispatcher;
            public final ReceiverDispatcher mStrongRef;

            public InnerReceiver(ReceiverDispatcher rd, boolean strong) {
                this.mDispatcher = new WeakReference<ReceiverDispatcher>(rd);
                this.mStrongRef = strong ? rd : null;
            }

            public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky) {
                ReceiverDispatcher rd = (ReceiverDispatcher)this.mDispatcher.get();
                if (rd != null) {
                    rd.performReceive(intent, resultCode, data, extras, ordered, sticky);
                } else {
                    IActivityManager mgr = ActivityManagerNative.getDefault();
                    try {
                        mgr.finishReceiver(this, resultCode, data, extras, false);
                    }
                    catch (RemoteException e) {
                        Slog.w("ActivityThread", "Couldn't finish broadcast to unregistered receiver");
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WarningContextClassLoader
    extends ClassLoader {
        public static boolean warned = false;

        public WarningContextClassLoader() {
        }

        public void warn(String methodName) {
            if (warned) {
                return;
            }
            warned = true;
            Thread.currentThread().setContextClassLoader(this.getParent());
            Slog.w("ActivityThread", "ClassLoader." + methodName + ": " + "The class loader returned by " + "Thread.getContextClassLoader() may fail for processes " + "that host multiple applications. You should explicitly " + "specify a context class loader. For example: " + "Thread.setContextClassLoader(getClass().getClassLoader());");
        }

        @Override
        public URL getResource(String resName) {
            this.warn("getResource");
            return this.getParent().getResource(resName);
        }

        @Override
        public Enumeration<URL> getResources(String resName) throws IOException {
            this.warn("getResources");
            return this.getParent().getResources(resName);
        }

        @Override
        public InputStream getResourceAsStream(String resName) {
            this.warn("getResourceAsStream");
            return this.getParent().getResourceAsStream(resName);
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            this.warn("loadClass");
            return this.getParent().loadClass(className);
        }

        @Override
        public void setClassAssertionStatus(String cname, boolean enable) {
            this.warn("setClassAssertionStatus");
            this.getParent().setClassAssertionStatus(cname, enable);
        }

        @Override
        public void setPackageAssertionStatus(String pname, boolean enable) {
            this.warn("setPackageAssertionStatus");
            this.getParent().setPackageAssertionStatus(pname, enable);
        }

        @Override
        public void setDefaultAssertionStatus(boolean enable) {
            this.warn("setDefaultAssertionStatus");
            this.getParent().setDefaultAssertionStatus(enable);
        }

        @Override
        public void clearAssertionStatus() {
            this.warn("clearAssertionStatus");
            this.getParent().clearAssertionStatus();
        }

        public /* synthetic */ WarningContextClassLoader(1 x0) {
            this();
        }
    }
}

