/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.statusbar.IStatusBarService;

public class StatusBarManager {
    public static final int DISABLE_EXPAND = 65536;
    public static final int DISABLE_NOTIFICATION_ICONS = 131072;
    public static final int DISABLE_NOTIFICATION_ALERTS = 262144;
    public static final int DISABLE_NOTIFICATION_TICKER = 524288;
    public static final int DISABLE_SYSTEM_INFO = 0x100000;
    public static final int DISABLE_NAVIGATION = 0x200000;
    public static final int DISABLE_BACK = 0x400000;
    public static final int DISABLE_CLOCK = 0x800000;
    public static final int DISABLE_NONE = 0;
    public static final int DISABLE_MASK = 0xFF0000;
    public Context mContext;
    public IStatusBarService mService;
    public IBinder mToken = new Binder();

    public StatusBarManager(Context context) {
        this.mContext = context;
        this.mService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
    }

    public void disable(int what) {
        try {
            this.mService.disable(what, this.mToken, this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void expand() {
        try {
            this.mService.expand();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void collapse() {
        try {
            this.mService.collapse();
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setIcon(String slot, int iconId, int iconLevel) {
        try {
            this.mService.setIcon(slot, this.mContext.getPackageName(), iconId, iconLevel);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void removeIcon(String slot) {
        try {
            this.mService.removeIcon(slot);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setIconVisibility(String slot, boolean visible) {
        try {
            this.mService.setIconVisibility(slot, visible);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex);
        }
    }
}

