/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.OutputStream;

public class BluetoothOutputStream
extends OutputStream {
    public BluetoothSocket mSocket;

    public BluetoothOutputStream(BluetoothSocket s) {
        this.mSocket = s;
    }

    public void close() throws IOException {
        this.mSocket.close();
    }

    public void write(int oneByte) throws IOException {
        byte[] b = new byte[]{(byte)oneByte};
        this.mSocket.write(b, 0, 1);
    }

    public void write(byte[] b, int offset, int count) throws IOException {
        if (b == null) {
            throw new NullPointerException("buffer is null");
        }
        if ((offset | count) < 0 || count > b.length - offset) {
            throw new IndexOutOfBoundsException("invalid offset or length");
        }
        this.mSocket.write(b, offset, count);
    }
}

