/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ISyncAdapter;
import android.content.ISyncContext;
import android.content.SyncContext;
import android.content.SyncResult;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractThreadedSyncAdapter {
    @Deprecated
    public static final int LOG_SYNC_DETAILS = 2743;
    public final Context mContext;
    public final AtomicInteger mNumSyncStarts;
    public final ISyncAdapterImpl mISyncAdapterImpl;
    public final HashMap<Account, SyncThread> mSyncThreads = new HashMap();
    public final Object mSyncThreadLock = new Object();
    public final boolean mAutoInitialize;
    public boolean mAllowParallelSyncs;

    public AbstractThreadedSyncAdapter(Context context, boolean autoInitialize) {
        this(context, autoInitialize, false);
    }

    public AbstractThreadedSyncAdapter(Context context, boolean autoInitialize, boolean allowParallelSyncs) {
        this.mContext = context;
        this.mISyncAdapterImpl = new ISyncAdapterImpl(null);
        this.mNumSyncStarts = new AtomicInteger(0);
        this.mAutoInitialize = autoInitialize;
        this.mAllowParallelSyncs = allowParallelSyncs;
    }

    public Context getContext() {
        return this.mContext;
    }

    public Account toSyncKey(Account account) {
        if (this.mAllowParallelSyncs) {
            return account;
        }
        return null;
    }

    public IBinder getSyncAdapterBinder() {
        return this.mISyncAdapterImpl.asBinder();
    }

    public abstract void onPerformSync(Account var1, Bundle var2, String var3, ContentProviderClient var4, SyncResult var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSyncCanceled() {
        SyncThread syncThread;
        Object object = this.mSyncThreadLock;
        synchronized (object) {
            syncThread = this.mSyncThreads.get(null);
        }
        if (syncThread != null) {
            syncThread.interrupt();
        }
    }

    public void onSyncCanceled(Thread thread) {
        thread.interrupt();
    }

    public static class 1 {
    }

    public class SyncThread
    extends Thread {
        public final SyncContext mSyncContext;
        public final String mAuthority;
        public final Account mAccount;
        public final Bundle mExtras;
        public final Account mThreadsKey;

        public SyncThread(String name, SyncContext syncContext, String authority, Account account, Bundle extras) {
            super(name);
            this.mSyncContext = syncContext;
            this.mAuthority = authority;
            this.mAccount = account;
            this.mExtras = extras;
            this.mThreadsKey = AbstractThreadedSyncAdapter.this.toSyncKey(account);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ContentProviderClient provider;
            SyncResult syncResult;
            block16: {
                block15: {
                    Process.setThreadPriority(10);
                    syncResult = new SyncResult();
                    provider = null;
                    try {
                        if (!this.isCanceled()) break block17;
                        Object var4_3 = null;
                        if (provider == null) break block15;
                        provider.release();
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (provider != null) {
                            provider.release();
                        }
                        if (!this.isCanceled()) {
                            this.mSyncContext.onFinished(syncResult);
                        }
                        Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
                        synchronized (object) {
                            AbstractThreadedSyncAdapter.this.mSyncThreads.remove(this.mThreadsKey);
                        }
                        throw throwable;
                    }
                }
                if (!this.isCanceled()) {
                    this.mSyncContext.onFinished(syncResult);
                }
                Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
                synchronized (object) {
                    AbstractThreadedSyncAdapter.this.mSyncThreads.remove(this.mThreadsKey);
                }
                {
                    block17: {
                        return;
                    }
                    provider = AbstractThreadedSyncAdapter.this.mContext.getContentResolver().acquireContentProviderClient(this.mAuthority);
                    if (provider != null) {
                        AbstractThreadedSyncAdapter.this.onPerformSync(this.mAccount, this.mExtras, this.mAuthority, provider, syncResult);
                        break block16;
                    }
                    syncResult.databaseError = true;
                }
            }
            Object var4_4 = null;
            if (provider != null) {
                provider.release();
            }
            if (!this.isCanceled()) {
                this.mSyncContext.onFinished(syncResult);
            }
            Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
            synchronized (object) {
                AbstractThreadedSyncAdapter.this.mSyncThreads.remove(this.mThreadsKey);
            }
        }

        public boolean isCanceled() {
            return Thread.currentThread().isInterrupted();
        }

        public /* synthetic */ SyncThread(String x1, SyncContext x2, String x3, Account x4, Bundle x5, 1 x6) {
            this(x1, x2, x3, x4, x5);
        }
    }

    public class ISyncAdapterImpl
    extends ISyncAdapter.Stub {
        public ISyncAdapterImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startSync(ISyncContext syncContext, String authority, Account account, Bundle extras) {
            boolean alreadyInProgress;
            SyncContext syncContextClient = new SyncContext(syncContext);
            Account threadsKey = AbstractThreadedSyncAdapter.this.toSyncKey(account);
            Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
            synchronized (object) {
                if (!AbstractThreadedSyncAdapter.this.mSyncThreads.containsKey(threadsKey)) {
                    if (AbstractThreadedSyncAdapter.this.mAutoInitialize && extras != null && extras.getBoolean("initialize", false)) {
                        if (ContentResolver.getIsSyncable(account, authority) < 0) {
                            ContentResolver.setIsSyncable(account, authority, 1);
                        }
                        syncContextClient.onFinished(new SyncResult());
                        return;
                    }
                    SyncThread syncThread = new SyncThread("SyncAdapterThread-" + AbstractThreadedSyncAdapter.this.mNumSyncStarts.incrementAndGet(), syncContextClient, authority, account, extras, null);
                    AbstractThreadedSyncAdapter.this.mSyncThreads.put(threadsKey, syncThread);
                    syncThread.start();
                    alreadyInProgress = false;
                } else {
                    alreadyInProgress = true;
                }
            }
            if (alreadyInProgress) {
                syncContextClient.onFinished(SyncResult.ALREADY_IN_PROGRESS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelSync(ISyncContext syncContext) {
            SyncThread info = null;
            Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
            synchronized (object) {
                for (SyncThread current : AbstractThreadedSyncAdapter.this.mSyncThreads.values()) {
                    if (current.mSyncContext.getSyncContextBinder() != syncContext.asBinder()) continue;
                    info = current;
                    break;
                }
            }
            if (info != null) {
                if (AbstractThreadedSyncAdapter.this.mAllowParallelSyncs) {
                    AbstractThreadedSyncAdapter.this.onSyncCanceled(info);
                } else {
                    AbstractThreadedSyncAdapter.this.onSyncCanceled();
                }
            }
        }

        public void initialize(Account account, String authority) throws RemoteException {
            Bundle extras = new Bundle();
            extras.putBoolean("initialize", true);
            this.startSync(null, authority, account, extras);
        }

        public /* synthetic */ ISyncAdapterImpl(1 x1) {
            this();
        }
    }
}

