/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Context;
import android.content.IClipboard;
import android.content.IOnPrimaryClipChangedListener;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.util.ArrayList;

public class ClipboardManager
extends android.text.ClipboardManager {
    public static final Object sStaticLock = new Object();
    public static IClipboard sService;
    public final Context mContext;
    public final ArrayList<OnPrimaryClipChangedListener> mPrimaryClipChangedListeners = new ArrayList();
    public final IOnPrimaryClipChangedListener.Stub mPrimaryClipChangedServiceListener = new IOnPrimaryClipChangedListener.Stub(){

        public void dispatchPrimaryClipChanged() {
            ClipboardManager.this.mHandler.sendEmptyMessage(1);
        }
    };
    public static final int MSG_REPORT_PRIMARY_CLIP_CHANGED = 1;
    public final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ClipboardManager.this.reportPrimaryClipChanged();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IClipboard getService() {
        Object object = sStaticLock;
        synchronized (object) {
            if (sService != null) {
                return sService;
            }
            IBinder b = ServiceManager.getService("clipboard");
            sService = IClipboard.Stub.asInterface(b);
            return sService;
        }
    }

    public ClipboardManager(Context context, Handler handler) {
        this.mContext = context;
    }

    public void setPrimaryClip(ClipData clip) {
        try {
            ClipboardManager.getService().setPrimaryClip(clip);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public ClipData getPrimaryClip() {
        try {
            return ClipboardManager.getService().getPrimaryClip(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public ClipDescription getPrimaryClipDescription() {
        try {
            return ClipboardManager.getService().getPrimaryClipDescription();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public boolean hasPrimaryClip() {
        try {
            return ClipboardManager.getService().hasPrimaryClip();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimaryClipChangedListener(OnPrimaryClipChangedListener what) {
        ArrayList<OnPrimaryClipChangedListener> arrayList = this.mPrimaryClipChangedListeners;
        synchronized (arrayList) {
            if (this.mPrimaryClipChangedListeners.size() == 0) {
                try {
                    ClipboardManager.getService().addPrimaryClipChangedListener(this.mPrimaryClipChangedServiceListener);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mPrimaryClipChangedListeners.add(what);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrimaryClipChangedListener(OnPrimaryClipChangedListener what) {
        ArrayList<OnPrimaryClipChangedListener> arrayList = this.mPrimaryClipChangedListeners;
        synchronized (arrayList) {
            this.mPrimaryClipChangedListeners.remove(what);
            if (this.mPrimaryClipChangedListeners.size() == 0) {
                try {
                    ClipboardManager.getService().removePrimaryClipChangedListener(this.mPrimaryClipChangedServiceListener);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    public CharSequence getText() {
        ClipData clip = this.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).coerceToText(this.mContext);
        }
        return null;
    }

    public void setText(CharSequence text) {
        this.setPrimaryClip(ClipData.newPlainText(null, text));
    }

    public boolean hasText() {
        try {
            return ClipboardManager.getService().hasClipboardText();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportPrimaryClipChanged() {
        Object[] listeners;
        ArrayList<OnPrimaryClipChangedListener> arrayList = this.mPrimaryClipChangedListeners;
        synchronized (arrayList) {
            int N = this.mPrimaryClipChangedListeners.size();
            if (N <= 0) {
                return;
            }
            listeners = this.mPrimaryClipChangedListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((OnPrimaryClipChangedListener)listeners[i]).onPrimaryClipChanged();
        }
    }

    public static interface OnPrimaryClipChangedListener {
        public void onPrimaryClipChanged();
    }
}

