/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.net.http.AndroidHttpClient;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlDocumentProvider
extends ContentProvider {
    public static final String LOG_TAG = "XmlDocumentProvider";
    public AndroidHttpClient mHttpClient;

    public boolean onCreate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Object resourceUri;
        XmlPullParser parser = null;
        this.mHttpClient = null;
        String url = uri.getQueryParameter("url");
        if (url != null) {
            parser = this.getUriXmlPullParser(url);
        } else {
            String resource = uri.getQueryParameter("resource");
            if (resource != null) {
                resourceUri = Uri.parse("android.resource://" + this.getContext().getPackageName() + "/" + resource);
                parser = this.getResourceXmlPullParser((Uri)resourceUri);
            }
        }
        if (parser == null) return null;
        XMLCursor xmlCursor = new XMLCursor(selection, projection);
        try {
            try {
                xmlCursor.parseWith(parser);
                resourceUri = xmlCursor;
                Object var11_12 = null;
                if (this.mHttpClient == null) return resourceUri;
                this.mHttpClient.close();
                return resourceUri;
            }
            catch (IOException e) {
                Log.w(LOG_TAG, "I/O error while parsing XML " + uri, e);
                Object var11_13 = null;
                if (this.mHttpClient == null) return null;
                this.mHttpClient.close();
                return null;
            }
            catch (XmlPullParserException e) {
                Log.w(LOG_TAG, "Error while parsing XML " + uri, e);
                Object var11_14 = null;
                if (this.mHttpClient == null) return null;
                this.mHttpClient.close();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (this.mHttpClient == null) throw throwable;
            this.mHttpClient.close();
            throw throwable;
        }
    }

    public XmlPullParser getUriXmlPullParser(String url) {
        XmlPullParser parser = null;
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            parser = factory.newPullParser();
        }
        catch (XmlPullParserException e) {
            Log.e(LOG_TAG, "Unable to create XmlPullParser", e);
            return null;
        }
        InputStream inputStream = null;
        try {
            HttpEntity entity;
            HttpGet get = new HttpGet(url);
            this.mHttpClient = AndroidHttpClient.newInstance("Android");
            HttpResponse response = this.mHttpClient.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200 && (entity = response.getEntity()) != null) {
                inputStream = entity.getContent();
            }
        }
        catch (IOException e) {
            Log.w(LOG_TAG, "Error while retrieving XML file " + url, e);
            return null;
        }
        try {
            parser.setInput(inputStream, null);
        }
        catch (XmlPullParserException e) {
            Log.w(LOG_TAG, "Error while reading XML file from " + url, e);
            return null;
        }
        return parser;
    }

    public XmlPullParser getResourceXmlPullParser(Uri resourceUri) {
        try {
            ContentResolver.OpenResourceIdResult resourceId = this.getContext().getContentResolver().getResourceId(resourceUri);
            return resourceId.r.getXml(resourceId.id);
        }
        catch (FileNotFoundException e) {
            Log.w(LOG_TAG, "XML resource not found: " + resourceUri.toString(), e);
            return null;
        }
    }

    public String getType(Uri uri) {
        return "vnd.android.cursor.dir/xmldoc";
    }

    public Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException();
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException();
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException();
    }

    public static class XMLCursor
    extends MatrixCursor {
        public final Pattern mSelectionPattern;
        public Pattern[] mProjectionPatterns;
        public String[] mAttributeNames;
        public String[] mCurrentValues;
        public BitSet[] mActiveTextDepthMask;
        public final int mNumberOfProjections;

        public XMLCursor(String selection, String[] projections) {
            super(projections);
            this.mNumberOfProjections = projections.length - 1;
            this.mSelectionPattern = this.createPattern(selection);
            this.createProjectionPattern(projections);
        }

        public Pattern createPattern(String input) {
            String pattern = input.replaceAll("//", "/(.*/|)").replaceAll("^/", "^/") + "$";
            return Pattern.compile(pattern);
        }

        public void createProjectionPattern(String[] projections) {
            this.mProjectionPatterns = new Pattern[this.mNumberOfProjections];
            this.mAttributeNames = new String[this.mNumberOfProjections];
            this.mActiveTextDepthMask = new BitSet[this.mNumberOfProjections];
            this.mCurrentValues = new String[this.mNumberOfProjections + 1];
            for (int i = 0; i < this.mNumberOfProjections; ++i) {
                this.mActiveTextDepthMask[i] = new BitSet();
                String projection = projections[i + 1];
                int atIndex = projection.lastIndexOf(64, projection.length());
                if (atIndex >= 0) {
                    this.mAttributeNames[i] = projection.substring(atIndex + 1);
                    projection = projection.substring(0, atIndex);
                } else {
                    this.mAttributeNames[i] = null;
                }
                if (projection.charAt(0) == '.') {
                    projection = projection.substring(1);
                }
                this.mProjectionPatterns[i] = this.createPattern(projection);
            }
        }

        public void parseWith(XmlPullParser parser) throws IOException, XmlPullParserException {
            StringBuilder path = new StringBuilder();
            Stack<Integer> pathLengthStack = new Stack<Integer>();
            int currentNodeDepth = -1;
            int currentNodePathStartIndex = 0;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    pathLengthStack.push(path.length());
                    path.append('/');
                    String prefix = null;
                    try {
                        prefix = parser.getPrefix();
                    }
                    catch (RuntimeException e) {
                        prefix = null;
                    }
                    if (prefix != null) {
                        path.append(prefix);
                        path.append(':');
                    }
                    path.append(parser.getName());
                    if (currentNodeDepth >= 0) {
                        ++currentNodeDepth;
                    } else if (this.mSelectionPattern.matcher(path.toString()).matches()) {
                        currentNodeDepth = 0;
                        currentNodePathStartIndex = path.length();
                        this.mCurrentValues[0] = Integer.toString(this.getCount());
                        for (int i = 0; i < this.mNumberOfProjections; ++i) {
                            this.mCurrentValues[i + 1] = "";
                            this.mActiveTextDepthMask[i].clear();
                        }
                    }
                    if (currentNodeDepth >= 0) {
                        String localNodePath = path.substring(currentNodePathStartIndex);
                        for (int i = 0; i < this.mNumberOfProjections; ++i) {
                            if (!this.mProjectionPatterns[i].matcher(localNodePath).matches()) continue;
                            String attribute = this.mAttributeNames[i];
                            if (attribute != null) {
                                this.mCurrentValues[i + 1] = parser.getAttributeValue(null, attribute);
                                continue;
                            }
                            this.mActiveTextDepthMask[i].set(currentNodeDepth, true);
                        }
                    }
                } else if (eventType == 3) {
                    int length = (Integer)pathLengthStack.pop();
                    path.setLength(length);
                    if (currentNodeDepth >= 0) {
                        if (currentNodeDepth == 0) {
                            this.addRow(this.mCurrentValues);
                        } else {
                            for (int i = 0; i < this.mNumberOfProjections; ++i) {
                                this.mActiveTextDepthMask[i].set(currentNodeDepth, false);
                            }
                        }
                        --currentNodeDepth;
                    }
                } else if (eventType == 4 && !parser.isWhitespace()) {
                    for (int i = 0; i < this.mNumberOfProjections; ++i) {
                        if (currentNodeDepth < 0 || !this.mActiveTextDepthMask[i].get(currentNodeDepth)) continue;
                        int n = i + 1;
                        this.mCurrentValues[n] = this.mCurrentValues[n] + parser.getText();
                    }
                }
                eventType = parser.next();
            }
        }
    }
}

