/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.DatabaseUtils;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixCursor
extends AbstractCursor {
    public final String[] columnNames;
    public Object[] data;
    public int rowCount = 0;
    public final int columnCount;

    public MatrixCursor(String[] columnNames, int initialCapacity) {
        this.columnNames = columnNames;
        this.columnCount = columnNames.length;
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        this.data = new Object[this.columnCount * initialCapacity];
    }

    public MatrixCursor(String[] columnNames) {
        this(columnNames, 16);
    }

    public Object get(int column) {
        if (column < 0 || column >= this.columnCount) {
            throw new CursorIndexOutOfBoundsException("Requested column: " + column + ", # of columns: " + this.columnCount);
        }
        if (this.mPos < 0) {
            throw new CursorIndexOutOfBoundsException("Before first row.");
        }
        if (this.mPos >= this.rowCount) {
            throw new CursorIndexOutOfBoundsException("After last row.");
        }
        return this.data[this.mPos * this.columnCount + column];
    }

    public RowBuilder newRow() {
        ++this.rowCount;
        int endIndex = this.rowCount * this.columnCount;
        this.ensureCapacity(endIndex);
        int start = endIndex - this.columnCount;
        return new RowBuilder(start, endIndex);
    }

    public void addRow(Object[] columnValues) {
        if (columnValues.length != this.columnCount) {
            throw new IllegalArgumentException("columnNames.length = " + this.columnCount + ", columnValues.length = " + columnValues.length);
        }
        int start = this.rowCount++ * this.columnCount;
        this.ensureCapacity(start + this.columnCount);
        System.arraycopy(columnValues, 0, this.data, start, this.columnCount);
    }

    public void addRow(Iterable<?> columnValues) {
        int start = this.rowCount * this.columnCount;
        int end = start + this.columnCount;
        this.ensureCapacity(end);
        if (columnValues instanceof ArrayList) {
            this.addRow((ArrayList)columnValues, start);
            return;
        }
        int current = start;
        Object[] localData = this.data;
        for (Object columnValue : columnValues) {
            if (current == end) {
                throw new IllegalArgumentException("columnValues.size() > columnNames.length");
            }
            localData[current++] = columnValue;
        }
        if (current != end) {
            throw new IllegalArgumentException("columnValues.size() < columnNames.length");
        }
        ++this.rowCount;
    }

    public void addRow(ArrayList<?> columnValues, int start) {
        int size = columnValues.size();
        if (size != this.columnCount) {
            throw new IllegalArgumentException("columnNames.length = " + this.columnCount + ", columnValues.size() = " + size);
        }
        ++this.rowCount;
        Object[] localData = this.data;
        for (int i = 0; i < size; ++i) {
            localData[start + i] = columnValues.get(i);
        }
    }

    public void ensureCapacity(int size) {
        if (size > this.data.length) {
            Object[] oldData = this.data;
            int newSize = this.data.length * 2;
            if (newSize < size) {
                newSize = size;
            }
            this.data = new Object[newSize];
            System.arraycopy(oldData, 0, this.data, 0, oldData.length);
        }
    }

    @Override
    public int getCount() {
        return this.rowCount;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String getString(int column) {
        Object value = this.get(column);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public short getShort(int column) {
        Object value = this.get(column);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return Short.parseShort(value.toString());
    }

    @Override
    public int getInt(int column) {
        Object value = this.get(column);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    @Override
    public long getLong(int column) {
        Object value = this.get(column);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    @Override
    public float getFloat(int column) {
        Object value = this.get(column);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return Float.parseFloat(value.toString());
    }

    @Override
    public double getDouble(int column) {
        Object value = this.get(column);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    @Override
    public int getType(int column) {
        return DatabaseUtils.getTypeOfObject(this.get(column));
    }

    @Override
    public boolean isNull(int column) {
        return this.get(column) == null;
    }

    public class RowBuilder {
        public int index;
        public final int endIndex;

        public RowBuilder(int index, int endIndex) {
            this.index = index;
            this.endIndex = endIndex;
        }

        public RowBuilder add(Object columnValue) {
            if (this.index == this.endIndex) {
                throw new CursorIndexOutOfBoundsException("No more columns left.");
            }
            ((MatrixCursor)MatrixCursor.this).data[this.index++] = columnValue;
            return this;
        }
    }
}

