/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.AbstractWindowedCursor;
import android.database.CursorWindow;
import android.database.DataSetObserver;
import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteQuery;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.os.StrictMode;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class SQLiteCursor
extends AbstractWindowedCursor {
    public static final String TAG = "SQLiteCursor";
    public static final int NO_COUNT = -1;
    public final String mEditTable;
    public final String[] mColumns;
    public SQLiteQuery mQuery;
    public final SQLiteCursorDriver mDriver;
    public volatile int mCount = -1;
    public Map<String, Integer> mColumnNameMap;
    public final Throwable mStackTrace;
    public int mMaxRead = Integer.MAX_VALUE;
    public int mInitialRead = Integer.MAX_VALUE;
    public int mCursorState = 0;
    public ReentrantLock mLock = null;
    public boolean mPendingData = false;
    public MainThreadNotificationHandler mNotificationHandler;

    public void setLoadStyle(int initialRead, int maxRead) {
        this.mMaxRead = maxRead;
        this.mInitialRead = initialRead;
        this.mLock = new ReentrantLock(true);
    }

    public void queryThreadLock() {
        if (this.mLock != null) {
            this.mLock.lock();
        }
    }

    public void queryThreadUnlock() {
        if (this.mLock != null) {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataSetObserver(DataSetObserver observer) {
        super.registerDataSetObserver(observer);
        if ((Integer.MAX_VALUE != this.mMaxRead || Integer.MAX_VALUE != this.mInitialRead) && this.mNotificationHandler == null) {
            this.queryThreadLock();
            try {
                this.mNotificationHandler = new MainThreadNotificationHandler();
                if (this.mPendingData) {
                    this.notifyDataSetChange();
                    this.mPendingData = false;
                }
                Object var3_2 = null;
                this.queryThreadUnlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.queryThreadUnlock();
                throw throwable;
            }
        }
    }

    @Deprecated
    public SQLiteCursor(SQLiteDatabase db, SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        this(driver, editTable, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteCursor(SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query object cannot be null");
        }
        if (query.mDatabase == null) {
            throw new IllegalArgumentException("query.mDatabase cannot be null");
        }
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.mDriver = driver;
        this.mEditTable = editTable;
        this.mColumnNameMap = null;
        this.mQuery = query;
        query.mDatabase.lock();
        try {
            int columnCount = this.mQuery.columnCountLocked();
            this.mColumns = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                String columnName;
                this.mColumns[i] = columnName = this.mQuery.columnNameLocked(i);
                if (!"_id".equals(columnName)) continue;
                this.mRowIdColumnIndex = i;
            }
            Object var8_7 = null;
            query.mDatabase.unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            query.mDatabase.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDatabase getDatabase() {
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            return this.mQuery.mDatabase;
        }
    }

    public boolean onMove(int oldPosition, int newPosition) {
        if (this.mWindow == null || newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
            this.fillWindow(newPosition);
        }
        return true;
    }

    public int getCount() {
        if (this.mCount == -1) {
            this.fillWindow(0);
        }
        return this.mCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillWindow(int startPos) {
        if (this.mWindow == null) {
            this.mWindow = new CursorWindow(true);
        } else {
            ++this.mCursorState;
            this.queryThreadLock();
            try {
                this.mWindow.clear();
                Object var3_2 = null;
                this.queryThreadUnlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.queryThreadUnlock();
                throw throwable;
            }
        }
        this.mWindow.setStartPosition(startPos);
        int count = this.getQuery().fillWindow(this.mWindow, this.mInitialRead, 0);
        if (count == -1) {
            this.mCount = startPos + this.mInitialRead;
            if (Log.isLoggable(TAG, 3)) {
                Log.d(TAG, "received -1 from native_fill_window. read " + this.mCount + " rows so far");
            }
            Thread t = new Thread((Runnable)new QueryThread(this.mCursorState), "query thread");
            t.start();
        } else if (startPos == 0) {
            if (Log.isLoggable(TAG, 3)) {
                Log.d(TAG, "received count(*) from native_fill_window: " + count);
            }
            this.mCount = count;
        } else if (this.mCount <= 0) {
            throw new IllegalStateException("count should never be non-zero negative number");
        }
    }

    public synchronized SQLiteQuery getQuery() {
        return this.mQuery;
    }

    public int getColumnIndex(String columnName) {
        Integer i;
        int periodIndex;
        if (this.mColumnNameMap == null) {
            String[] columns = this.mColumns;
            int columnCount = columns.length;
            HashMap<String, Integer> map = new HashMap<String, Integer>(columnCount, 1.0f);
            for (int i2 = 0; i2 < columnCount; ++i2) {
                map.put(columns[i2], i2);
            }
            this.mColumnNameMap = map;
        }
        if ((periodIndex = columnName.lastIndexOf(46)) != -1) {
            Exception e = new Exception();
            Log.e(TAG, "requesting column name with table name -- " + columnName, e);
            columnName = columnName.substring(periodIndex + 1);
        }
        if ((i = this.mColumnNameMap.get(columnName)) != null) {
            return i;
        }
        return -1;
    }

    public String[] getColumnNames() {
        return this.mColumns;
    }

    public void deactivateCommon() {
        this.mCursorState = 0;
        if (this.mWindow != null) {
            this.mWindow.close();
            this.mWindow = null;
        }
    }

    public void deactivate() {
        super.deactivate();
        this.deactivateCommon();
        this.mDriver.cursorDeactivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            this.deactivateCommon();
            this.mQuery.close();
            this.mDriver.cursorClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean requery() {
        if (this.isClosed()) {
            return false;
        }
        long timeStart = 0L;
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            if (this.mWindow != null) {
                this.mWindow.clear();
            }
            this.mPos = -1;
            SQLiteDatabase db = null;
            try {
                db = this.mQuery.mDatabase.getDatabaseHandle(this.mQuery.mSql);
            }
            catch (IllegalStateException e) {
                Log.w(TAG, "requery() failed " + e.getMessage(), e);
                return false;
            }
            if (!db.equals(this.mQuery.mDatabase)) {
                try {
                    db.lock();
                }
                catch (IllegalStateException e) {
                    Log.w(TAG, "requery() failed " + e.getMessage(), e);
                    return false;
                }
                try {
                    try {
                        this.mQuery.close();
                        this.mQuery = new SQLiteQuery(db, this.mQuery);
                    }
                    catch (IllegalStateException e) {
                        Log.w(TAG, "requery() failed " + e.getMessage(), e);
                        boolean bl = false;
                        Object var8_11 = null;
                        db.unlock();
                        return bl;
                    }
                    Object var8_10 = null;
                    db.unlock();
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    db.unlock();
                    throw throwable;
                }
            }
            this.mDriver.cursorRequeried(this);
            this.mCount = -1;
            ++this.mCursorState;
            this.queryThreadLock();
            try {
                try {
                    this.mQuery.requery();
                }
                catch (IllegalStateException e) {
                    Log.w(TAG, "requery() failed " + e.getMessage(), e);
                    boolean bl = false;
                    Object var10_17 = null;
                    this.queryThreadUnlock();
                    return bl;
                }
                Object var10_16 = null;
                this.queryThreadUnlock();
            }
            catch (Throwable throwable) {
                Object var10_18 = null;
                this.queryThreadUnlock();
                throw throwable;
            }
        }
        boolean result = false;
        try {
            return super.requery();
        }
        catch (IllegalStateException e) {
            Log.w(TAG, "requery() failed " + e.getMessage(), e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindow(CursorWindow window) {
        if (this.mWindow != null) {
            ++this.mCursorState;
            this.queryThreadLock();
            try {
                this.mWindow.close();
                Object var3_2 = null;
                this.queryThreadUnlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.queryThreadUnlock();
                throw throwable;
            }
            this.mCount = -1;
        }
        this.mWindow = window;
    }

    public void setSelectionArguments(String[] selectionArgs) {
        this.mDriver.setBindArguments(selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        try {
            if (this.mWindow != null) {
                if (StrictMode.vmSqliteObjectLeaksEnabled()) {
                    int len = this.mQuery.mSql.length();
                    StrictMode.onSqliteObjectLeaked("Finalizing a Cursor that has not been deactivated or closed. database = " + this.mQuery.mDatabase.getPath() + ", table = " + this.mEditTable + ", query = " + this.mQuery.mSql.substring(0, len > 1000 ? 1000 : len), this.mStackTrace);
                }
                this.close();
                SQLiteDebug.notifyActiveCursorFinalized();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public int getMCount() {
        return this.mCount;
    }

    public class MainThreadNotificationHandler
    extends Handler {
        public void handleMessage(Message msg) {
            SQLiteCursor.this.notifyDataSetChange();
        }
    }

    public class QueryThread
    implements Runnable {
        public final int mThreadState;

        public QueryThread(int version) {
            this.mThreadState = version;
        }

        public void sendMessage() {
            if (SQLiteCursor.this.mNotificationHandler != null) {
                SQLiteCursor.this.mNotificationHandler.sendEmptyMessage(1);
                SQLiteCursor.this.mPendingData = false;
            } else {
                SQLiteCursor.this.mPendingData = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            CursorWindow cw = SQLiteCursor.this.mWindow;
            Process.setThreadPriority(Process.myTid(), 10);
            while (true) {
                Object var4_4;
                block10: {
                    block9: {
                        SQLiteCursor.this.mLock.lock();
                        try {
                            try {
                                if (SQLiteCursor.this.mCursorState != this.mThreadState) {
                                    var4_4 = null;
                                    SQLiteCursor.this.mLock.unlock();
                                    return;
                                }
                                int count = SQLiteCursor.this.getQuery().fillWindow(cw, SQLiteCursor.this.mMaxRead, SQLiteCursor.this.mCount);
                                if (count == 0) break block9;
                                if (count == -1) {
                                    SQLiteCursor.this.mCount += SQLiteCursor.this.mMaxRead;
                                    if (Log.isLoggable(SQLiteCursor.TAG, 3)) {
                                        Log.d(SQLiteCursor.TAG, "received -1 from native_fill_window. read " + SQLiteCursor.this.mCount + " rows so far");
                                    }
                                    this.sendMessage();
                                    break block10;
                                }
                                SQLiteCursor.this.mCount += count;
                                if (Log.isLoggable(SQLiteCursor.TAG, 3)) {
                                    Log.d(SQLiteCursor.TAG, "received all data from native_fill_window. read " + SQLiteCursor.this.mCount + " rows.");
                                }
                                this.sendMessage();
                            }
                            catch (Exception e) {
                                var4_4 = null;
                                SQLiteCursor.this.mLock.unlock();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            var4_4 = null;
                            SQLiteCursor.this.mLock.unlock();
                            throw throwable;
                        }
                        var4_4 = null;
                        SQLiteCursor.this.mLock.unlock();
                        return;
                    }
                    var4_4 = null;
                    SQLiteCursor.this.mLock.unlock();
                    return;
                }
                var4_4 = null;
                SQLiteCursor.this.mLock.unlock();
            }
        }
    }
}

