/*
 * Decompiled with CFR 0.152.
 */
package android.emoji;

import android.graphics.Bitmap;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;

public class EmojiFactory {
    public int sCacheSize = 100;
    public int mNativeEmojiFactory;
    public String mName;
    public Map<Integer, WeakReference<Bitmap>> mCache;

    public EmojiFactory(int nativeEmojiFactory, String name) {
        this.mNativeEmojiFactory = nativeEmojiFactory;
        this.mName = name;
        this.mCache = new CustomLinkedHashMap<Integer, WeakReference<Bitmap>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.nativeDestructor(this.mNativeEmojiFactory);
        }
        finally {
            super.finalize();
        }
    }

    public String name() {
        return this.mName;
    }

    public synchronized Bitmap getBitmapFromAndroidPua(int pua) {
        WeakReference<Bitmap> cache = this.mCache.get(pua);
        if (cache == null) {
            Bitmap ret = this.nativeGetBitmapFromAndroidPua(this.mNativeEmojiFactory, pua);
            if (ret != null) {
                this.mCache.put(pua, new WeakReference<Bitmap>(ret));
            }
            return ret;
        }
        Bitmap tmp = (Bitmap)cache.get();
        if (tmp == null) {
            Bitmap ret = this.nativeGetBitmapFromAndroidPua(this.mNativeEmojiFactory, pua);
            this.mCache.put(pua, new WeakReference<Bitmap>(ret));
            return ret;
        }
        return tmp;
    }

    public synchronized Bitmap getBitmapFromVendorSpecificSjis(char sjis) {
        return this.getBitmapFromAndroidPua(this.getAndroidPuaFromVendorSpecificSjis(sjis));
    }

    public synchronized Bitmap getBitmapFromVendorSpecificPua(int vsp) {
        return this.getBitmapFromAndroidPua(this.getAndroidPuaFromVendorSpecificPua(vsp));
    }

    public int getAndroidPuaFromVendorSpecificSjis(char sjis) {
        return this.nativeGetAndroidPuaFromVendorSpecificSjis(this.mNativeEmojiFactory, sjis);
    }

    public int getVendorSpecificSjisFromAndroidPua(int pua) {
        return this.nativeGetVendorSpecificSjisFromAndroidPua(this.mNativeEmojiFactory, pua);
    }

    public int getAndroidPuaFromVendorSpecificPua(int vsp) {
        return this.nativeGetAndroidPuaFromVendorSpecificPua(this.mNativeEmojiFactory, vsp);
    }

    public String getAndroidPuaFromVendorSpecificPua(String vspString) {
        if (vspString == null) {
            return null;
        }
        int minVsp = this.nativeGetMinimumVendorSpecificPua(this.mNativeEmojiFactory);
        int maxVsp = this.nativeGetMaximumVendorSpecificPua(this.mNativeEmojiFactory);
        int len = vspString.length();
        int[] codePoints = new int[vspString.codePointCount(0, len)];
        int new_len = 0;
        int i = 0;
        while (i < len) {
            int newCodePoint;
            int codePoint = vspString.codePointAt(i);
            codePoints[new_len] = minVsp <= codePoint && codePoint <= maxVsp && (newCodePoint = this.getAndroidPuaFromVendorSpecificPua(codePoint)) > 0 ? newCodePoint : codePoint;
            i = vspString.offsetByCodePoints(i, 1);
            ++new_len;
        }
        return new String(codePoints, 0, new_len);
    }

    public int getVendorSpecificPuaFromAndroidPua(int pua) {
        return this.nativeGetVendorSpecificPuaFromAndroidPua(this.mNativeEmojiFactory, pua);
    }

    public String getVendorSpecificPuaFromAndroidPua(String puaString) {
        if (puaString == null) {
            return null;
        }
        int minVsp = this.nativeGetMinimumAndroidPua(this.mNativeEmojiFactory);
        int maxVsp = this.nativeGetMaximumAndroidPua(this.mNativeEmojiFactory);
        int len = puaString.length();
        int[] codePoints = new int[puaString.codePointCount(0, len)];
        int new_len = 0;
        int i = 0;
        while (i < len) {
            int newCodePoint;
            int codePoint = puaString.codePointAt(i);
            codePoints[new_len] = minVsp <= codePoint && codePoint <= maxVsp && (newCodePoint = this.getVendorSpecificPuaFromAndroidPua(codePoint)) > 0 ? newCodePoint : codePoint;
            i = puaString.offsetByCodePoints(i, 1);
            ++new_len;
        }
        return new String(codePoints, 0, new_len);
    }

    public static EmojiFactory newInstance(String string2) {
        return (EmojiFactory)OverrideMethod.invokeA("android.emoji.EmojiFactory#newInstance(Ljava/lang/String;)Landroid/emoji/EmojiFactory;", true, null);
    }

    public static EmojiFactory newAvailableInstance() {
        return (EmojiFactory)OverrideMethod.invokeA("android.emoji.EmojiFactory#newAvailableInstance()Landroid/emoji/EmojiFactory;", true, null);
    }

    public int getMinimumAndroidPua() {
        return this.nativeGetMinimumAndroidPua(this.mNativeEmojiFactory);
    }

    public int getMaximumAndroidPua() {
        return this.nativeGetMaximumAndroidPua(this.mNativeEmojiFactory);
    }

    public void nativeDestructor(int n) {
        OverrideMethod.invokeV("android.emoji.EmojiFactory#nativeDestructor(I)V", true, this);
    }

    public Bitmap nativeGetBitmapFromAndroidPua(int n, int n2) {
        return (Bitmap)OverrideMethod.invokeA("android.emoji.EmojiFactory#nativeGetBitmapFromAndroidPua(II)Landroid/graphics/Bitmap;", true, this);
    }

    public int nativeGetAndroidPuaFromVendorSpecificSjis(int n, char c) {
        return OverrideMethod.invokeI("android.emoji.EmojiFactory#nativeGetAndroidPuaFromVendorSpecificSjis(IC)I", true, this);
    }

    public int nativeGetVendorSpecificSjisFromAndroidPua(int n, int n2) {
        return OverrideMethod.invokeI("android.emoji.EmojiFactory#nativeGetVendorSpecificSjisFromAndroidPua(II)I", true, this);
    }

    public int nativeGetAndroidPuaFromVendorSpecificPua(int n, int n2) {
        return OverrideMethod.invokeI("android.emoji.EmojiFactory#nativeGetAndroidPuaFromVendorSpecificPua(II)I", true, this);
    }

    public int nativeGetVendorSpecificPuaFromAndroidPua(int n, int n2) {
        return OverrideMethod.invokeI("android.emoji.EmojiFactory#nativeGetVendorSpecificPuaFromAndroidPua(II)I", true, this);
    }

    public int nativeGetMaximumVendorSpecificPua(int n) {
        return OverrideMethod.invokeI("android.emoji.EmojiFactory#nativeGetMaximumVendorSpecificPua(I)I", true, this);
    }

    public int nativeGetMinimumVendorSpecificPua(int n) {
        return OverrideMethod.invokeI("android.emoji.EmojiFactory#nativeGetMinimumVendorSpecificPua(I)I", true, this);
    }

    public int nativeGetMaximumAndroidPua(int n) {
        return OverrideMethod.invokeI("android.emoji.EmojiFactory#nativeGetMaximumAndroidPua(I)I", true, this);
    }

    public int nativeGetMinimumAndroidPua(int n) {
        return OverrideMethod.invokeI("android.emoji.EmojiFactory#nativeGetMinimumAndroidPua(I)I", true, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CustomLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        public CustomLinkedHashMap() {
            super(16, 0.75f, true);
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > EmojiFactory.this.sCacheSize;
        }
    }
}

