/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorDrawable
extends Drawable {
    public ColorState mState;
    public final Paint mPaint = new Paint();

    public ColorDrawable() {
        this(null);
    }

    public ColorDrawable(int color2) {
        this(null);
        this.setColor(color2);
    }

    public ColorDrawable(ColorState state) {
        this.mState = new ColorState(state);
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.mChangingConfigurations;
    }

    public void draw(Canvas canvas) {
        if (this.mState.mUseColor >>> 24 != 0) {
            this.mPaint.setColor(this.mState.mUseColor);
            canvas.drawRect(this.getBounds(), this.mPaint);
        }
    }

    public int getColor() {
        return this.mState.mUseColor;
    }

    public void setColor(int color2) {
        if (this.mState.mBaseColor != color2 || this.mState.mUseColor != color2) {
            this.invalidateSelf();
            this.mState.mBaseColor = this.mState.mUseColor = color2;
        }
    }

    public int getAlpha() {
        return this.mState.mUseColor >>> 24;
    }

    public void setAlpha(int alpha) {
        alpha += alpha >> 7;
        int baseAlpha = this.mState.mBaseColor >>> 24;
        int useAlpha = baseAlpha * alpha >> 8;
        this.mState.mUseColor = this.mState.mBaseColor << 8 >>> 8 | useAlpha << 24;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        switch (this.mState.mUseColor >>> 24) {
            case 255: {
                return -1;
            }
            case 0: {
                return -2;
            }
        }
        return -3;
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs);
        TypedArray a = r.obtainAttributes(attrs, R.styleable.ColorDrawable);
        int color2 = this.mState.mBaseColor;
        this.mState.mBaseColor = this.mState.mUseColor = (color2 = a.getColor(0, color2));
        a.recycle();
    }

    public Drawable.ConstantState getConstantState() {
        this.mState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mState;
    }

    public /* synthetic */ ColorDrawable(ColorState x0, 1 x1) {
        this(x0);
    }

    public static class 1 {
    }

    public static class ColorState
    extends Drawable.ConstantState {
        public int mBaseColor;
        public int mUseColor;
        public int mChangingConfigurations;

        public ColorState(ColorState state) {
            if (state != null) {
                this.mBaseColor = state.mBaseColor;
                this.mUseColor = state.mUseColor;
            }
        }

        public Drawable newDrawable() {
            return new ColorDrawable(this, null);
        }

        public Drawable newDrawable(Resources res) {
            return new ColorDrawable(this, null);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

