/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.os.ParcelFileDescriptor;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;

public class UsbDeviceConnection {
    public static final String TAG = "UsbDeviceConnection";
    public final UsbDevice mDevice;
    public int mNativeContext;

    public UsbDeviceConnection(UsbDevice device) {
        this.mDevice = device;
    }

    public boolean open(String name, ParcelFileDescriptor pfd) {
        return this.native_open(name, pfd.getFileDescriptor());
    }

    public void close() {
        this.native_close();
    }

    public int getFileDescriptor() {
        return this.native_get_fd();
    }

    public byte[] getRawDescriptors() {
        return this.native_get_desc();
    }

    public boolean claimInterface(UsbInterface intf, boolean force) {
        return this.native_claim_interface(intf.getId(), force);
    }

    public boolean releaseInterface(UsbInterface intf) {
        return this.native_release_interface(intf.getId());
    }

    public int controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int length, int timeout) {
        return this.native_control_request(requestType, request, value, index, buffer, length, timeout);
    }

    public int bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int length, int timeout) {
        return this.native_bulk_request(endpoint.getAddress(), buffer, length, timeout);
    }

    public UsbRequest requestWait() {
        UsbRequest request = this.native_request_wait();
        if (request != null) {
            request.dequeue();
        }
        return request;
    }

    public String getSerial() {
        return this.native_get_serial();
    }

    public boolean native_open(String string2, FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_open(Ljava/lang/String;Ljava/io/FileDescriptor;)Z", true, this) != 0;
    }

    public void native_close() {
        OverrideMethod.invokeV("android.hardware.usb.UsbDeviceConnection#native_close()V", true, this);
    }

    public int native_get_fd() {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_get_fd()I", true, this);
    }

    public byte[] native_get_desc() {
        return (byte[])OverrideMethod.invokeA("android.hardware.usb.UsbDeviceConnection#native_get_desc()[B", true, this);
    }

    public boolean native_claim_interface(int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_claim_interface(IZ)Z", true, this) != 0;
    }

    public boolean native_release_interface(int n) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_release_interface(I)Z", true, this) != 0;
    }

    public int native_control_request(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_control_request(IIII[BII)I", true, this);
    }

    public int native_bulk_request(int n, byte[] byArray, int n2, int n3) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbDeviceConnection#native_bulk_request(I[BII)I", true, this);
    }

    public UsbRequest native_request_wait() {
        return (UsbRequest)OverrideMethod.invokeA("android.hardware.usb.UsbDeviceConnection#native_request_wait()Landroid/hardware/usb/UsbRequest;", true, this);
    }

    public String native_get_serial() {
        return (String)OverrideMethod.invokeA("android.hardware.usb.UsbDeviceConnection#native_get_serial()Ljava/lang/String;", true, this);
    }
}

