/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.nio.ByteBuffer;

public class UsbRequest {
    public static final String TAG = "UsbRequest";
    public int mNativeContext;
    public UsbEndpoint mEndpoint;
    public ByteBuffer mBuffer;
    public int mLength;
    public Object mClientData;

    public boolean initialize(UsbDeviceConnection connection, UsbEndpoint endpoint) {
        this.mEndpoint = endpoint;
        return this.native_init(connection, endpoint.getAddress(), endpoint.getAttributes(), endpoint.getMaxPacketSize(), endpoint.getInterval());
    }

    public void close() {
        this.mEndpoint = null;
        this.native_close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.mEndpoint != null) {
                Log.v(TAG, "endpoint still open in finalize(): " + this);
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public UsbEndpoint getEndpoint() {
        return this.mEndpoint;
    }

    public Object getClientData() {
        return this.mClientData;
    }

    public void setClientData(Object data) {
        this.mClientData = data;
    }

    public boolean queue(ByteBuffer buffer, int length) {
        boolean result;
        boolean out;
        boolean bl = out = this.mEndpoint.getDirection() == 0;
        if (buffer.isDirect()) {
            result = this.native_queue_direct(buffer, length, out);
        } else if (buffer.hasArray()) {
            result = this.native_queue_array(buffer.array(), length, out);
        } else {
            throw new IllegalArgumentException("buffer is not direct and has no array");
        }
        if (result) {
            this.mBuffer = buffer;
            this.mLength = length;
        }
        return result;
    }

    public void dequeue() {
        boolean out;
        boolean bl = out = this.mEndpoint.getDirection() == 0;
        if (this.mBuffer.isDirect()) {
            this.native_dequeue_direct();
        } else {
            this.native_dequeue_array(this.mBuffer.array(), this.mLength, out);
        }
        this.mBuffer = null;
        this.mLength = 0;
    }

    public boolean cancel() {
        return this.native_cancel();
    }

    public boolean native_init(UsbDeviceConnection usbDeviceConnection, int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_init(Landroid/hardware/usb/UsbDeviceConnection;IIII)Z", true, this) != 0;
    }

    public void native_close() {
        OverrideMethod.invokeV("android.hardware.usb.UsbRequest#native_close()V", true, this);
    }

    public boolean native_queue_array(byte[] byArray, int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_queue_array([BIZ)Z", true, this) != 0;
    }

    public void native_dequeue_array(byte[] byArray, int n, boolean bl) {
        OverrideMethod.invokeV("android.hardware.usb.UsbRequest#native_dequeue_array([BIZ)V", true, this);
    }

    public boolean native_queue_direct(ByteBuffer byteBuffer, int n, boolean bl) {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_queue_direct(Ljava/nio/ByteBuffer;IZ)Z", true, this) != 0;
    }

    public void native_dequeue_direct() {
        OverrideMethod.invokeV("android.hardware.usb.UsbRequest#native_dequeue_direct()V", true, this);
    }

    public boolean native_cancel() {
        return OverrideMethod.invokeI("android.hardware.usb.UsbRequest#native_cancel()Z", true, this) != 0;
    }
}

