/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.Country;
import android.location.CountryListener;
import android.location.ICountryDetector;
import android.location.ICountryListener;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;

public class CountryDetector {
    public static final String TAG = "CountryDetector";
    public final ICountryDetector mService;
    public final HashMap<CountryListener, ListenerTransport> mListeners;

    public CountryDetector(ICountryDetector service) {
        this.mService = service;
        this.mListeners = new HashMap();
    }

    public Country detectCountry() {
        try {
            return this.mService.detectCountry();
        }
        catch (RemoteException e) {
            Log.e(TAG, "detectCountry: RemoteException", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCountryListener(CountryListener listener, Looper looper) {
        HashMap<CountryListener, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            if (!this.mListeners.containsKey(listener)) {
                ListenerTransport transport = new ListenerTransport(listener, looper);
                try {
                    this.mService.addCountryListener(transport);
                    this.mListeners.put(listener, transport);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "addCountryListener: RemoteException", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCountryListener(CountryListener listener) {
        HashMap<CountryListener, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            ListenerTransport transport = this.mListeners.get(listener);
            if (transport != null) {
                try {
                    this.mListeners.remove(listener);
                    this.mService.removeCountryListener(transport);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "removeCountryListener: RemoteException", e);
                }
            }
        }
    }

    public static class ListenerTransport
    extends ICountryListener.Stub {
        public final CountryListener mListener;
        public final Handler mHandler;

        public ListenerTransport(CountryListener listener, Looper looper) {
            this.mListener = listener;
            this.mHandler = looper != null ? new Handler(looper) : new Handler();
        }

        public void onCountryDetected(final Country country) {
            this.mHandler.post(new Runnable(){

                public void run() {
                    ListenerTransport.this.mListener.onCountryDetected(country);
                }
            });
        }
    }
}

