/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.net.InetSocketAddress;
import java.net.Proxy;

public class ProxyProperties
implements Parcelable {
    public String mHost;
    public int mPort;
    public String mExclusionList;
    public String[] mParsedExclusionList;
    public static final Parcelable.Creator<ProxyProperties> CREATOR = new Parcelable.Creator<ProxyProperties>(){

        @Override
        public ProxyProperties createFromParcel(Parcel in) {
            String host = null;
            int port = 0;
            if (in.readByte() == 1) {
                host = in.readString();
                port = in.readInt();
            }
            String exclList = in.readString();
            String[] parsedExclList = in.readStringArray();
            ProxyProperties proxyProperties = new ProxyProperties(host, port, exclList, parsedExclList, null);
            return proxyProperties;
        }

        public ProxyProperties[] newArray(int size) {
            return new ProxyProperties[size];
        }
    };

    public ProxyProperties(String host, int port, String exclList) {
        this.mHost = host;
        this.mPort = port;
        this.setExclusionList(exclList);
    }

    public ProxyProperties(String host, int port, String exclList, String[] parsedExclList) {
        this.mHost = host;
        this.mPort = port;
        this.mExclusionList = exclList;
        this.mParsedExclusionList = parsedExclList;
    }

    public ProxyProperties(ProxyProperties source) {
        if (source != null) {
            this.mHost = source.getHost();
            this.mPort = source.getPort();
            this.mExclusionList = source.getExclusionList();
            this.mParsedExclusionList = source.mParsedExclusionList;
        }
    }

    public InetSocketAddress getSocketAddress() {
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = new InetSocketAddress(this.mHost, this.mPort);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return inetSocketAddress;
    }

    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getExclusionList() {
        return this.mExclusionList;
    }

    public void setExclusionList(String exclusionList) {
        this.mExclusionList = exclusionList;
        if (this.mExclusionList == null) {
            this.mParsedExclusionList = new String[0];
        } else {
            String[] splitExclusionList = exclusionList.toLowerCase().split(",");
            this.mParsedExclusionList = new String[splitExclusionList.length * 2];
            for (int i = 0; i < splitExclusionList.length; ++i) {
                String s = splitExclusionList[i].trim();
                if (s.startsWith(".")) {
                    s = s.substring(1);
                }
                this.mParsedExclusionList[i * 2] = s;
                this.mParsedExclusionList[i * 2 + 1] = "." + s;
            }
        }
    }

    public boolean isExcluded(String url) {
        if (TextUtils.isEmpty(url) || this.mParsedExclusionList == null || this.mParsedExclusionList.length == 0) {
            return false;
        }
        Uri u = Uri.parse(url);
        String urlDomain = u.getHost();
        if (urlDomain == null) {
            return false;
        }
        for (int i = 0; i < this.mParsedExclusionList.length; i += 2) {
            if (!urlDomain.equals(this.mParsedExclusionList[i]) && !urlDomain.endsWith(this.mParsedExclusionList[i + 1])) continue;
            return true;
        }
        return false;
    }

    public Proxy makeProxy() {
        Proxy proxy = Proxy.NO_PROXY;
        if (this.mHost != null) {
            try {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.mHost, this.mPort);
                proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return proxy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mHost != null) {
            sb.append("[");
            sb.append(this.mHost);
            sb.append("] ");
            sb.append(Integer.toString(this.mPort));
            if (this.mExclusionList != null) {
                sb.append(" xl=").append(this.mExclusionList);
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProxyProperties)) {
            return false;
        }
        ProxyProperties p = (ProxyProperties)o;
        if (this.mExclusionList != null && !this.mExclusionList.equals(p.getExclusionList())) {
            return false;
        }
        if (this.mHost != null && p.getHost() != null && !this.mHost.equals(p.getHost())) {
            return false;
        }
        if (this.mHost != null && p.mHost == null) {
            return false;
        }
        if (this.mHost == null && p.mHost != null) {
            return false;
        }
        return this.mPort == p.mPort;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.mHost != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mHost);
            dest.writeInt(this.mPort);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeString(this.mExclusionList);
        dest.writeStringArray(this.mParsedExclusionList);
    }

    public /* synthetic */ ProxyProperties(String x0, int x1, String x2, String[] x3, 1 x4) {
        this(x0, x1, x2, x3);
    }
}

