/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.CharArrayBuffers;
import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Headers {
    public static final String LOGTAG = "Http";
    public static final int CONN_CLOSE = 1;
    public static final int CONN_KEEP_ALIVE = 2;
    public static final int NO_CONN_TYPE = 0;
    public static final long NO_TRANSFER_ENCODING = 0L;
    public static final long NO_CONTENT_LENGTH = -1L;
    public static final String TRANSFER_ENCODING = "transfer-encoding";
    public static final String CONTENT_LEN = "content-length";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_ENCODING = "content-encoding";
    public static final String CONN_DIRECTIVE = "connection";
    public static final String LOCATION = "location";
    public static final String PROXY_CONNECTION = "proxy-connection";
    public static final String WWW_AUTHENTICATE = "www-authenticate";
    public static final String PROXY_AUTHENTICATE = "proxy-authenticate";
    public static final String CONTENT_DISPOSITION = "content-disposition";
    public static final String ACCEPT_RANGES = "accept-ranges";
    public static final String EXPIRES = "expires";
    public static final String CACHE_CONTROL = "cache-control";
    public static final String LAST_MODIFIED = "last-modified";
    public static final String ETAG = "etag";
    public static final String SET_COOKIE = "set-cookie";
    public static final String PRAGMA = "pragma";
    public static final String REFRESH = "refresh";
    public static final String X_PERMITTED_CROSS_DOMAIN_POLICIES = "x-permitted-cross-domain-policies";
    public static final int HASH_TRANSFER_ENCODING = 1274458357;
    public static final int HASH_CONTENT_LEN = -1132779846;
    public static final int HASH_CONTENT_TYPE = 785670158;
    public static final int HASH_CONTENT_ENCODING = 2095084583;
    public static final int HASH_CONN_DIRECTIVE = -775651618;
    public static final int HASH_LOCATION = 1901043637;
    public static final int HASH_PROXY_CONNECTION = 285929373;
    public static final int HASH_WWW_AUTHENTICATE = -243037365;
    public static final int HASH_PROXY_AUTHENTICATE = -301767724;
    public static final int HASH_CONTENT_DISPOSITION = -1267267485;
    public static final int HASH_ACCEPT_RANGES = 1397189435;
    public static final int HASH_EXPIRES = -1309235404;
    public static final int HASH_CACHE_CONTROL = -208775662;
    public static final int HASH_LAST_MODIFIED = 150043680;
    public static final int HASH_ETAG = 3123477;
    public static final int HASH_SET_COOKIE = 1237214767;
    public static final int HASH_PRAGMA = -980228804;
    public static final int HASH_REFRESH = 1085444827;
    public static final int HASH_X_PERMITTED_CROSS_DOMAIN_POLICIES = -1345594014;
    public static final int IDX_TRANSFER_ENCODING = 0;
    public static final int IDX_CONTENT_LEN = 1;
    public static final int IDX_CONTENT_TYPE = 2;
    public static final int IDX_CONTENT_ENCODING = 3;
    public static final int IDX_CONN_DIRECTIVE = 4;
    public static final int IDX_LOCATION = 5;
    public static final int IDX_PROXY_CONNECTION = 6;
    public static final int IDX_WWW_AUTHENTICATE = 7;
    public static final int IDX_PROXY_AUTHENTICATE = 8;
    public static final int IDX_CONTENT_DISPOSITION = 9;
    public static final int IDX_ACCEPT_RANGES = 10;
    public static final int IDX_EXPIRES = 11;
    public static final int IDX_CACHE_CONTROL = 12;
    public static final int IDX_LAST_MODIFIED = 13;
    public static final int IDX_ETAG = 14;
    public static final int IDX_SET_COOKIE = 15;
    public static final int IDX_PRAGMA = 16;
    public static final int IDX_REFRESH = 17;
    public static final int IDX_X_PERMITTED_CROSS_DOMAIN_POLICIES = 18;
    public static final int HEADER_COUNT = 19;
    public long transferEncoding = 0L;
    public long contentLength = -1L;
    public int connectionType = 0;
    public ArrayList<String> cookies = new ArrayList(2);
    public String[] mHeaders = new String[19];
    public static final String[] sHeaderNames = new String[]{"transfer-encoding", "content-length", "content-type", "content-encoding", "connection", "location", "proxy-connection", "www-authenticate", "proxy-authenticate", "content-disposition", "accept-ranges", "expires", "cache-control", "last-modified", "etag", "set-cookie", "pragma", "refresh", "x-permitted-cross-domain-policies"};
    public ArrayList<String> mExtraHeaderNames = new ArrayList(4);
    public ArrayList<String> mExtraHeaderValues = new ArrayList(4);

    public void parseHeader(CharArrayBuffer buffer) {
        int pos = CharArrayBuffers.setLowercaseIndexOf(buffer, 58);
        if (pos == -1) {
            return;
        }
        String name = buffer.substringTrimmed(0, pos);
        if (name.length() == 0) {
            return;
        }
        String val = buffer.substringTrimmed(++pos, buffer.length());
        switch (name.hashCode()) {
            case 1274458357: {
                if (!name.equals(TRANSFER_ENCODING)) break;
                this.mHeaders[0] = val;
                HeaderElement[] encodings = BasicHeaderValueParser.DEFAULT.parseElements(buffer, new ParserCursor(pos, buffer.length()));
                int len = encodings.length;
                if ("identity".equalsIgnoreCase(val)) {
                    this.transferEncoding = -1L;
                    break;
                }
                if (len > 0 && "chunked".equalsIgnoreCase(encodings[len - 1].getName())) {
                    this.transferEncoding = -2L;
                    break;
                }
                this.transferEncoding = -1L;
                break;
            }
            case -1132779846: {
                if (!name.equals(CONTENT_LEN)) break;
                this.mHeaders[1] = val;
                try {
                    this.contentLength = Long.parseLong(val);
                }
                catch (NumberFormatException e) {}
                break;
            }
            case 785670158: {
                if (!name.equals(CONTENT_TYPE)) break;
                this.mHeaders[2] = val;
                break;
            }
            case 2095084583: {
                if (!name.equals(CONTENT_ENCODING)) break;
                this.mHeaders[3] = val;
                break;
            }
            case -775651618: {
                if (!name.equals(CONN_DIRECTIVE)) break;
                this.mHeaders[4] = val;
                this.setConnectionType(buffer, pos);
                break;
            }
            case 1901043637: {
                if (!name.equals(LOCATION)) break;
                this.mHeaders[5] = val;
                break;
            }
            case 285929373: {
                if (!name.equals(PROXY_CONNECTION)) break;
                this.mHeaders[6] = val;
                this.setConnectionType(buffer, pos);
                break;
            }
            case -243037365: {
                if (!name.equals(WWW_AUTHENTICATE)) break;
                this.mHeaders[7] = val;
                break;
            }
            case -301767724: {
                if (!name.equals(PROXY_AUTHENTICATE)) break;
                this.mHeaders[8] = val;
                break;
            }
            case -1267267485: {
                if (!name.equals(CONTENT_DISPOSITION)) break;
                this.mHeaders[9] = val;
                break;
            }
            case 1397189435: {
                if (!name.equals(ACCEPT_RANGES)) break;
                this.mHeaders[10] = val;
                break;
            }
            case -1309235404: {
                if (!name.equals(EXPIRES)) break;
                this.mHeaders[11] = val;
                break;
            }
            case -208775662: {
                if (!name.equals(CACHE_CONTROL)) break;
                if (this.mHeaders[12] != null && this.mHeaders[12].length() > 0) {
                    this.mHeaders[12] = this.mHeaders[12] + ',' + val;
                    break;
                }
                this.mHeaders[12] = val;
                break;
            }
            case 150043680: {
                if (!name.equals(LAST_MODIFIED)) break;
                this.mHeaders[13] = val;
                break;
            }
            case 3123477: {
                if (!name.equals(ETAG)) break;
                this.mHeaders[14] = val;
                break;
            }
            case 1237214767: {
                if (!name.equals(SET_COOKIE)) break;
                this.mHeaders[15] = val;
                this.cookies.add(val);
                break;
            }
            case -980228804: {
                if (!name.equals(PRAGMA)) break;
                this.mHeaders[16] = val;
                break;
            }
            case 1085444827: {
                if (!name.equals(REFRESH)) break;
                this.mHeaders[17] = val;
                break;
            }
            case -1345594014: {
                if (!name.equals(X_PERMITTED_CROSS_DOMAIN_POLICIES)) break;
                this.mHeaders[18] = val;
                break;
            }
            default: {
                this.mExtraHeaderNames.add(name);
                this.mExtraHeaderValues.add(val);
            }
        }
    }

    public long getTransferEncoding() {
        return this.transferEncoding;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public String getContentType() {
        return this.mHeaders[2];
    }

    public String getContentEncoding() {
        return this.mHeaders[3];
    }

    public String getLocation() {
        return this.mHeaders[5];
    }

    public String getWwwAuthenticate() {
        return this.mHeaders[7];
    }

    public String getProxyAuthenticate() {
        return this.mHeaders[8];
    }

    public String getContentDisposition() {
        return this.mHeaders[9];
    }

    public String getAcceptRanges() {
        return this.mHeaders[10];
    }

    public String getExpires() {
        return this.mHeaders[11];
    }

    public String getCacheControl() {
        return this.mHeaders[12];
    }

    public String getLastModified() {
        return this.mHeaders[13];
    }

    public String getEtag() {
        return this.mHeaders[14];
    }

    public ArrayList<String> getSetCookie() {
        return this.cookies;
    }

    public String getPragma() {
        return this.mHeaders[16];
    }

    public String getRefresh() {
        return this.mHeaders[17];
    }

    public String getXPermittedCrossDomainPolicies() {
        return this.mHeaders[18];
    }

    public void setContentLength(long value) {
        this.contentLength = value;
    }

    public void setContentType(String value) {
        this.mHeaders[2] = value;
    }

    public void setContentEncoding(String value) {
        this.mHeaders[3] = value;
    }

    public void setLocation(String value) {
        this.mHeaders[5] = value;
    }

    public void setWwwAuthenticate(String value) {
        this.mHeaders[7] = value;
    }

    public void setProxyAuthenticate(String value) {
        this.mHeaders[8] = value;
    }

    public void setContentDisposition(String value) {
        this.mHeaders[9] = value;
    }

    public void setAcceptRanges(String value) {
        this.mHeaders[10] = value;
    }

    public void setExpires(String value) {
        this.mHeaders[11] = value;
    }

    public void setCacheControl(String value) {
        this.mHeaders[12] = value;
    }

    public void setLastModified(String value) {
        this.mHeaders[13] = value;
    }

    public void setEtag(String value) {
        this.mHeaders[14] = value;
    }

    public void setXPermittedCrossDomainPolicies(String value) {
        this.mHeaders[18] = value;
    }

    public void getHeaders(HeaderCallback hcb) {
        for (int i = 0; i < 19; ++i) {
            String h = this.mHeaders[i];
            if (h == null) continue;
            hcb.header(sHeaderNames[i], h);
        }
        int extraLen = this.mExtraHeaderNames.size();
        for (int i = 0; i < extraLen; ++i) {
            hcb.header(this.mExtraHeaderNames.get(i), this.mExtraHeaderValues.get(i));
        }
    }

    public void setConnectionType(CharArrayBuffer buffer, int pos) {
        if (CharArrayBuffers.containsIgnoreCaseTrimmed(buffer, pos, "Close")) {
            this.connectionType = 1;
        } else if (CharArrayBuffers.containsIgnoreCaseTrimmed(buffer, pos, "Keep-Alive")) {
            this.connectionType = 2;
        }
    }

    public static interface HeaderCallback {
        public void header(String var1, String var2);
    }
}

