/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.ErrorCodes;
import android.nfc.INfcSecureElement;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class NfcSecureElement {
    public static final String TAG = "NfcSecureElement";
    public INfcSecureElement mService;

    public NfcSecureElement(INfcSecureElement mSecureElementService) {
        this.mService = mSecureElementService;
    }

    public int openSecureElementConnection(String seType) throws IOException {
        if (seType.equals("SmartMX")) {
            try {
                int handle = this.mService.openSecureElementConnection();
                if (handle != 0) {
                    return handle;
                }
                throw new IOException("SmartMX connection not allowed");
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in openSecureElementConnection(): ", e);
                return 0;
            }
        }
        if (seType.equals("UICC")) {
            return 0;
        }
        throw new IOException("Wrong Secure Element type");
    }

    public byte[] exchangeAPDU(int handle, byte[] data) throws IOException {
        try {
            byte[] response = this.mService.exchangeAPDU(handle, data);
            if (response == null) {
                throw new IOException("Exchange APDU failed");
            }
            return response;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in exchangeAPDU(): ", e);
            return null;
        }
    }

    public void closeSecureElementConnection(int handle) throws IOException {
        try {
            int status = this.mService.closeSecureElementConnection(handle);
            if (ErrorCodes.isError(status)) {
                throw new IOException("Error during the conection close");
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in closeSecureElement(): ", e);
        }
    }

    public int[] getSecureElementTechList(int handle) throws IOException {
        try {
            return this.mService.getSecureElementTechList(handle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getType(): ", e);
            return null;
        }
    }

    public byte[] getSecureElementUid(int handle) throws IOException {
        byte[] uid = null;
        try {
            uid = this.mService.getSecureElementUid(handle);
            if (uid == null) {
                throw new IOException("Get Secure Element UID failed");
            }
            return uid;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getType(): ", e);
            return null;
        }
    }
}

