/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import java.util.ArrayDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncTask<Params, Progress, Result> {
    public static final String LOG_TAG = "AsyncTask";
    public static final int CORE_POOL_SIZE = 5;
    public static final int MAXIMUM_POOL_SIZE = 128;
    public static final int KEEP_ALIVE = 1;
    public static final ThreadFactory sThreadFactory = new ThreadFactory(){
        public final AtomicInteger mCount = new AtomicInteger(1);

        public Thread newThread(Runnable r) {
            return new Thread(r, "AsyncTask #" + this.mCount.getAndIncrement());
        }
    };
    public static final BlockingQueue<Runnable> sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(10);
    public static final Executor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(5, 128, 1L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory);
    public static final Executor SERIAL_EXECUTOR = new SerialExecutor(null);
    public static final int MESSAGE_POST_RESULT = 1;
    public static final int MESSAGE_POST_PROGRESS = 2;
    public static final InternalHandler sHandler = new InternalHandler(null);
    public final WorkerRunnable<Params, Result> mWorker;
    public final FutureTask<Result> mFuture;
    public volatile Status mStatus = Status.PENDING;
    public final AtomicBoolean mTaskInvoked = new AtomicBoolean();

    public static void init() {
        sHandler.getLooper();
    }

    public AsyncTask() {
        this.mWorker = new WorkerRunnable<Params, Result>(){

            @Override
            public Result call() throws Exception {
                AsyncTask.this.mTaskInvoked.set(true);
                Process.setThreadPriority(10);
                return AsyncTask.this.postResult(AsyncTask.this.doInBackground(this.mParams));
            }
        };
        this.mFuture = new FutureTask<Result>(this.mWorker){

            @Override
            public void done() {
                try {
                    Object result = this.get();
                    AsyncTask.this.postResultIfNotInvoked(result);
                }
                catch (InterruptedException e) {
                    Log.w(AsyncTask.LOG_TAG, e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("An error occured while executing doInBackground()", e.getCause());
                }
                catch (CancellationException e) {
                    AsyncTask.this.postResultIfNotInvoked(null);
                }
                catch (Throwable t) {
                    throw new RuntimeException("An error occured while executing doInBackground()", t);
                }
            }
        };
    }

    public void postResultIfNotInvoked(Result result) {
        boolean wasTaskInvoked = this.mTaskInvoked.get();
        if (!wasTaskInvoked) {
            this.postResult(result);
        }
    }

    public Result postResult(Result result) {
        Message message = sHandler.obtainMessage(1, new AsyncTaskResult<Object>(this, result));
        message.sendToTarget();
        return result;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public abstract Result doInBackground(Params ... var1);

    public void onPreExecute() {
    }

    public void onPostExecute(Result result) {
    }

    public void onProgressUpdate(Progress ... values) {
    }

    public void onCancelled(Result result) {
        this.onCancelled();
    }

    public void onCancelled() {
    }

    public boolean isCancelled() {
        return this.mFuture.isCancelled();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    public Result get() throws InterruptedException, ExecutionException {
        return this.mFuture.get();
    }

    public Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mFuture.get(timeout, unit);
    }

    public AsyncTask<Params, Progress, Result> execute(Params ... params) {
        return this.executeOnExecutor(THREAD_POOL_EXECUTOR, params);
    }

    public AsyncTask<Params, Progress, Result> executeOnExecutor(Executor exec, Params ... params) {
        if (this.mStatus != Status.PENDING) {
            switch (this.mStatus) {
                case RUNNING: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case FINISHED: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
        }
        this.mStatus = Status.RUNNING;
        this.onPreExecute();
        this.mWorker.mParams = params;
        exec.execute(this.mFuture);
        return this;
    }

    public static void execute(Runnable runnable) {
        THREAD_POOL_EXECUTOR.execute(runnable);
    }

    public void publishProgress(Progress ... values) {
        if (!this.isCancelled()) {
            sHandler.obtainMessage(2, new AsyncTaskResult<Progress>(this, values)).sendToTarget();
        }
    }

    public void finish(Result result) {
        if (this.isCancelled()) {
            this.onCancelled(result);
        } else {
            this.onPostExecute(result);
        }
        this.mStatus = Status.FINISHED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AsyncTaskResult<Data> {
        public final AsyncTask mTask;
        public final Data[] mData;

        public AsyncTaskResult(AsyncTask task, Data ... data) {
            this.mTask = task;
            this.mData = data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WorkerRunnable<Params, Result>
    implements Callable<Result> {
        public Params[] mParams;

        public WorkerRunnable() {
        }

        public /* synthetic */ WorkerRunnable(1 x0) {
            this();
        }
    }

    public static class InternalHandler
    extends Handler {
        public InternalHandler() {
        }

        public void handleMessage(Message msg) {
            AsyncTaskResult result = (AsyncTaskResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    result.mTask.finish(result.mData[0]);
                    break;
                }
                case 2: {
                    result.mTask.onProgressUpdate(result.mData);
                }
            }
        }

        public /* synthetic */ InternalHandler(1 x0) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }

    public static class SerialExecutor
    implements Executor {
        public final ArrayDeque<Runnable> mTasks = new ArrayDeque();
        public Runnable mActive;

        public SerialExecutor() {
        }

        public synchronized void execute(final Runnable r) {
            this.mTasks.offer(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        r.run();
                        Object var2_1 = null;
                        SerialExecutor.this.scheduleNext();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        SerialExecutor.this.scheduleNext();
                        throw throwable;
                    }
                }
            });
            if (this.mActive == null) {
                this.scheduleNext();
            }
        }

        public synchronized void scheduleNext() {
            this.mActive = this.mTasks.poll();
            if (this.mActive != null) {
                THREAD_POOL_EXECUTOR.execute(this.mActive);
            }
        }

        public /* synthetic */ SerialExecutor(1 x0) {
            this();
        }
    }
}

