/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.os.Parcel;
import android.os.Parcelable;

public class StorageVolume
implements Parcelable {
    public final String mPath;
    public final String mDescription;
    public final boolean mRemovable;
    public final boolean mEmulated;
    public final int mMtpReserveSpace;
    public int mStorageId;
    public static final String EXTRA_STORAGE_VOLUME = "storage_volume";
    public static final Parcelable.Creator<StorageVolume> CREATOR = new Parcelable.Creator<StorageVolume>(){

        @Override
        public StorageVolume createFromParcel(Parcel in) {
            String path = in.readString();
            String description = in.readString();
            int removable = in.readInt();
            int emulated = in.readInt();
            int storageId = in.readInt();
            int mtpReserveSpace = in.readInt();
            return new StorageVolume(path, description, removable == 1, emulated == 1, mtpReserveSpace, storageId, null);
        }

        public StorageVolume[] newArray(int size) {
            return new StorageVolume[size];
        }
    };

    public StorageVolume(String path, String description, boolean removable, boolean emulated, int mtpReserveSpace) {
        this.mPath = path;
        this.mDescription = description;
        this.mRemovable = removable;
        this.mEmulated = emulated;
        this.mMtpReserveSpace = mtpReserveSpace;
    }

    public StorageVolume(String path, String description, boolean removable, boolean emulated, int mtpReserveSpace, int storageId) {
        this.mPath = path;
        this.mDescription = description;
        this.mRemovable = removable;
        this.mEmulated = emulated;
        this.mMtpReserveSpace = mtpReserveSpace;
        this.mStorageId = storageId;
    }

    public String getPath() {
        return this.mPath;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean isRemovable() {
        return this.mRemovable;
    }

    public boolean isEmulated() {
        return this.mEmulated;
    }

    public int getStorageId() {
        return this.mStorageId;
    }

    public void setStorageId(int index) {
        this.mStorageId = (index + 1 << 16) + 1;
    }

    public int getMtpReserveSpace() {
        return this.mMtpReserveSpace;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageVolume && this.mPath != null) {
            StorageVolume volume = (StorageVolume)obj;
            return this.mPath.equals(volume.mPath);
        }
        return false;
    }

    public int hashCode() {
        return this.mPath.hashCode();
    }

    public String toString() {
        return this.mPath;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mPath);
        parcel.writeString(this.mDescription);
        parcel.writeInt(this.mRemovable ? 1 : 0);
        parcel.writeInt(this.mEmulated ? 1 : 0);
        parcel.writeInt(this.mStorageId);
        parcel.writeInt(this.mMtpReserveSpace);
    }

    public /* synthetic */ StorageVolume(String x0, String x1, boolean x2, boolean x3, int x4, int x5, 1 x6) {
        this(x0, x1, x2, x3, x4, x5);
    }
}

