/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.renderscript.AllocationAdapter;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class Allocation
extends BaseObj {
    public Type mType;
    public Bitmap mBitmap;
    public int mUsage;
    public static final int USAGE_SCRIPT = 1;
    public static final int USAGE_GRAPHICS_TEXTURE = 2;
    public static final int USAGE_GRAPHICS_VERTEX = 4;
    public static final int USAGE_GRAPHICS_CONSTANTS = 8;
    public static BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();

    public Allocation(int id2, RenderScript rs, Type t, int usage) {
        super(id2, rs);
        if ((usage & 0xFFFFFFF0) != 0) {
            throw new RSIllegalArgumentException("Unknown usage specified.");
        }
        this.mType = t;
    }

    public void validateIsInt32() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_32 || this.mType.mElement.mType == Element.DataType.UNSIGNED_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    public void validateIsInt16() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_16 || this.mType.mElement.mType == Element.DataType.UNSIGNED_16) {
            return;
        }
        throw new RSIllegalArgumentException("16 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    public void validateIsInt8() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_8 || this.mType.mElement.mType == Element.DataType.UNSIGNED_8) {
            return;
        }
        throw new RSIllegalArgumentException("8 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    public void validateIsFloat32() {
        if (this.mType.mElement.mType == Element.DataType.FLOAT_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit float source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    public void validateIsObject() {
        if (this.mType.mElement.mType == Element.DataType.RS_ELEMENT || this.mType.mElement.mType == Element.DataType.RS_TYPE || this.mType.mElement.mType == Element.DataType.RS_ALLOCATION || this.mType.mElement.mType == Element.DataType.RS_SAMPLER || this.mType.mElement.mType == Element.DataType.RS_SCRIPT || this.mType.mElement.mType == Element.DataType.RS_MESH || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_FRAGMENT || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_VERTEX || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_RASTER || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_STORE) {
            return;
        }
        throw new RSIllegalArgumentException("Object source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    public void updateFromNative() {
        super.updateFromNative();
        int typeID = this.mRS.nAllocationGetType(this.getID());
        if (typeID != 0) {
            this.mType = new Type(typeID, this.mRS);
            this.mType.updateFromNative();
        }
    }

    public Type getType() {
        return this.mType;
    }

    public void syncAll(int srcLocation) {
        switch (srcLocation) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new RSIllegalArgumentException("Source must be exactly one usage type.");
            }
        }
        this.mRS.validate();
        this.mRS.nAllocationSyncAll(this.getID(), srcLocation);
    }

    public void copyFrom(BaseObj[] d) {
        this.mRS.validate();
        this.validateIsObject();
        if (d.length != this.mType.getCount()) {
            throw new RSIllegalArgumentException("Array size mismatch, allocation sizeX = " + this.mType.getCount() + ", array length = " + d.length);
        }
        int[] i = new int[d.length];
        for (int ct = 0; ct < d.length; ++ct) {
            i[ct] = d[ct].getID();
        }
        this.copy1DRangeFromUnchecked(0, this.mType.getCount(), i);
    }

    public void validateBitmapFormat(Bitmap b) {
        Bitmap.Config bc = b.getConfig();
        switch (bc) {
            case ALPHA_8: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_A) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getSizeBytes() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
            case ARGB_8888: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getSizeBytes() == 4) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getSizeBytes() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
            case RGB_565: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGB && this.mType.getElement().getSizeBytes() == 2) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getSizeBytes() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
            case ARGB_4444: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getSizeBytes() == 2) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getSizeBytes() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
        }
    }

    public void validateBitmapSize(Bitmap b) {
        if (this.mType.getX() != b.getWidth() || this.mType.getY() != b.getHeight()) {
            throw new RSIllegalArgumentException("Cannot update allocation from bitmap, sizes mismatch");
        }
    }

    public void copyFromUnchecked(int[] d) {
        this.mRS.validate();
        this.copy1DRangeFromUnchecked(0, this.mType.getCount(), d);
    }

    public void copyFromUnchecked(short[] d) {
        this.mRS.validate();
        this.copy1DRangeFromUnchecked(0, this.mType.getCount(), d);
    }

    public void copyFromUnchecked(byte[] d) {
        this.mRS.validate();
        this.copy1DRangeFromUnchecked(0, this.mType.getCount(), d);
    }

    public void copyFromUnchecked(float[] d) {
        this.mRS.validate();
        this.copy1DRangeFromUnchecked(0, this.mType.getCount(), d);
    }

    public void copyFrom(int[] d) {
        this.mRS.validate();
        this.copy1DRangeFrom(0, this.mType.getCount(), d);
    }

    public void copyFrom(short[] d) {
        this.mRS.validate();
        this.copy1DRangeFrom(0, this.mType.getCount(), d);
    }

    public void copyFrom(byte[] d) {
        this.mRS.validate();
        this.copy1DRangeFrom(0, this.mType.getCount(), d);
    }

    public void copyFrom(float[] d) {
        this.mRS.validate();
        this.copy1DRangeFrom(0, this.mType.getCount(), d);
    }

    public void copyFrom(Bitmap b) {
        this.mRS.validate();
        this.validateBitmapSize(b);
        this.validateBitmapFormat(b);
        this.mRS.nAllocationCopyFromBitmap(this.getID(), b);
    }

    public void setFromFieldPacker(int xoff, FieldPacker fp) {
        byte[] data;
        int count;
        int eSize = this.mType.mElement.getSizeBytes();
        if (eSize * (count = (data = fp.getData()).length / eSize) != data.length) {
            throw new RSIllegalArgumentException("Field packer length " + data.length + " not divisible by element size " + eSize + ".");
        }
        this.data1DChecks(xoff, count, data.length, data.length);
        this.mRS.nAllocationData1D(this.getID(), xoff, 0, count, data, data.length);
    }

    public void setFromFieldPacker(int xoff, int component_number, FieldPacker fp) {
        int eSize;
        if (component_number >= this.mType.mElement.mElements.length) {
            throw new RSIllegalArgumentException("Component_number " + component_number + " out of range.");
        }
        if (xoff < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        byte[] data = fp.getData();
        if (data.length != (eSize = this.mType.mElement.mElements[component_number].getSizeBytes())) {
            throw new RSIllegalArgumentException("Field packer sizelength " + data.length + " does not match component size " + eSize + ".");
        }
        this.mRS.nAllocationElementData1D(this.getID(), xoff, 0, component_number, data, data.length);
    }

    public void data1DChecks(int off, int count, int len, int dataSize) {
        this.mRS.validate();
        if (off < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        if (count < 1) {
            throw new RSIllegalArgumentException("Count must be >= 1.");
        }
        if (off + count > this.mType.getCount()) {
            throw new RSIllegalArgumentException("Overflow, Available count " + this.mType.getCount() + ", got " + count + " at offset " + off + ".");
        }
        if (len < dataSize) {
            throw new RSIllegalArgumentException("Array too small for allocation type.");
        }
    }

    public void generateMipmaps() {
        this.mRS.nAllocationGenerateMipmaps(this.getID());
    }

    public void copy1DRangeFromUnchecked(int off, int count, int[] d) {
        int dataSize = this.mType.mElement.getSizeBytes() * count;
        this.data1DChecks(off, count, d.length * 4, dataSize);
        this.mRS.nAllocationData1D(this.getID(), off, 0, count, d, dataSize);
    }

    public void copy1DRangeFromUnchecked(int off, int count, short[] d) {
        int dataSize = this.mType.mElement.getSizeBytes() * count;
        this.data1DChecks(off, count, d.length * 2, dataSize);
        this.mRS.nAllocationData1D(this.getID(), off, 0, count, d, dataSize);
    }

    public void copy1DRangeFromUnchecked(int off, int count, byte[] d) {
        int dataSize = this.mType.mElement.getSizeBytes() * count;
        this.data1DChecks(off, count, d.length, dataSize);
        this.mRS.nAllocationData1D(this.getID(), off, 0, count, d, dataSize);
    }

    public void copy1DRangeFromUnchecked(int off, int count, float[] d) {
        int dataSize = this.mType.mElement.getSizeBytes() * count;
        this.data1DChecks(off, count, d.length * 4, dataSize);
        this.mRS.nAllocationData1D(this.getID(), off, 0, count, d, dataSize);
    }

    public void copy1DRangeFrom(int off, int count, int[] d) {
        this.validateIsInt32();
        this.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, short[] d) {
        this.validateIsInt16();
        this.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, byte[] d) {
        this.validateIsInt8();
        this.copy1DRangeFromUnchecked(off, count, d);
    }

    public void copy1DRangeFrom(int off, int count, float[] d) {
        this.validateIsFloat32();
        this.copy1DRangeFromUnchecked(off, count, d);
    }

    public void validate2DRange(int xoff, int yoff, int w, int h) {
        if (xoff < 0 || yoff < 0) {
            throw new RSIllegalArgumentException("Offset cannot be negative.");
        }
        if (h < 0 || w < 0) {
            throw new RSIllegalArgumentException("Height or width cannot be negative.");
        }
        if (xoff + w > this.mType.mDimX || yoff + h > this.mType.mDimY) {
            throw new RSIllegalArgumentException("Updated region larger than allocation.");
        }
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, byte[] data) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getID(), xoff, yoff, 0, 0, w, h, data, data.length);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, short[] data) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getID(), xoff, yoff, 0, 0, w, h, data, data.length * 2);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, int[] data) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getID(), xoff, yoff, 0, 0, w, h, data, data.length * 4);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, float[] data) {
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getID(), xoff, yoff, 0, 0, w, h, data, data.length * 4);
    }

    public void copy2DRangeFrom(int xoff, int yoff, Bitmap data) {
        this.mRS.validate();
        this.validateBitmapFormat(data);
        this.validate2DRange(xoff, yoff, data.getWidth(), data.getHeight());
        this.mRS.nAllocationData2D(this.getID(), xoff, yoff, 0, 0, data);
    }

    public void copyTo(Bitmap b) {
        this.mRS.validate();
        this.validateBitmapFormat(b);
        this.validateBitmapSize(b);
        this.mRS.nAllocationCopyToBitmap(this.getID(), b);
    }

    public void copyTo(byte[] d) {
        this.validateIsInt8();
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(), d);
    }

    public void copyTo(short[] d) {
        this.validateIsInt16();
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(), d);
    }

    public void copyTo(int[] d) {
        this.validateIsInt32();
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(), d);
    }

    public void copyTo(float[] d) {
        this.validateIsFloat32();
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(), d);
    }

    public synchronized void resize(int dimX) {
        if (this.mType.getY() > 0 || this.mType.getZ() > 0 || this.mType.hasFaces() || this.mType.hasMipmaps()) {
            throw new RSInvalidStateException("Resize only support for 1D allocations at this time.");
        }
        this.mRS.nAllocationResize1D(this.getID(), dimX);
        this.mRS.finish();
        int typeID = this.mRS.nAllocationGetType(this.getID());
        this.mType = new Type(typeID, this.mRS);
        this.mType.updateFromNative();
    }

    public static Allocation createTyped(RenderScript rs, Type type, MipmapControl mips, int usage) {
        rs.validate();
        if (type.getID() == 0) {
            throw new RSInvalidStateException("Bad Type");
        }
        int id2 = rs.nAllocationCreateTyped(type.getID(), mips.mID, usage);
        if (id2 == 0) {
            throw new RSRuntimeException("Allocation creation failed.");
        }
        return new Allocation(id2, rs, type, usage);
    }

    public static Allocation createTyped(RenderScript rs, Type type, int usage) {
        return Allocation.createTyped(rs, type, MipmapControl.MIPMAP_NONE, usage);
    }

    public static Allocation createTyped(RenderScript rs, Type type) {
        return Allocation.createTyped(rs, type, MipmapControl.MIPMAP_NONE, 1);
    }

    public static Allocation createSized(RenderScript rs, Element e, int count, int usage) {
        rs.validate();
        Type.Builder b = new Type.Builder(rs, e);
        b.setX(count);
        Type t = b.create();
        int id2 = rs.nAllocationCreateTyped(t.getID(), MipmapControl.MIPMAP_NONE.mID, usage);
        if (id2 == 0) {
            throw new RSRuntimeException("Allocation creation failed.");
        }
        return new Allocation(id2, rs, t, usage);
    }

    public static Allocation createSized(RenderScript rs, Element e, int count) {
        return Allocation.createSized(rs, e, count, 1);
    }

    public static Element elementFromBitmap(RenderScript rs, Bitmap b) {
        Bitmap.Config bc = b.getConfig();
        if (bc == Bitmap.Config.ALPHA_8) {
            return Element.A_8(rs);
        }
        if (bc == Bitmap.Config.ARGB_4444) {
            return Element.RGBA_4444(rs);
        }
        if (bc == Bitmap.Config.ARGB_8888) {
            return Element.RGBA_8888(rs);
        }
        if (bc == Bitmap.Config.RGB_565) {
            return Element.RGB_565(rs);
        }
        throw new RSInvalidStateException("Bad bitmap type: " + (Object)((Object)bc));
    }

    public static Type typeFromBitmap(RenderScript rs, Bitmap b, MipmapControl mip) {
        Element e = Allocation.elementFromBitmap(rs, b);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(b.getWidth());
        tb.setY(b.getHeight());
        tb.setMipmaps(mip == MipmapControl.MIPMAP_FULL);
        return tb.create();
    }

    public static Allocation createFromBitmap(RenderScript rs, Bitmap b, MipmapControl mips, int usage) {
        rs.validate();
        Type t = Allocation.typeFromBitmap(rs, b, mips);
        int id2 = rs.nAllocationCreateFromBitmap(t.getID(), mips.mID, b, usage);
        if (id2 == 0) {
            throw new RSRuntimeException("Load failed.");
        }
        return new Allocation(id2, rs, t, usage);
    }

    public static Allocation createFromBitmap(RenderScript rs, Bitmap b) {
        return Allocation.createFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createCubemapFromBitmap(RenderScript rs, Bitmap b, MipmapControl mips, int usage) {
        boolean isPow2;
        rs.validate();
        int height = b.getHeight();
        int width = b.getWidth();
        if (width % 6 != 0) {
            throw new RSIllegalArgumentException("Cubemap height must be multiple of 6");
        }
        if (width / 6 != height) {
            throw new RSIllegalArgumentException("Only square cube map faces supported");
        }
        boolean bl = isPow2 = (height & height - 1) == 0;
        if (!isPow2) {
            throw new RSIllegalArgumentException("Only power of 2 cube faces supported");
        }
        Element e = Allocation.elementFromBitmap(rs, b);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(height);
        tb.setY(height);
        tb.setFaces(true);
        tb.setMipmaps(mips == MipmapControl.MIPMAP_FULL);
        Type t = tb.create();
        int id2 = rs.nAllocationCubeCreateFromBitmap(t.getID(), mips.mID, b, usage);
        if (id2 == 0) {
            throw new RSRuntimeException("Load failed for bitmap " + b + " element " + e);
        }
        return new Allocation(id2, rs, t, usage);
    }

    public static Allocation createCubemapFromBitmap(RenderScript rs, Bitmap b) {
        return Allocation.createCubemapFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg, MipmapControl mips, int usage) {
        boolean isPow2;
        int height = xpos.getHeight();
        if (xpos.getWidth() != height || xneg.getWidth() != height || xneg.getHeight() != height || ypos.getWidth() != height || ypos.getHeight() != height || yneg.getWidth() != height || yneg.getHeight() != height || zpos.getWidth() != height || zpos.getHeight() != height || zneg.getWidth() != height || zneg.getHeight() != height) {
            throw new RSIllegalArgumentException("Only square cube map faces supported");
        }
        boolean bl = isPow2 = (height & height - 1) == 0;
        if (!isPow2) {
            throw new RSIllegalArgumentException("Only power of 2 cube faces supported");
        }
        Element e = Allocation.elementFromBitmap(rs, xpos);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(height);
        tb.setY(height);
        tb.setFaces(true);
        tb.setMipmaps(mips == MipmapControl.MIPMAP_FULL);
        Type t = tb.create();
        Allocation cubemap = Allocation.createTyped(rs, t, mips, usage);
        AllocationAdapter adapter = AllocationAdapter.create2D(rs, cubemap);
        adapter.setFace(Type.CubemapFace.POSITVE_X);
        adapter.copyFrom(xpos);
        adapter.setFace(Type.CubemapFace.NEGATIVE_X);
        adapter.copyFrom(xneg);
        adapter.setFace(Type.CubemapFace.POSITVE_Y);
        adapter.copyFrom(ypos);
        adapter.setFace(Type.CubemapFace.NEGATIVE_Y);
        adapter.copyFrom(yneg);
        adapter.setFace(Type.CubemapFace.POSITVE_Z);
        adapter.copyFrom(zpos);
        adapter.setFace(Type.CubemapFace.NEGATIVE_Z);
        adapter.copyFrom(zneg);
        return cubemap;
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg) {
        return Allocation.createCubemapFromCubeFaces(rs, xpos, xneg, ypos, yneg, zpos, zneg, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createFromBitmapResource(RenderScript rs, Resources res, int id2, MipmapControl mips, int usage) {
        rs.validate();
        Bitmap b = BitmapFactory.decodeResource(res, id2);
        Allocation alloc = Allocation.createFromBitmap(rs, b, mips, usage);
        b.recycle();
        return alloc;
    }

    public static Allocation createFromBitmapResource(RenderScript rs, Resources res, int id2) {
        return Allocation.createFromBitmapResource(rs, res, id2, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createFromString(RenderScript rs, String str, int usage) {
        rs.validate();
        byte[] allocArray = null;
        try {
            allocArray = str.getBytes("UTF-8");
            Allocation alloc = Allocation.createSized(rs, Element.U8(rs), allocArray.length, usage);
            alloc.copyFrom(allocArray);
            return alloc;
        }
        catch (Exception e) {
            throw new RSRuntimeException("Could not convert string to utf-8.");
        }
    }

    static {
        Allocation.mBitmapOptions.inScaled = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MipmapControl {
        MIPMAP_NONE(0),
        MIPMAP_FULL(1),
        MIPMAP_ON_SYNC_TO_TEXTURE(2);

        public int mID;

        public MipmapControl(int id2) {
            this.mID = id2;
        }
    }
}

