/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.renderscript.RenderScriptGL;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public class RSSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    public SurfaceHolder mSurfaceHolder;
    public RenderScriptGL mRS;

    public RSSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public RSSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void init() {
        SurfaceHolder holder = this.getHolder();
        holder.addCallback(this);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mRS != null) {
            this.mRS.setSurface(null, 0, 0);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        if (this.mRS != null) {
            this.mRS.setSurface(holder, w, h);
        }
    }

    public void pause() {
        if (this.mRS != null) {
            this.mRS.pause();
        }
    }

    public void resume() {
        if (this.mRS != null) {
            this.mRS.resume();
        }
    }

    public RenderScriptGL createRenderScriptGL(RenderScriptGL.SurfaceConfig sc) {
        RenderScriptGL rs = new RenderScriptGL(this.getContext(), sc);
        this.setRenderScriptGL(rs);
        return rs;
    }

    public void destroyRenderScriptGL() {
        this.mRS.destroy();
        this.mRS = null;
    }

    public void setRenderScriptGL(RenderScriptGL rs) {
        this.mRS = rs;
    }

    public RenderScriptGL getRenderScriptGL() {
        return this.mRS;
    }
}

