/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import java.io.UnsupportedEncodingException;

public class Script
extends BaseObj {
    public void invoke(int slot) {
        this.mRS.nScriptInvoke(this.getID(), slot);
    }

    public void invoke(int slot, FieldPacker v) {
        if (v != null) {
            this.mRS.nScriptInvokeV(this.getID(), slot, v.getData());
        } else {
            this.mRS.nScriptInvoke(this.getID(), slot);
        }
    }

    public Script(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public void bindAllocation(Allocation va, int slot) {
        this.mRS.validate();
        if (va != null) {
            this.mRS.nScriptBindAllocation(this.getID(), va.getID(), slot);
        } else {
            this.mRS.nScriptBindAllocation(this.getID(), 0, slot);
        }
    }

    public void setVar(int index, float v) {
        this.mRS.nScriptSetVarF(this.getID(), index, v);
    }

    public void setVar(int index, double v) {
        this.mRS.nScriptSetVarD(this.getID(), index, v);
    }

    public void setVar(int index, int v) {
        this.mRS.nScriptSetVarI(this.getID(), index, v);
    }

    public void setVar(int index, long v) {
        this.mRS.nScriptSetVarJ(this.getID(), index, v);
    }

    public void setVar(int index, boolean v) {
        this.mRS.nScriptSetVarI(this.getID(), index, v ? 1 : 0);
    }

    public void setVar(int index, BaseObj o) {
        this.mRS.nScriptSetVarObj(this.getID(), index, o == null ? 0 : o.getID());
    }

    public void setVar(int index, FieldPacker v) {
        this.mRS.nScriptSetVarV(this.getID(), index, v.getData());
    }

    public void setTimeZone(String timeZone) {
        this.mRS.validate();
        try {
            this.mRS.nScriptSetTimeZone(this.getID(), timeZone.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class FieldBase {
        public Element mElement;
        public Allocation mAllocation;

        public void init(RenderScript rs, int dimx) {
            this.mAllocation = Allocation.createSized(rs, this.mElement, dimx, 1);
        }

        public void init(RenderScript rs, int dimx, int usages) {
            this.mAllocation = Allocation.createSized(rs, this.mElement, dimx, 1 | usages);
        }

        public Element getElement() {
            return this.mElement;
        }

        public Type getType() {
            return this.mAllocation.getType();
        }

        public Allocation getAllocation() {
            return this.mAllocation;
        }

        public void updateAllocation() {
        }
    }

    public static class Builder {
        public RenderScript mRS;

        public Builder(RenderScript rs) {
            this.mRS = rs;
        }
    }
}

