/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Spannable;
import android.text.method.NumberKeyListener;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;

public class DialerKeyListener
extends NumberKeyListener {
    public static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '#', '*', '+', '-', '(', ')', ',', '/', 'N', '.', ' ', ';'};
    public static DialerKeyListener sInstance;

    public char[] getAcceptedChars() {
        return CHARACTERS;
    }

    public static DialerKeyListener getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new DialerKeyListener();
        return sInstance;
    }

    public int getInputType() {
        return 3;
    }

    public int lookup(KeyEvent event, Spannable content) {
        int meta = event.getMetaState() | DialerKeyListener.getMetaState(content);
        char number = event.getNumber();
        if ((meta & 3) == 0 && number != '\u0000') {
            return number;
        }
        int match = super.lookup(event, content);
        if (match != 0) {
            return match;
        }
        if (meta != 0) {
            KeyCharacterMap.KeyData kd = new KeyCharacterMap.KeyData();
            char[] accepted = this.getAcceptedChars();
            if (event.getKeyData(kd)) {
                for (int i = 1; i < kd.meta.length; ++i) {
                    if (!DialerKeyListener.ok(accepted, kd.meta[i])) continue;
                    return kd.meta[i];
                }
            }
        }
        return number;
    }
}

