/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.view.CompatibilityInfoHolder;
import android.view.IWindowManager;
import com.android.tools.layoutlib.create.OverrideMethod;

public class Display {
    public static final String TAG = "Display";
    public static final boolean DEBUG_COMPAT = false;
    public static final int DEFAULT_DISPLAY = 0;
    public final CompatibilityInfoHolder mCompatibilityInfo;
    public final int mDisplay;
    public int mPixelFormat;
    public float mRefreshRate;
    public float mDensity;
    public float mDpiX;
    public float mDpiY;
    public final Point mTmpPoint = new Point();
    public final DisplayMetrics mTmpMetrics = new DisplayMetrics();
    public float mLastGetTime;
    public static final Object sStaticInit = new Object();
    public static boolean sInitialized = false;
    public static IWindowManager sWindowManager;
    public static volatile CompatibilityInfo sCompatibilityInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display(int display, CompatibilityInfoHolder compatInfo) {
        Object object = sStaticInit;
        synchronized (object) {
            if (!sInitialized) {
                Display.nativeClassInit();
                sInitialized = true;
            }
        }
        this.mCompatibilityInfo = compatInfo != null ? compatInfo : new CompatibilityInfoHolder();
        this.mDisplay = display;
        this.init(display);
    }

    public static void setCompatibilityInfo(CompatibilityInfo compatInfo) {
        sCompatibilityInfo = compatInfo != null && (compatInfo.isScalingRequired() || !compatInfo.supportsScreen()) ? compatInfo : null;
    }

    public int getDisplayId() {
        return this.mDisplay;
    }

    public static int getDisplayCount() {
        return OverrideMethod.invokeI("android.view.Display#getDisplayCount()I", true, null);
    }

    public void getSize(Point outSize) {
        this.getSizeInternal(outSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSizeInternal(Point outSize, boolean doCompat) {
        block6: {
            try {
                IWindowManager wm = Display.getWindowManager();
                if (wm != null) {
                    CompatibilityInfo ci;
                    wm.getDisplaySize(outSize);
                    if (!doCompat || (ci = this.mCompatibilityInfo.getIfNeeded()) == null) break block6;
                    DisplayMetrics displayMetrics = this.mTmpMetrics;
                    synchronized (displayMetrics) {
                        this.mTmpMetrics.noncompatWidthPixels = outSize.x;
                        this.mTmpMetrics.noncompatHeightPixels = outSize.y;
                        this.mTmpMetrics.density = this.mDensity;
                        ci.applyToDisplayMetrics(this.mTmpMetrics);
                        outSize.x = this.mTmpMetrics.widthPixels;
                        outSize.y = this.mTmpMetrics.heightPixels;
                        break block6;
                    }
                }
                outSize.y = this.getRealHeight();
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Unable to get display size", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRectSize(Rect outSize) {
        Point point = this.mTmpPoint;
        synchronized (point) {
            this.getSizeInternal(this.mTmpPoint, true);
            outSize.set(0, 0, this.mTmpPoint.x, this.mTmpPoint.y);
        }
    }

    public int getMaximumSizeDimension() {
        try {
            IWindowManager wm = Display.getWindowManager();
            return wm.getMaximumSizeDimension();
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Unable to get display maximum size dimension", e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getWidth() {
        Point point = this.mTmpPoint;
        synchronized (point) {
            long now = SystemClock.uptimeMillis();
            if ((float)now > this.mLastGetTime + 20.0f) {
                this.getSizeInternal(this.mTmpPoint, true);
                this.mLastGetTime = now;
            }
            return this.mTmpPoint.x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getHeight() {
        Point point = this.mTmpPoint;
        synchronized (point) {
            long now = SystemClock.uptimeMillis();
            if ((float)now > this.mLastGetTime + 20.0f) {
                this.getSizeInternal(this.mTmpPoint, true);
                this.mLastGetTime = now;
            }
            return this.mTmpPoint.y;
        }
    }

    public int getRealWidth() {
        return OverrideMethod.invokeI("android.view.Display#getRealWidth()I", true, this);
    }

    public int getRealHeight() {
        return OverrideMethod.invokeI("android.view.Display#getRealHeight()I", true, this);
    }

    public int getRawWidth() {
        return OverrideMethod.invokeI("android.view.Display#getRawWidth()I", true, this);
    }

    public int getRawHeight() {
        return OverrideMethod.invokeI("android.view.Display#getRawHeight()I", true, this);
    }

    public int getRotation() {
        return this.getOrientation();
    }

    @Deprecated
    public int getOrientation() {
        return OverrideMethod.invokeI("android.view.Display#getOrientation()I", true, this);
    }

    public int getPixelFormat() {
        return this.mPixelFormat;
    }

    public float getRefreshRate() {
        return this.mRefreshRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMetrics(DisplayMetrics outMetrics) {
        Point point = this.mTmpPoint;
        synchronized (point) {
            this.getSizeInternal(this.mTmpPoint, false);
            outMetrics.widthPixels = this.mTmpPoint.x;
            outMetrics.heightPixels = this.mTmpPoint.y;
        }
        this.getNonSizeMetrics(outMetrics);
        CompatibilityInfo ci = this.mCompatibilityInfo.getIfNeeded();
        if (ci != null) {
            ci.applyToDisplayMetrics(outMetrics);
        }
    }

    public void getRealMetrics(DisplayMetrics outMetrics) {
        outMetrics.widthPixels = this.getRealWidth();
        outMetrics.heightPixels = this.getRealHeight();
        this.getNonSizeMetrics(outMetrics);
    }

    public void getNonSizeMetrics(DisplayMetrics outMetrics) {
        outMetrics.densityDpi = (int)(this.mDensity * 160.0f + 0.5f);
        outMetrics.noncompatWidthPixels = outMetrics.widthPixels;
        outMetrics.noncompatHeightPixels = outMetrics.heightPixels;
        outMetrics.scaledDensity = outMetrics.noncompatScaledDensity = (outMetrics.density = (outMetrics.noncompatDensity = this.mDensity));
        outMetrics.xdpi = outMetrics.noncompatXdpi = this.mDpiX;
        outMetrics.ydpi = outMetrics.noncompatYdpi = this.mDpiY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWindowManager getWindowManager() {
        Object object = sStaticInit;
        synchronized (object) {
            if (sWindowManager == null) {
                sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
            }
            return sWindowManager;
        }
    }

    public static void nativeClassInit() {
        OverrideMethod.invokeV("android.view.Display#nativeClassInit()V", true, null);
    }

    public void init(int n) {
        OverrideMethod.invokeV("android.view.Display#init(I)V", true, this);
    }

    public static Display createCompatibleDisplay(int displayId, CompatibilityInfoHolder compat) {
        return new Display(displayId, compat);
    }
}

