/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.DisplayList;
import android.view.GLES20DisplayList;
import android.view.GLES20Layer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import com.android.tools.layoutlib.create.OverrideMethod;

public class GLES20Canvas
extends HardwareCanvas {
    public final boolean mOpaque;
    public int mRenderer;
    public CanvasFinalizer mFinalizer;
    public int mWidth;
    public int mHeight;
    public final float[] mPoint = new float[2];
    public final float[] mLine = new float[4];
    public final Rect mClipBounds = new Rect();
    public DrawFilter mFilter;
    public static boolean sIsAvailable = GLES20Canvas.nIsAvailable();

    public static boolean nIsAvailable() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nIsAvailable()Z", true, null) != 0;
    }

    public static boolean isAvailable() {
        return sIsAvailable;
    }

    public GLES20Canvas(boolean translucent) {
        this(false, translucent);
    }

    public GLES20Canvas(int layer, boolean translucent) {
        this.mOpaque = !translucent;
        this.mRenderer = GLES20Canvas.nCreateLayerRenderer(layer);
        this.setupFinalizer();
    }

    public GLES20Canvas(boolean record, boolean translucent) {
        this.mOpaque = !translucent;
        this.setupRenderer(record);
    }

    public void setupRenderer(boolean record) {
        this.mRenderer = record ? GLES20Canvas.nGetDisplayListRenderer(this.mRenderer) : GLES20Canvas.nCreateRenderer();
        this.setupFinalizer();
    }

    public void setupFinalizer() {
        if (this.mRenderer == 0) {
            throw new IllegalStateException("Could not create GLES20Canvas renderer");
        }
        this.mFinalizer = CanvasFinalizer.getFinalizer(this.mFinalizer, this.mRenderer);
    }

    public static int nCreateRenderer() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCreateRenderer()I", true, null);
    }

    public static int nCreateLayerRenderer(int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCreateLayerRenderer(I)I", true, null);
    }

    public static int nGetDisplayListRenderer(int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetDisplayListRenderer(I)I", true, null);
    }

    public static void nDestroyRenderer(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyRenderer(I)V", true, null);
    }

    public static int nCreateLayer(int n, int n2, boolean bl, int[] nArray) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCreateLayer(IIZ[I)I", true, null);
    }

    public static void nResizeLayer(int n, int n2, int n3, int[] nArray) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResizeLayer(III[I)V", true, null);
    }

    public static void nDestroyLayer(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyLayer(I)V", true, null);
    }

    public static void nDestroyLayerDeferred(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyLayerDeferred(I)V", true, null);
    }

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setViewport(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20Canvas.nSetViewport(this.mRenderer, width, height);
    }

    public static void nSetViewport(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetViewport(III)V", true, null);
    }

    public static boolean preserveBackBuffer() {
        return GLES20Canvas.nPreserveBackBuffer();
    }

    public static boolean nPreserveBackBuffer() {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nPreserveBackBuffer()Z", true, null) != 0;
    }

    public void onPreDraw(Rect dirty) {
        if (dirty != null) {
            GLES20Canvas.nPrepareDirty(this.mRenderer, dirty.left, dirty.top, dirty.right, dirty.bottom, this.mOpaque);
        } else {
            GLES20Canvas.nPrepare(this.mRenderer, this.mOpaque);
        }
    }

    public static void nPrepare(int n, boolean bl) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nPrepare(IZ)V", true, null);
    }

    public static void nPrepareDirty(int n, int n2, int n3, int n4, int n5, boolean bl) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nPrepareDirty(IIIIIZ)V", true, null);
    }

    public void onPostDraw() {
        GLES20Canvas.nFinish(this.mRenderer);
    }

    public static void nFinish(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nFinish(I)V", true, null);
    }

    public boolean callDrawGLFunction(int drawGLFunction) {
        return GLES20Canvas.nCallDrawGLFunction(this.mRenderer, drawGLFunction);
    }

    public static boolean nCallDrawGLFunction(int n, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nCallDrawGLFunction(II)Z", true, null) != 0;
    }

    public int getDisplayList() {
        return GLES20Canvas.nGetDisplayList(this.mRenderer);
    }

    public static int nGetDisplayList(int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetDisplayList(I)I", true, null);
    }

    public static void destroyDisplayList(int displayList) {
        GLES20Canvas.nDestroyDisplayList(displayList);
    }

    public static void nDestroyDisplayList(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDestroyDisplayList(I)V", true, null);
    }

    public boolean drawDisplayList(DisplayList displayList, int width, int height, Rect dirty) {
        return GLES20Canvas.nDrawDisplayList(this.mRenderer, ((GLES20DisplayList)displayList).mNativeDisplayList, width, height, dirty);
    }

    public static boolean nDrawDisplayList(int n, int n2, int n3, int n4, Rect rect) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nDrawDisplayList(IIIILandroid/graphics/Rect;)Z", true, null) != 0;
    }

    public void drawHardwareLayer(HardwareLayer layer, float x, float y, Paint paint) {
        GLES20Layer glLayer = (GLES20Layer)layer;
        boolean hasColorFilter = paint != null && this.setupColorFilter(paint);
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawLayer(this.mRenderer, glLayer.getLayer(), x, y, nativePaint);
        if (hasColorFilter) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawLayer(int n, int n2, float f, float f2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawLayer(IIFFI)V", true, null);
    }

    public void interrupt() {
        GLES20Canvas.nInterrupt(this.mRenderer);
    }

    public void resume() {
        GLES20Canvas.nResume(this.mRenderer);
    }

    public static void nInterrupt(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nInterrupt(I)V", true, null);
    }

    public static void nResume(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResume(I)V", true, null);
    }

    public boolean clipPath(Path path) {
        throw new UnsupportedOperationException();
    }

    public boolean clipPath(Path path, Region.Op op) {
        throw new UnsupportedOperationException();
    }

    public boolean clipRect(float left, float top, float right, float bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    public static boolean nClipRect(int n, float f, float f2, float f3, float f4, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipRect(IFFFFI)Z", true, null) != 0;
    }

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, op.nativeInt);
    }

    public boolean clipRect(int left, int top, int right, int bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    public static boolean nClipRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nClipRect(IIIIII)Z", true, null) != 0;
    }

    public boolean clipRect(Rect rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(RectF rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        throw new UnsupportedOperationException();
    }

    public boolean clipRegion(Region region, Region.Op op) {
        throw new UnsupportedOperationException();
    }

    public boolean getClipBounds(Rect bounds) {
        return GLES20Canvas.nGetClipBounds(this.mRenderer, bounds);
    }

    public static boolean nGetClipBounds(int n, Rect rect) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetClipBounds(ILandroid/graphics/Rect;)Z", true, null) != 0;
    }

    public boolean quickReject(float left, float top, float right, float bottom, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, left, top, right, bottom, type.nativeInt);
    }

    public static boolean nQuickReject(int n, float f, float f2, float f3, float f4, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nQuickReject(IFFFFI)Z", true, null) != 0;
    }

    public boolean quickReject(Path path, Canvas.EdgeType type) {
        throw new UnsupportedOperationException();
    }

    public boolean quickReject(RectF rect, Canvas.EdgeType type) {
        return this.quickReject(rect.left, rect.top, rect.right, rect.bottom, type);
    }

    public void translate(float dx, float dy) {
        if (dx != 0.0f || dy != 0.0f) {
            GLES20Canvas.nTranslate(this.mRenderer, dx, dy);
        }
    }

    public static void nTranslate(int n, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nTranslate(IFF)V", true, null);
    }

    public void skew(float sx, float sy) {
        GLES20Canvas.nSkew(this.mRenderer, sx, sy);
    }

    public static void nSkew(int n, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSkew(IFF)V", true, null);
    }

    public void rotate(float degrees) {
        GLES20Canvas.nRotate(this.mRenderer, degrees);
    }

    public static void nRotate(int n, float f) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRotate(IF)V", true, null);
    }

    public void scale(float sx, float sy) {
        GLES20Canvas.nScale(this.mRenderer, sx, sy);
    }

    public static void nScale(int n, float f, float f2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nScale(IFF)V", true, null);
    }

    public void setMatrix(Matrix matrix) {
        GLES20Canvas.nSetMatrix(this.mRenderer, matrix.native_instance);
    }

    public static void nSetMatrix(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetMatrix(II)V", true, null);
    }

    public int getNativeMatrix() {
        return GLES20Canvas.nGetMatrix(this.mRenderer);
    }

    public static int nGetMatrix(int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetMatrix(I)I", true, null);
    }

    public void getMatrix(Matrix matrix) {
        GLES20Canvas.nGetMatrix(this.mRenderer, matrix.native_instance);
    }

    public static void nGetMatrix(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nGetMatrix(II)V", true, null);
    }

    public void concat(Matrix matrix) {
        GLES20Canvas.nConcatMatrix(this.mRenderer, matrix.native_instance);
    }

    public static void nConcatMatrix(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nConcatMatrix(II)V", true, null);
    }

    public int save() {
        return GLES20Canvas.nSave(this.mRenderer, 3);
    }

    public int save(int saveFlags) {
        return GLES20Canvas.nSave(this.mRenderer, saveFlags);
    }

    public static int nSave(int n, int n2) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSave(II)I", true, null);
    }

    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
    }

    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        if (left < right && top < bottom) {
            boolean hasColorFilter = paint != null && this.setupColorFilter(paint);
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            int count = GLES20Canvas.nSaveLayer(this.mRenderer, left, top, right, bottom, nativePaint, saveFlags);
            if (hasColorFilter) {
                GLES20Canvas.nResetModifiers(this.mRenderer);
            }
            return count;
        }
        return this.save(saveFlags);
    }

    public static int nSaveLayer(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayer(IFFFFII)I", true, null);
    }

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        if (left < right && top < bottom) {
            return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, left, top, right, bottom, alpha, saveFlags);
        }
        return this.save(saveFlags);
    }

    public static int nSaveLayerAlpha(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nSaveLayerAlpha(IFFFFII)I", true, null);
    }

    public void restore() {
        GLES20Canvas.nRestore(this.mRenderer);
    }

    public static void nRestore(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRestore(I)V", true, null);
    }

    public void restoreToCount(int saveCount) {
        GLES20Canvas.nRestoreToCount(this.mRenderer, saveCount);
    }

    public static void nRestoreToCount(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nRestoreToCount(II)V", true, null);
    }

    public int getSaveCount() {
        return GLES20Canvas.nGetSaveCount(this.mRenderer);
    }

    public static int nGetSaveCount(int n) {
        return OverrideMethod.invokeI("android.view.GLES20Canvas#nGetSaveCount(I)I", true, null);
    }

    public void setDrawFilter(DrawFilter filter) {
        this.mFilter = filter;
    }

    public DrawFilter getDrawFilter() {
        return this.mFilter;
    }

    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        boolean hasModifier = this.setupModifiers(paint);
        GLES20Canvas.nDrawArc(this.mRenderer, oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint.mNativePaint);
        if (hasModifier) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawArc(int n, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawArc(IFFFFFFZI)V", true, null);
    }

    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    public void drawPatch(Bitmap bitmap, byte[] chunks, RectF dst, Paint paint) {
        boolean hasColorFilter = paint != null && this.setupColorFilter(paint);
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, chunks, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        if (hasColorFilter) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawPatch(int n, int n2, byte[] byArray, byte[] byArray2, float f, float f2, float f3, float f4, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPatch(II[B[BFFFFI)V", true, null);
    }

    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        boolean hasColorFilter = paint != null && this.setupColorFilter(paint);
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, nativePaint);
        if (hasColorFilter) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawBitmap(int n, int n2, byte[] byArray, float f, float f2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(II[BFFI)V", true, null);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        boolean hasColorFilter = paint != null && this.setupColorFilter(paint);
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, matrix.native_instance, nativePaint);
        if (hasColorFilter) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawBitmap(int n, int n2, byte[] byArray, int n3, int n4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(II[BII)V", true, null);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        int bottom;
        int right;
        int left;
        int top;
        int nativePaint;
        boolean hasColorFilter = paint != null && this.setupColorFilter(paint);
        int n = nativePaint = paint == null ? 0 : paint.mNativePaint;
        if (src == null) {
            top = 0;
            left = 0;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        if (hasColorFilter) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        boolean hasColorFilter = paint != null && this.setupColorFilter(paint);
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, src.left, src.top, src.right, src.bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        if (hasColorFilter) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawBitmap(int n, int n2, byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmap(II[BFFFFFFFFI)V", true, null);
    }

    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        boolean hasColorFilter = paint != null && this.setupColorFilter(paint);
        Bitmap.Config config = hasAlpha ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap b = Bitmap.createBitmap(colors, offset, stride, width, height, config);
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, b.mNativeBitmap, b.mBuffer, x, y, nativePaint);
        b.recycle();
        if (hasColorFilter) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if (meshWidth < 0 || meshHeight < 0 || vertOffset < 0 || colorOffset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        GLES20Canvas.checkRange(verts.length, vertOffset, count * 2);
        colors = null;
        colorOffset = 0;
        boolean hasColorFilter = paint != null && this.setupColorFilter(paint);
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawBitmapMesh(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, nativePaint);
        if (hasColorFilter) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawBitmapMesh(int n, int n2, byte[] byArray, int n3, int n4, float[] fArray, int n5, int[] nArray, int n6, int n7) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawBitmapMesh(II[BII[FI[III)V", true, null);
    }

    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        boolean hasModifier = this.setupModifiers(paint);
        GLES20Canvas.nDrawCircle(this.mRenderer, cx, cy, radius, paint.mNativePaint);
        if (hasModifier) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawCircle(int n, float f, float f2, float f3, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawCircle(IFFFI)V", true, null);
    }

    public void drawColor(int color2) {
        this.drawColor(color2, PorterDuff.Mode.SRC_OVER);
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        GLES20Canvas.nDrawColor(this.mRenderer, color2, mode.nativeInt);
    }

    public static void nDrawColor(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawColor(III)V", true, null);
    }

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        this.mLine[0] = startX;
        this.mLine[1] = startY;
        this.mLine[2] = stopX;
        this.mLine[3] = stopY;
        this.drawLines(this.mLine, 0, 4, paint);
    }

    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        if ((offset | count) < 0 || offset + count > pts.length) {
            throw new IllegalArgumentException("The lines array must contain 4 elements per line.");
        }
        boolean hasModifier = this.setupModifiers(paint);
        GLES20Canvas.nDrawLines(this.mRenderer, pts, offset, count, paint.mNativePaint);
        if (hasModifier) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawLines(int n, float[] fArray, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawLines(I[FIII)V", true, null);
    }

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    public void drawOval(RectF oval, Paint paint) {
        boolean hasModifier = this.setupModifiers(paint);
        GLES20Canvas.nDrawOval(this.mRenderer, oval.left, oval.top, oval.right, oval.bottom, paint.mNativePaint);
        if (hasModifier) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawOval(int n, float f, float f2, float f3, float f4, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawOval(IFFFFI)V", true, null);
    }

    public void drawPaint(Paint paint) {
        Rect r = this.mClipBounds;
        GLES20Canvas.nGetClipBounds(this.mRenderer, r);
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawPath(Path path, Paint paint) {
        boolean hasModifier = this.setupModifiers(paint);
        if (path.isSimplePath) {
            if (path.rects != null) {
                GLES20Canvas.nDrawRects(this.mRenderer, path.rects.mNativeRegion, paint.mNativePaint);
            }
        } else {
            GLES20Canvas.nDrawPath(this.mRenderer, path.mNativePath, paint.mNativePaint);
        }
        if (hasModifier) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawPath(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawPath(III)V", true, null);
    }

    public static void nDrawRects(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRects(III)V", true, null);
    }

    public void drawPicture(Picture picture) {
        throw new UnsupportedOperationException();
    }

    public void drawPicture(Picture picture, Rect dst) {
        throw new UnsupportedOperationException();
    }

    public void drawPicture(Picture picture, RectF dst) {
        throw new UnsupportedOperationException();
    }

    public void drawPoint(float x, float y, Paint paint) {
        this.mPoint[0] = x;
        this.mPoint[1] = y;
        this.drawPoints(this.mPoint, 0, 1, paint);
    }

    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
    }

    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length / 2, paint);
    }

    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
    }

    public void drawPosText(String text, float[] pos, Paint paint) {
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        boolean hasModifier = this.setupModifiers(paint);
        GLES20Canvas.nDrawRect(this.mRenderer, left, top, right, bottom, paint.mNativePaint);
        if (hasModifier) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawRect(int n, float f, float f2, float f3, float f4, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRect(IFFFFI)V", true, null);
    }

    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(RectF r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRGB(int r, int g, int b) {
        this.drawColor(0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        boolean hasModifier = this.setupModifiers(paint);
        GLES20Canvas.nDrawRoundRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint.mNativePaint);
        if (hasModifier) {
            GLES20Canvas.nResetModifiers(this.mRenderer);
        }
    }

    public static void nDrawRoundRect(int n, float f, float f2, float f3, float f4, float f5, float f6, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawRoundRect(IFFFFFFI)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        boolean hasModifier = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, index, count, x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (hasModifier) {
                GLES20Canvas.nResetModifiers(this.mRenderer);
            }
        }
    }

    public static void nDrawText(int n, char[] cArray, int n2, int n3, float f, float f2, int n4, int n5) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawText(I[CIIFFII)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        boolean hasModifier = this.setupModifiers(paint);
        try {
            if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
                GLES20Canvas.nDrawText(this.mRenderer, ((Object)text).toString(), start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
            } else if (text instanceof GraphicsOperations) {
                ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
            } else {
                char[] buf = TemporaryBuffer.obtain(end - start);
                TextUtils.getChars(text, start, end, buf, 0);
                GLES20Canvas.nDrawText(this.mRenderer, buf, 0, end - start, x, y, paint.mBidiFlags, paint.mNativePaint);
                TemporaryBuffer.recycle(buf);
            }
        }
        finally {
            if (hasModifier) {
                GLES20Canvas.nResetModifiers(this.mRenderer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        boolean hasModifier = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (hasModifier) {
                GLES20Canvas.nResetModifiers(this.mRenderer);
            }
        }
    }

    public static void nDrawText(int n, String string2, int n2, int n3, float f, float f2, int n4, int n5) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawText(ILjava/lang/String;IIFFII)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String text, float x, float y, Paint paint) {
        boolean hasModifier = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, 0, text.length(), x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (hasModifier) {
                GLES20Canvas.nResetModifiers(this.mRenderer);
            }
        }
    }

    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
    }

    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, int dir, Paint paint) {
        if ((index | count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (dir != 0 && dir != 1) {
            throw new IllegalArgumentException("Unknown direction: " + dir);
        }
        boolean hasModifier = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextRun(this.mRenderer, text, index, count, contextIndex, contextCount, x, y, dir, paint.mNativePaint);
        }
        finally {
            if (hasModifier) {
                GLES20Canvas.nResetModifiers(this.mRenderer);
            }
        }
    }

    public static void nDrawTextRun(int n, char[] cArray, int n2, int n3, int n4, int n5, float f, float f2, int n6, int n7) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextRun(I[CIIIIFFII)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, int dir, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        boolean hasModifier = this.setupModifiers(paint);
        try {
            int flags;
            int n = flags = dir == 0 ? 0 : 1;
            if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
                GLES20Canvas.nDrawTextRun(this.mRenderer, ((Object)text).toString(), start, end, contextStart, contextEnd, x, y, flags, paint.mNativePaint);
            } else if (text instanceof GraphicsOperations) {
                ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, flags, paint);
            } else {
                int contextLen = contextEnd - contextStart;
                int len = end - start;
                char[] buf = TemporaryBuffer.obtain(contextLen);
                TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
                GLES20Canvas.nDrawTextRun(this.mRenderer, buf, start - contextStart, len, 0, contextLen, x, y, flags, paint.mNativePaint);
                TemporaryBuffer.recycle(buf);
            }
        }
        finally {
            if (hasModifier) {
                GLES20Canvas.nResetModifiers(this.mRenderer);
            }
        }
    }

    public static void nDrawTextRun(int n, String string2, int n2, int n3, int n4, int n5, float f, float f2, int n6, int n7) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nDrawTextRun(ILjava/lang/String;IIIIFFII)V", true, null);
    }

    public void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
    }

    public boolean setupModifiers(Paint paint) {
        ColorFilter filter;
        Shader shader;
        boolean hasModifier = false;
        if (paint.hasShadow) {
            GLES20Canvas.nSetupShadow(this.mRenderer, paint.shadowRadius, paint.shadowDx, paint.shadowDy, paint.shadowColor);
            hasModifier = true;
        }
        if ((shader = paint.getShader()) != null) {
            GLES20Canvas.nSetupShader(this.mRenderer, shader.native_shader);
            hasModifier = true;
        }
        if ((filter = paint.getColorFilter()) != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            hasModifier = true;
        }
        return hasModifier;
    }

    public boolean setupColorFilter(Paint paint) {
        ColorFilter filter = paint.getColorFilter();
        if (filter != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            return true;
        }
        return false;
    }

    public static void nSetupShader(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupShader(II)V", true, null);
    }

    public static void nSetupColorFilter(int n, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupColorFilter(II)V", true, null);
    }

    public static void nSetupShadow(int n, float f, float f2, float f3, int n2) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nSetupShadow(IFFFI)V", true, null);
    }

    public static void nResetModifiers(int n) {
        OverrideMethod.invokeV("android.view.GLES20Canvas#nResetModifiers(I)V", true, null);
    }

    public static class CanvasFinalizer {
        public int mRenderer;

        public static CanvasFinalizer getFinalizer(CanvasFinalizer oldFinalizer, int renderer) {
            if (oldFinalizer == null) {
                return new CanvasFinalizer(renderer);
            }
            oldFinalizer.replaceNativeObject(renderer);
            return oldFinalizer;
        }

        public CanvasFinalizer(int renderer) {
            this.mRenderer = renderer;
        }

        public void replaceNativeObject(int newRenderer) {
            if (this.mRenderer != 0 && newRenderer != this.mRenderer) {
                GLES20Canvas.nDestroyRenderer(this.mRenderer);
            }
            this.mRenderer = newRenderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finalize() throws Throwable {
            try {
                this.replaceNativeObject(0);
            }
            finally {
                super.finalize();
            }
        }
    }
}

