/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.view.MotionEvent;
import com.android.tools.layoutlib.create.OverrideMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityTracker
implements Poolable<VelocityTracker> {
    public static final Pool<VelocityTracker> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<VelocityTracker>(){

        @Override
        public VelocityTracker newInstance() {
            return new VelocityTracker(null);
        }

        @Override
        public void onAcquired(VelocityTracker element) {
        }

        @Override
        public void onReleased(VelocityTracker element) {
            element.clear();
        }
    }, 2));
    public static final int ACTIVE_POINTER_ID = -1;
    public int mPtr = VelocityTracker.nativeInitialize();
    public VelocityTracker mNext;

    public static int nativeInitialize() {
        return OverrideMethod.invokeI("android.view.VelocityTracker#nativeInitialize()I", true, null);
    }

    public static void nativeDispose(int n) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeDispose(I)V", true, null);
    }

    public static void nativeClear(int n) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeClear(I)V", true, null);
    }

    public static void nativeAddMovement(int n, MotionEvent motionEvent) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeAddMovement(ILandroid/view/MotionEvent;)V", true, null);
    }

    public static void nativeComputeCurrentVelocity(int n, int n2, float f) {
        OverrideMethod.invokeV("android.view.VelocityTracker#nativeComputeCurrentVelocity(IIF)V", true, null);
    }

    public static float nativeGetXVelocity(int n, int n2) {
        return OverrideMethod.invokeF("android.view.VelocityTracker#nativeGetXVelocity(II)F", true, null);
    }

    public static float nativeGetYVelocity(int n, int n2) {
        return OverrideMethod.invokeF("android.view.VelocityTracker#nativeGetYVelocity(II)F", true, null);
    }

    public static VelocityTracker obtain() {
        return sPool.acquire();
    }

    public void recycle() {
        sPool.release(this);
    }

    @Override
    public void setNextPoolable(VelocityTracker element) {
        this.mNext = element;
    }

    @Override
    public VelocityTracker getNextPoolable() {
        return this.mNext;
    }

    public VelocityTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.mPtr != 0) {
                VelocityTracker.nativeDispose(this.mPtr);
                this.mPtr = 0;
            }
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        VelocityTracker.nativeClear(this.mPtr);
    }

    public void addMovement(MotionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        VelocityTracker.nativeAddMovement(this.mPtr, event);
    }

    public void computeCurrentVelocity(int units) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, Float.MAX_VALUE);
    }

    public void computeCurrentVelocity(int units, float maxVelocity) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, maxVelocity);
    }

    public float getXVelocity() {
        return VelocityTracker.nativeGetXVelocity(this.mPtr, -1);
    }

    public float getYVelocity() {
        return VelocityTracker.nativeGetYVelocity(this.mPtr, -1);
    }

    public float getXVelocity(int id2) {
        return VelocityTracker.nativeGetXVelocity(this.mPtr, id2);
    }

    public float getYVelocity(int id2) {
        return VelocityTracker.nativeGetYVelocity(this.mPtr, id2);
    }

    public /* synthetic */ VelocityTracker(1 x0) {
        this();
    }
}

