/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.webkit.WebView;
import android.webkit.WebViewCore;
import java.util.ArrayList;
import java.util.Stack;

public class AccessibilityInjector {
    public static final String LOG_TAG = "AccessibilityInjector";
    public static final boolean DEBUG = true;
    public static final int ACTION_SET_CURRENT_AXIS = 0;
    public static final int ACTION_TRAVERSE_CURRENT_AXIS = 1;
    public static final int ACTION_TRAVERSE_GIVEN_AXIS = 2;
    public static final int ACTION_PERFORM_AXIS_TRANSITION = 3;
    public static final int ACTION_TRAVERSE_DEFAULT_WEB_VIEW_BEHAVIOR_AXIS = 4;
    public static final int NAVIGATION_AXIS_DEFAULT_WEB_VIEW_BEHAVIOR = 7;
    public static ArrayList<AccessibilityWebContentKeyBinding> sBindings = new ArrayList();
    public final WebView mWebView;
    public final Stack<AccessibilityEvent> mScheduledEventStack = new Stack();
    public int mCurrentAxis = 2;
    public boolean mLastDownEventHandled;
    public boolean mIsLastSelectionStringNull;
    public int mLastDirection;

    public AccessibilityInjector(WebView webView) {
        this.mWebView = webView;
        this.ensureWebContentKeyBindings();
    }

    public boolean onKeyEvent(KeyEvent event) {
        if (this.isEnterActionKey(event.getKeyCode())) {
            return false;
        }
        if (event.getAction() == 1) {
            return this.mLastDownEventHandled;
        }
        this.mLastDownEventHandled = false;
        AccessibilityWebContentKeyBinding binding = null;
        for (AccessibilityWebContentKeyBinding candidate : sBindings) {
            if (event.getKeyCode() != candidate.getKeyCode() || !event.hasModifiers(candidate.getModifiers())) continue;
            binding = candidate;
            break;
        }
        if (binding == null) {
            return false;
        }
        int count = binding.getActionCount();
        block8: for (int i = 0; i < count; ++i) {
            int actionCode = binding.getActionCode(i);
            String contentDescription = Integer.toHexString(binding.getAction(i));
            switch (actionCode) {
                case 0: {
                    int axis = binding.getFirstArgument(i);
                    boolean sendEvent = binding.getSecondArgument(i) == 1;
                    this.setCurrentAxis(axis, sendEvent, contentDescription);
                    this.mLastDownEventHandled = true;
                    continue block8;
                }
                case 1: {
                    int direction = binding.getFirstArgument(i);
                    if (direction == this.mLastDirection && this.mIsLastSelectionStringNull) {
                        this.mIsLastSelectionStringNull = false;
                        return false;
                    }
                    this.mLastDirection = direction;
                    boolean sendEvent = binding.getSecondArgument(i) == 1;
                    this.mLastDownEventHandled = this.traverseCurrentAxis(direction, sendEvent, contentDescription);
                    continue block8;
                }
                case 2: {
                    int direction = binding.getFirstArgument(i);
                    if (direction == this.mLastDirection && this.mIsLastSelectionStringNull) {
                        this.mIsLastSelectionStringNull = false;
                        return false;
                    }
                    this.mLastDirection = direction;
                    int axis = binding.getSecondArgument(i);
                    boolean sendEvent = binding.getThirdArgument(i) == 1;
                    this.traverseGivenAxis(direction, axis, sendEvent, contentDescription);
                    this.mLastDownEventHandled = true;
                    continue block8;
                }
                case 3: {
                    int fromAxis = binding.getFirstArgument(i);
                    int toAxis = binding.getSecondArgument(i);
                    boolean sendEvent = binding.getThirdArgument(i) == 1;
                    this.prefromAxisTransition(fromAxis, toAxis, sendEvent, contentDescription);
                    this.mLastDownEventHandled = true;
                    continue block8;
                }
                case 4: {
                    boolean sendEvent;
                    if (this.mCurrentAxis == 7) {
                        this.mLastDirection = binding.getFirstArgument(i);
                        sendEvent = binding.getSecondArgument(i) == 1;
                        this.traverseGivenAxis(this.mLastDirection, 7, sendEvent, contentDescription);
                        this.mLastDownEventHandled = false;
                        continue block8;
                    }
                    this.mLastDownEventHandled = true;
                    continue block8;
                }
                default: {
                    Log.w(LOG_TAG, "Unknown action code: " + actionCode);
                }
            }
        }
        return this.mLastDownEventHandled;
    }

    public void setCurrentAxis(int axis, boolean sendEvent, String contentDescription) {
        this.mCurrentAxis = axis;
        if (sendEvent) {
            AccessibilityEvent event = this.getPartialyPopulatedAccessibilityEvent();
            event.getText().add(String.valueOf(axis));
            event.setContentDescription(contentDescription);
            this.sendAccessibilityEvent(event);
        }
    }

    public void prefromAxisTransition(int fromAxis, int toAxis, boolean sendEvent, String contentDescription) {
        if (this.mCurrentAxis == fromAxis) {
            this.setCurrentAxis(toAxis, sendEvent, contentDescription);
        }
    }

    public boolean traverseCurrentAxis(int direction, boolean sendEvent, String contentDescription) {
        return this.traverseGivenAxis(direction, this.mCurrentAxis, sendEvent, contentDescription);
    }

    public boolean traverseGivenAxis(int direction, int axis, boolean sendEvent, String contentDescription) {
        WebViewCore webViewCore = this.mWebView.getWebViewCore();
        if (webViewCore == null) {
            return false;
        }
        AccessibilityEvent event = null;
        if (sendEvent) {
            event = this.getPartialyPopulatedAccessibilityEvent();
            event.setContentDescription(contentDescription);
        }
        this.mScheduledEventStack.push(event);
        if (axis == 7) {
            return false;
        }
        webViewCore.sendMessage(190, direction, axis);
        return true;
    }

    public void onSelectionStringChange(String selectionString) {
        Log.d(LOG_TAG, "Selection string: " + selectionString);
        boolean bl = this.mIsLastSelectionStringNull = selectionString == null;
        if (this.mScheduledEventStack.isEmpty()) {
            return;
        }
        AccessibilityEvent event = this.mScheduledEventStack.pop();
        if (event != null) {
            event.getText().add(selectionString);
            this.sendAccessibilityEvent(event);
        }
    }

    public void sendAccessibilityEvent(AccessibilityEvent event) {
        Log.d(LOG_TAG, "Dispatching: " + event);
        AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(this.mWebView.getContext());
        if (accessibilityManager.isEnabled()) {
            accessibilityManager.sendAccessibilityEvent(event);
        }
    }

    public AccessibilityEvent getPartialyPopulatedAccessibilityEvent() {
        AccessibilityEvent event = AccessibilityEvent.obtain(4);
        event.setClassName(this.mWebView.getClass().getName());
        event.setPackageName(this.mWebView.getContext().getPackageName());
        event.setEnabled(this.mWebView.isEnabled());
        return event;
    }

    public void ensureWebContentKeyBindings() {
        if (sBindings.size() > 0) {
            return;
        }
        String webContentKeyBindingsString = Settings.Secure.getString(this.mWebView.getContext().getContentResolver(), "accessibility_web_content_key_bindings");
        TextUtils.SimpleStringSplitter semiColonSplitter = new TextUtils.SimpleStringSplitter(';');
        semiColonSplitter.setString(webContentKeyBindingsString);
        while (semiColonSplitter.hasNext()) {
            String bindingString = semiColonSplitter.next();
            if (TextUtils.isEmpty(bindingString)) {
                Log.e(LOG_TAG, "Disregarding malformed Web content key binding: " + webContentKeyBindingsString);
                continue;
            }
            String[] keyValueArray = bindingString.split("=");
            if (keyValueArray.length != 2) {
                Log.e(LOG_TAG, "Disregarding malformed Web content key binding: " + bindingString);
                continue;
            }
            try {
                long keyCodeAndModifiers = Long.decode(keyValueArray[0].trim());
                String[] actionStrings = keyValueArray[1].split(":");
                int[] actions = new int[actionStrings.length];
                int count = actions.length;
                for (int i = 0; i < count; ++i) {
                    actions[i] = Integer.decode(actionStrings[i].trim());
                }
                sBindings.add(new AccessibilityWebContentKeyBinding(keyCodeAndModifiers, actions));
            }
            catch (NumberFormatException nfe) {
                Log.e(LOG_TAG, "Disregarding malformed key binding: " + bindingString);
            }
        }
    }

    public boolean isEnterActionKey(int keyCode) {
        return keyCode == 23 || keyCode == 66 || keyCode == 160;
    }

    public static class AccessibilityWebContentKeyBinding {
        public static final int MODIFIERS_OFFSET = 32;
        public static final long MODIFIERS_MASK = 0xFFFFFFF00000000L;
        public static final int KEY_CODE_OFFSET = 0;
        public static final long KEY_CODE_MASK = 0xFFFFFFFFL;
        public static final int ACTION_OFFSET = 24;
        public static final int ACTION_MASK = -16777216;
        public static final int FIRST_ARGUMENT_OFFSET = 16;
        public static final int FIRST_ARGUMENT_MASK = 0xFF0000;
        public static final int SECOND_ARGUMENT_OFFSET = 8;
        public static final int SECOND_ARGUMENT_MASK = 65280;
        public static final int THIRD_ARGUMENT_OFFSET = 0;
        public static final int THIRD_ARGUMENT_MASK = 255;
        public final long mKeyCodeAndModifiers;
        public final int[] mActionSequence;

        public int getKeyCode() {
            return (int)((this.mKeyCodeAndModifiers & 0xFFFFFFFFL) >> 0);
        }

        public int getModifiers() {
            return (int)((this.mKeyCodeAndModifiers & 0xFFFFFFF00000000L) >> 32);
        }

        public int getActionCount() {
            return this.mActionSequence.length;
        }

        public int getAction(int index) {
            return this.mActionSequence[index];
        }

        public int getActionCode(int index) {
            return (this.mActionSequence[index] & 0xFF000000) >> 24;
        }

        public int getFirstArgument(int index) {
            return (this.mActionSequence[index] & 0xFF0000) >> 16;
        }

        public int getSecondArgument(int index) {
            return (this.mActionSequence[index] & 0xFF00) >> 8;
        }

        public int getThirdArgument(int index) {
            return (this.mActionSequence[index] & 0xFF) >> 0;
        }

        public AccessibilityWebContentKeyBinding(long keyCodeAndModifiers, int[] actionSequence) {
            this.mKeyCodeAndModifiers = keyCodeAndModifiers;
            this.mActionSequence = actionSequence;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("modifiers: ");
            builder.append(this.getModifiers());
            builder.append(", keyCode: ");
            builder.append(this.getKeyCode());
            builder.append(", actions[");
            int count = this.getActionCount();
            for (int i = 0; i < count; ++i) {
                builder.append("{actionCode");
                builder.append(i);
                builder.append(": ");
                builder.append(this.getActionCode(i));
                builder.append(", firstArgument: ");
                builder.append(this.getFirstArgument(i));
                builder.append(", secondArgument: ");
                builder.append(this.getSecondArgument(i));
                builder.append(", thirdArgument: ");
                builder.append(this.getThirdArgument(i));
                builder.append("}");
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

