/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.http.AndroidHttpClient;
import android.net.http.Headers;
import android.os.FileUtils;
import android.util.Log;
import android.webkit.JniUtil;
import android.webkit.WebViewDatabase;
import android.webkit.WebViewWorker;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CacheManager {
    public static final String LOGTAG = "cache";
    public static final String HEADER_KEY_IFMODIFIEDSINCE = "if-modified-since";
    public static final String HEADER_KEY_IFNONEMATCH = "if-none-match";
    public static final String NO_STORE = "no-store";
    public static final String NO_CACHE = "no-cache";
    public static final String MAX_AGE = "max-age";
    public static final String MANIFEST_MIME = "text/cache-manifest";
    public static long CACHE_THRESHOLD = 0x600000L;
    public static long CACHE_TRIM_AMOUNT = 0x200000L;
    public static long CACHE_MAX_SIZE = (CACHE_THRESHOLD - CACHE_TRIM_AMOUNT) / 2L;
    public static boolean mDisabled;
    public static int mRefCount;
    public static int mTrimCacheCount;
    public static final int TRIM_CACHE_INTERVAL = 5;
    public static WebViewDatabase mDataBase;
    public static File mBaseDir;
    public static boolean mClearCacheOnInit;

    public static void init(Context context) {
        if (JniUtil.useChromiumHttpStack()) {
            mBaseDir = new File(context.getCacheDir(), "webviewCacheChromiumStaging");
            if (!mBaseDir.exists()) {
                mBaseDir.mkdirs();
            }
            return;
        }
        mDataBase = WebViewDatabase.getInstance(context.getApplicationContext());
        mBaseDir = new File(context.getCacheDir(), "webviewCache");
        if (CacheManager.createCacheDirectory() && mClearCacheOnInit) {
            CacheManager.removeAllCacheFiles();
            mClearCacheOnInit = false;
        }
    }

    public static boolean createCacheDirectory() {
        assert (!JniUtil.useChromiumHttpStack());
        if (!mBaseDir.exists()) {
            if (!mBaseDir.mkdirs()) {
                Log.w(LOGTAG, "Unable to create webviewCache directory");
                return false;
            }
            FileUtils.setPermissions(mBaseDir.toString(), 504, -1, -1);
            WebViewWorker.getHandler().sendEmptyMessage(109);
            return true;
        }
        return false;
    }

    @Deprecated
    public static File getCacheFileBaseDir() {
        return mBaseDir;
    }

    public static void setCacheDisabled(boolean disabled) {
        assert (!JniUtil.useChromiumHttpStack());
        if (disabled == mDisabled) {
            return;
        }
        mDisabled = disabled;
        if (mDisabled) {
            CacheManager.removeAllCacheFiles();
        }
    }

    @Deprecated
    public static boolean cacheDisabled() {
        return mDisabled;
    }

    public static boolean enableTransaction() {
        assert (!JniUtil.useChromiumHttpStack());
        if (++mRefCount == 1) {
            mDataBase.startCacheTransaction();
            return true;
        }
        return false;
    }

    public static boolean disableTransaction() {
        assert (!JniUtil.useChromiumHttpStack());
        if (--mRefCount == 0) {
            mDataBase.endCacheTransaction();
            return true;
        }
        return false;
    }

    public static boolean startTransaction() {
        assert (!JniUtil.useChromiumHttpStack());
        return mDataBase.startCacheTransaction();
    }

    public static boolean endTransaction() {
        assert (!JniUtil.useChromiumHttpStack());
        boolean ret = mDataBase.endCacheTransaction();
        if (++mTrimCacheCount >= 5) {
            mTrimCacheCount = 0;
            CacheManager.trimCacheIfNeeded();
        }
        return ret;
    }

    @Deprecated
    public static boolean startCacheTransaction() {
        return false;
    }

    @Deprecated
    public static boolean endCacheTransaction() {
        return false;
    }

    @Deprecated
    public static CacheResult getCacheFile(String url, Map<String, String> headers) {
        return CacheManager.getCacheFile(url, 0L, headers);
    }

    public static CacheResult getCacheFile(String url, long postIdentifier, Map<String, String> headers) {
        if (mDisabled) {
            return null;
        }
        if (JniUtil.useChromiumHttpStack()) {
            CacheResult result = CacheManager.nativeGetCacheResult(url);
            if (result == null) {
                return null;
            }
            File src = new File(mBaseDir, result.localPath);
            try {
                result.inStream = new FileInputStream(src);
            }
            catch (FileNotFoundException e) {
                Log.v(LOGTAG, "getCacheFile(): Failed to open file: " + e);
                return null;
            }
            return result;
        }
        String databaseKey = CacheManager.getDatabaseKey(url, postIdentifier);
        CacheResult result = mDataBase.getCache(databaseKey);
        if (result == null) {
            return null;
        }
        if (result.contentLength == 0L) {
            if (!CacheManager.isCachableRedirect(result.httpStatusCode)) {
                mDataBase.removeCache(databaseKey);
                return null;
            }
        } else {
            File src = new File(mBaseDir, result.localPath);
            try {
                result.inStream = new FileInputStream(src);
            }
            catch (FileNotFoundException e) {
                mDataBase.removeCache(databaseKey);
                return null;
            }
        }
        if (headers != null && result.expires >= 0L && result.expires <= System.currentTimeMillis()) {
            if (result.lastModified == null && result.etag == null) {
                return null;
            }
            if (result.etag != null) {
                headers.put(HEADER_KEY_IFNONEMATCH, result.etag);
            }
            if (result.lastModified != null) {
                headers.put(HEADER_KEY_IFMODIFIEDSINCE, result.lastModified);
            }
        }
        return result;
    }

    @Deprecated
    public static CacheResult createCacheFile(String url, int statusCode, Headers headers, String mimeType, boolean forceCache) {
        if (JniUtil.useChromiumHttpStack()) {
            return null;
        }
        return CacheManager.createCacheFile(url, statusCode, headers, mimeType, 0L, forceCache);
    }

    public static CacheResult createCacheFile(String url, int statusCode, Headers headers, String mimeType, long postIdentifier, boolean forceCache) {
        assert (!JniUtil.useChromiumHttpStack());
        if (!forceCache && mDisabled) {
            return null;
        }
        String databaseKey = CacheManager.getDatabaseKey(url, postIdentifier);
        if (statusCode == 303) {
            mDataBase.removeCache(databaseKey);
            return null;
        }
        if (CacheManager.isCachableRedirect(statusCode) && !headers.getSetCookie().isEmpty()) {
            mDataBase.removeCache(databaseKey);
            return null;
        }
        CacheResult ret = CacheManager.parseHeaders(statusCode, headers, mimeType);
        if (ret == null) {
            mDataBase.removeCache(databaseKey);
        } else {
            CacheManager.setupFiles(databaseKey, ret);
            try {
                ret.outStream = new FileOutputStream(ret.outFile);
            }
            catch (FileNotFoundException e) {
                if (CacheManager.createCacheDirectory()) {
                    try {
                        ret.outStream = new FileOutputStream(ret.outFile);
                    }
                    catch (FileNotFoundException e2) {
                        return null;
                    }
                }
                return null;
            }
            ret.mimeType = mimeType;
        }
        return ret;
    }

    @Deprecated
    public static void saveCacheFile(String url, CacheResult cacheRet) {
        CacheManager.saveCacheFile(url, 0L, cacheRet);
    }

    public static void saveCacheFile(String url, long postIdentifier, CacheResult cacheRet) {
        try {
            cacheRet.outStream.close();
        }
        catch (IOException e) {
            return;
        }
        if (JniUtil.useChromiumHttpStack()) assert (false);
        if (!cacheRet.outFile.exists()) {
            return;
        }
        boolean redirect = CacheManager.isCachableRedirect(cacheRet.httpStatusCode);
        if (redirect) {
            cacheRet.contentLength = 0L;
            cacheRet.localPath = "";
        }
        if ((redirect || cacheRet.contentLength == 0L) && !cacheRet.outFile.delete()) {
            Log.e(LOGTAG, cacheRet.outFile.getPath() + " delete failed.");
        }
        if (cacheRet.contentLength == 0L) {
            return;
        }
        mDataBase.addCache(CacheManager.getDatabaseKey(url, postIdentifier), cacheRet);
    }

    public static boolean cleanupCacheFile(CacheResult cacheRet) {
        assert (!JniUtil.useChromiumHttpStack());
        try {
            cacheRet.outStream.close();
        }
        catch (IOException e) {
            return false;
        }
        return cacheRet.outFile.delete();
    }

    public static boolean removeAllCacheFiles() {
        if (mBaseDir == null) {
            assert (!JniUtil.useChromiumHttpStack());
            mClearCacheOnInit = true;
            return true;
        }
        if (!JniUtil.useChromiumHttpStack()) {
            WebViewWorker.getHandler().sendEmptyMessage(109);
        }
        Runnable clearCache = new Runnable(){

            public void run() {
                try {
                    String[] files = mBaseDir.list();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            File f = new File(mBaseDir, files[i]);
                            if (f.delete()) continue;
                            Log.e(CacheManager.LOGTAG, f.getPath() + " delete failed.");
                        }
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        };
        new Thread(clearCache).start();
        return true;
    }

    public static void trimCacheIfNeeded() {
        assert (!JniUtil.useChromiumHttpStack());
        if (mDataBase.getCacheTotalSize() > CACHE_THRESHOLD) {
            List<String> pathList = mDataBase.trimCache(CACHE_TRIM_AMOUNT);
            int size = pathList.size();
            for (int i = 0; i < size; ++i) {
                File f = new File(mBaseDir, pathList.get(i));
                if (f.delete()) continue;
                Log.e(LOGTAG, f.getPath() + " delete failed.");
            }
            final List<String> fileList = mDataBase.getAllCacheFileNames();
            if (fileList == null) {
                return;
            }
            String[] toDelete = mBaseDir.list(new FilenameFilter(){

                public boolean accept(File dir, String filename) {
                    return !fileList.contains(filename);
                }
            });
            if (toDelete == null) {
                return;
            }
            size = toDelete.length;
            for (int i = 0; i < size; ++i) {
                File f = new File(mBaseDir, toDelete[i]);
                if (f.delete()) continue;
                Log.e(LOGTAG, f.getPath() + " delete failed.");
            }
        }
    }

    public static void clearCache() {
        assert (!JniUtil.useChromiumHttpStack());
        mDataBase.clearCache();
    }

    public static boolean isCachableRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 307;
    }

    public static String getDatabaseKey(String url, long postIdentifier) {
        assert (!JniUtil.useChromiumHttpStack());
        if (postIdentifier == 0L) {
            return url;
        }
        return postIdentifier + url;
    }

    public static void setupFiles(String url, CacheResult cacheRet) {
        assert (!JniUtil.useChromiumHttpStack());
        int hashCode = url.hashCode();
        StringBuffer ret = new StringBuffer(8);
        CacheManager.appendAsHex(hashCode, ret);
        String path = ret.toString();
        File file = new File(mBaseDir, path);
        boolean checkOldPath = true;
        while (file.exists()) {
            if (checkOldPath) {
                CacheResult oldResult = mDataBase.getCache(url);
                if (oldResult != null && oldResult.contentLength > 0L) {
                    if (path.equals(oldResult.localPath)) {
                        path = oldResult.localPath;
                        break;
                    }
                    path = oldResult.localPath;
                    file = new File(mBaseDir, path);
                    break;
                }
                checkOldPath = false;
            }
            ret = new StringBuffer(8);
            CacheManager.appendAsHex(++hashCode, ret);
            path = ret.toString();
            file = new File(mBaseDir, path);
        }
        cacheRet.localPath = path;
        cacheRet.outFile = file;
    }

    public static void appendAsHex(int i, StringBuffer ret) {
        assert (!JniUtil.useChromiumHttpStack());
        String hex = Integer.toHexString(i);
        switch (hex.length()) {
            case 1: {
                ret.append("0000000");
                break;
            }
            case 2: {
                ret.append("000000");
                break;
            }
            case 3: {
                ret.append("00000");
                break;
            }
            case 4: {
                ret.append("0000");
                break;
            }
            case 5: {
                ret.append("000");
                break;
            }
            case 6: {
                ret.append("00");
                break;
            }
            case 7: {
                ret.append("0");
            }
        }
        ret.append(hex);
    }

    public static CacheResult parseHeaders(int statusCode, Headers headers, String mimeType) {
        String cacheControl;
        String etag;
        assert (!JniUtil.useChromiumHttpStack());
        if (headers.getContentLength() > CACHE_MAX_SIZE) {
            return null;
        }
        if (MANIFEST_MIME.equals(mimeType)) {
            return null;
        }
        CacheResult ret = new CacheResult();
        ret.httpStatusCode = statusCode;
        ret.location = headers.getLocation();
        ret.expires = -1L;
        ret.expiresString = headers.getExpires();
        if (ret.expiresString != null) {
            try {
                ret.expires = AndroidHttpClient.parseDate(ret.expiresString);
            }
            catch (IllegalArgumentException ex) {
                if ("-1".equals(ret.expiresString) || "0".equals(ret.expiresString)) {
                    ret.expires = 0L;
                }
                Log.e(LOGTAG, "illegal expires: " + ret.expiresString);
            }
        }
        ret.contentdisposition = headers.getContentDisposition();
        ret.crossDomain = headers.getXPermittedCrossDomainPolicies();
        String lastModified = headers.getLastModified();
        if (lastModified != null && lastModified.length() > 0) {
            ret.lastModified = lastModified;
        }
        if ((etag = headers.getEtag()) != null && etag.length() > 0) {
            ret.etag = etag;
        }
        if ((cacheControl = headers.getCacheControl()) != null) {
            String[] controls = cacheControl.toLowerCase().split("[ ,;]");
            for (int i = 0; i < controls.length; ++i) {
                if (NO_STORE.equals(controls[i])) {
                    return null;
                }
                if (NO_CACHE.equals(controls[i])) {
                    ret.expires = 0L;
                    continue;
                }
                if (!controls[i].startsWith(MAX_AGE)) continue;
                int separator = controls[i].indexOf(61);
                if (separator < 0) {
                    separator = controls[i].indexOf(58);
                }
                if (separator <= 0) continue;
                String s = controls[i].substring(separator + 1);
                try {
                    long sec = Long.parseLong(s);
                    if (sec < 0L) continue;
                    ret.expires = System.currentTimeMillis() + 1000L * sec;
                    continue;
                }
                catch (NumberFormatException ex) {
                    if ("1d".equals(s)) {
                        ret.expires = System.currentTimeMillis() + 86400000L;
                        continue;
                    }
                    Log.e(LOGTAG, "exception in parseHeaders for max-age:" + controls[i].substring(separator + 1));
                    ret.expires = 0L;
                }
            }
        }
        if (NO_CACHE.equals(headers.getPragma())) {
            ret.expires = 0L;
        }
        if (ret.expires == -1L) {
            if (ret.httpStatusCode == 301) {
                ret.expires = Long.MAX_VALUE;
            } else if (ret.httpStatusCode == 302 || ret.httpStatusCode == 307) {
                ret.expires = 0L;
            } else if (ret.lastModified == null) {
                ret.expires = !mimeType.startsWith("text/html") ? System.currentTimeMillis() + 86400000L : 0L;
            } else {
                long lastmod = System.currentTimeMillis() + 86400000L;
                try {
                    lastmod = AndroidHttpClient.parseDate(ret.lastModified);
                }
                catch (IllegalArgumentException ex) {
                    Log.e(LOGTAG, "illegal lastModified: " + ret.lastModified);
                }
                long difference = System.currentTimeMillis() - lastmod;
                ret.expires = difference > 0L ? System.currentTimeMillis() + difference / 5L : lastmod;
            }
        }
        return ret;
    }

    public static CacheResult nativeGetCacheResult(String string2) {
        return (CacheResult)OverrideMethod.invokeA("android.webkit.CacheManager#nativeGetCacheResult(Ljava/lang/String;)Landroid/webkit/CacheManager$CacheResult;", true, null);
    }

    static {
        mTrimCacheCount = 0;
        mClearCacheOnInit = false;
    }

    @Deprecated
    public static class CacheResult {
        public int httpStatusCode;
        public long contentLength;
        public long expires;
        public String expiresString;
        public String localPath;
        public String lastModified;
        public String etag;
        public String mimeType;
        public String location;
        public String encoding;
        public String contentdisposition;
        public String crossDomain;
        public InputStream inStream;
        public OutputStream outStream;
        public File outFile;

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public long getExpires() {
            return this.expires;
        }

        public String getExpiresString() {
            return this.expiresString;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getETag() {
            return this.etag;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public String getContentDisposition() {
            return this.contentdisposition;
        }

        public InputStream getInputStream() {
            return this.inStream;
        }

        public OutputStream getOutputStream() {
            return this.outStream;
        }

        public void setInputStream(InputStream stream) {
            this.inStream = stream;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setContentLength(long contentLength) {
            this.contentLength = contentLength;
        }
    }
}

