/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.res.Resources;
import android.text.Editable;
import android.text.Selection;
import android.text.TextWatcher;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;

public class FindActionModeCallback
implements ActionMode.Callback,
TextWatcher,
View.OnLongClickListener,
View.OnClickListener {
    public View mCustomView;
    public EditText mEditText;
    public TextView mMatches;
    public WebView mWebView;
    public InputMethodManager mInput;
    public Resources mResources;
    public boolean mMatchesFound;
    public int mNumberOfMatches;
    public ActionMode mActionMode;

    public FindActionModeCallback(Context context) {
        this.mCustomView = LayoutInflater.from(context).inflate(17367200, null);
        this.mEditText = (EditText)this.mCustomView.findViewById(16908291);
        this.mEditText.setOnLongClickListener(this);
        this.mEditText.setOnClickListener(this);
        this.setText("");
        this.mMatches = (TextView)this.mCustomView.findViewById(16909016);
        this.mInput = (InputMethodManager)context.getSystemService("input_method");
        this.mResources = context.getResources();
    }

    public void finish() {
        this.mActionMode.finish();
    }

    public void setText(String text) {
        this.mEditText.setText(text);
        Editable span = this.mEditText.getText();
        int length = span.length();
        Selection.setSelection(span, length, length);
        span.setSpan(this, 0, length, 18);
        this.mMatchesFound = false;
    }

    public void setWebView(WebView webView) {
        if (null == webView) {
            throw new AssertionError((Object)"WebView supplied to FindActionModeCallback cannot be null");
        }
        this.mWebView = webView;
    }

    public void findNext(boolean next) {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindActionModeCallback::findNext");
        }
        if (!this.mMatchesFound) {
            this.findAll();
            return;
        }
        if (0 == this.mNumberOfMatches) {
            return;
        }
        this.mWebView.findNext(next);
        this.updateMatchesString();
    }

    public void findAll() {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindActionModeCallback::findAll");
        }
        Editable find = this.mEditText.getText();
        if (0 == find.length()) {
            this.mWebView.clearMatches();
            this.mMatches.setVisibility(8);
            this.mMatchesFound = false;
        } else {
            this.mMatchesFound = true;
            this.mMatches.setVisibility(0);
            this.mNumberOfMatches = this.mWebView.findAll(find.toString());
            if (0 == this.mNumberOfMatches) {
                this.mMatches.setText(this.mResources.getString(17040342));
            } else {
                this.updateMatchesString();
            }
        }
    }

    public void showSoftInput() {
        this.mInput.startGettingWindowFocus(this.mEditText.getRootView());
        this.mInput.focusIn(this.mEditText);
        this.mInput.showSoftInput(this.mEditText, 0);
    }

    public void updateMatchesString() {
        String template = this.mResources.getQuantityString(0x1130013, this.mNumberOfMatches, this.mWebView.findIndex() + 1, this.mNumberOfMatches);
        this.mMatches.setText(template);
    }

    public boolean onLongClick(View v) {
        return true;
    }

    public void onClick(View v) {
        this.findNext(true);
    }

    public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
        mode.setCustomView(this.mCustomView);
        mode.getMenuInflater().inflate(0x1140001, menu2);
        this.mActionMode = mode;
        Editable edit = this.mEditText.getText();
        Selection.setSelection(edit, edit.length());
        this.mMatches.setVisibility(8);
        this.mMatchesFound = false;
        this.mMatches.setText("0");
        this.mEditText.requestFocus();
        return true;
    }

    public void onDestroyActionMode(ActionMode mode) {
        this.mWebView.notifyFindDialogDismissed();
        this.mInput.hideSoftInputFromWindow(this.mWebView.getWindowToken(), 0);
    }

    public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
        return false;
    }

    public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindActionModeCallback::onActionItemClicked");
        }
        this.mInput.hideSoftInputFromWindow(this.mWebView.getWindowToken(), 0);
        switch (item.getItemId()) {
            case 16909028: {
                this.findNext(false);
                break;
            }
            case 16909029: {
                this.findNext(true);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.findAll();
    }

    public void afterTextChanged(Editable s) {
    }
}

