/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.webkit.CookieManager;
import android.webkit.HTML5VideoViewProxy;
import android.webkit.WebView;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTML5VideoView
implements MediaPlayer.OnPreparedListener {
    public static final String LOGTAG = "HTML5VideoView";
    public static final String COOKIE = "Cookie";
    public static final String HIDE_URL_LOGS = "x-hide-urls-from-log";
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_NOTPREPARED = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_PLAYING = 3;
    public int mCurrentState;
    public HTML5VideoViewProxy mProxy;
    public int mSaveSeekTime;
    public int mVideoLayerId;
    public MediaPlayer mPlayer;
    public boolean mAutostart;
    public Uri mUri;
    public Map<String, String> mHeaders;
    public static Timer mTimer;
    public static final int TIMEUPDATE_PERIOD = 250;
    public boolean mPauseDuringPreparing;
    public boolean mPlayerBuffering = false;

    public void start() {
        if (this.mCurrentState == 2) {
            if (mTimer == null) {
                mTimer = new Timer();
                mTimer.schedule((TimerTask)new TimeupdateTask(this.mProxy), 250L, 250L);
            }
            this.mPlayer.start();
            this.setPlayerBuffering(false);
        }
    }

    public void pause() {
        if (this.mCurrentState == 2 && this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
        } else if (this.mCurrentState == 1) {
            this.mPauseDuringPreparing = true;
        }
        if (mTimer != null) {
            mTimer.purge();
            mTimer.cancel();
            mTimer = null;
        }
    }

    public int getDuration() {
        if (this.mCurrentState == 2) {
            return this.mPlayer.getDuration();
        }
        return -1;
    }

    public int getCurrentPosition() {
        if (this.mCurrentState == 2) {
            return this.mPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int pos) {
        if (this.mCurrentState == 2) {
            this.mPlayer.seekTo(pos);
        } else {
            this.mSaveSeekTime = pos;
        }
    }

    public boolean isPlaying() {
        return this.mPlayer.isPlaying();
    }

    public void release() {
        this.mPlayer.release();
    }

    public void stopPlayback() {
        if (this.mCurrentState == 2) {
            this.mPlayer.stop();
        }
    }

    public boolean getAutostart() {
        return this.mAutostart;
    }

    public boolean getPauseDuringPreparing() {
        return this.mPauseDuringPreparing;
    }

    public void init(int videoLayerId, int position, boolean autoStart) {
        this.mPlayer = new MediaPlayer();
        this.mCurrentState = 0;
        this.mProxy = null;
        this.mVideoLayerId = videoLayerId;
        this.mSaveSeekTime = position;
        this.mAutostart = autoStart;
        mTimer = null;
        this.mPauseDuringPreparing = false;
    }

    public static Map<String, String> generateHeaders(String url, HTML5VideoViewProxy proxy) {
        boolean isPrivate = proxy.getWebView().isPrivateBrowsingEnabled();
        String cookieValue = CookieManager.getInstance().getCookie(url, isPrivate);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (cookieValue != null) {
            headers.put(COOKIE, cookieValue);
        }
        if (isPrivate) {
            headers.put(HIDE_URL_LOGS, "true");
        }
        return headers;
    }

    public void setVideoURI(String uri, HTML5VideoViewProxy proxy) {
        this.mUri = Uri.parse(uri);
        this.mHeaders = HTML5VideoView.generateHeaders(uri, proxy);
    }

    public void setOnCompletionListener(HTML5VideoViewProxy proxy) {
        this.mPlayer.setOnCompletionListener(proxy);
    }

    public void setOnErrorListener(HTML5VideoViewProxy proxy) {
        this.mPlayer.setOnErrorListener(proxy);
    }

    public void setOnPreparedListener(HTML5VideoViewProxy proxy) {
        this.mProxy = proxy;
        this.mPlayer.setOnPreparedListener(this);
    }

    public void setOnInfoListener(HTML5VideoViewProxy proxy) {
        this.mPlayer.setOnInfoListener(proxy);
    }

    public void prepareDataAndDisplayMode(HTML5VideoViewProxy proxy) {
        this.decideDisplayMode();
        this.setOnCompletionListener(proxy);
        this.setOnPreparedListener(proxy);
        this.setOnErrorListener(proxy);
        this.setOnInfoListener(proxy);
        try {
            this.mPlayer.setDataSource(this.mProxy.getContext(), this.mUri, this.mHeaders);
            this.mPlayer.prepareAsync();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mCurrentState = 1;
    }

    public int getVideoLayerId() {
        return this.mVideoLayerId;
    }

    public int getCurrentState() {
        if (this.mPlayer.isPlaying()) {
            return 3;
        }
        return this.mCurrentState;
    }

    @Override
    public void onPrepared(MediaPlayer mp) {
        this.mCurrentState = 2;
        this.seekTo(this.mSaveSeekTime);
        if (this.mProxy != null) {
            this.mProxy.onPrepared(mp);
        }
        if (this.mPauseDuringPreparing) {
            this.pauseAndDispatch(this.mProxy);
            this.mPauseDuringPreparing = false;
        }
    }

    public void pauseAndDispatch(HTML5VideoViewProxy proxy) {
        this.pause();
        if (proxy != null) {
            proxy.dispatchOnPaused();
        }
    }

    public void enterFullScreenVideoState(int layerId, HTML5VideoViewProxy proxy, WebView webView) {
    }

    public boolean isFullScreenMode() {
        return false;
    }

    public void decideDisplayMode() {
    }

    public boolean getReadyToUseSurfTex() {
        return false;
    }

    public SurfaceTexture getSurfaceTexture() {
        return null;
    }

    public void deleteSurfaceTexture() {
    }

    public int getTextureName() {
        return 0;
    }

    public boolean getPlayerBuffering() {
        return this.mPlayerBuffering;
    }

    public void setPlayerBuffering(boolean playerBuffering) {
        this.mPlayerBuffering = playerBuffering;
        this.switchProgressView(playerBuffering);
    }

    public void switchProgressView(boolean playerBuffering) {
    }

    public static class TimeupdateTask
    extends TimerTask {
        public HTML5VideoViewProxy mProxy;

        public TimeupdateTask(HTML5VideoViewProxy proxy) {
            this.mProxy = proxy;
        }

        public void run() {
            this.mProxy.onTimeupdate();
        }
    }
}

