/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.util.Log;
import android.webkit.CallbackProxy;
import android.webkit.SearchBox;
import android.webkit.WebViewCore;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchBoxImpl
implements SearchBox {
    public static final String TAG = "WebKit.SearchBoxImpl";
    public static final String JS_INTERFACE_NAME = "searchBoxJavaBridge_";
    public static final String JS_BRIDGE = "(function(){if (!window.chrome) {  window.chrome = {};}if (!window.chrome.searchBox) {  var sb = window.chrome.searchBox = {};  sb.setSuggestions = function(suggestions) {    if (window.searchBoxJavaBridge_) {      window.searchBoxJavaBridge_.setSuggestions(JSON.stringify(suggestions));    }  };  sb.setValue = function(valueArray) { sb.value = valueArray[0]; };  sb.value = '';  sb.x = 0;  sb.y = 0;  sb.width = 0;  sb.height = 0;  sb.selectionStart = 0;  sb.selectionEnd = 0;  sb.verbatim = false;}})();";
    public static final String SET_QUERY_SCRIPT = "if (window.chrome && window.chrome.searchBox) {  window.chrome.searchBox.setValue(%s);}";
    public static final String SET_VERBATIM_SCRIPT = "if (window.chrome && window.chrome.searchBox) {  window.chrome.searchBox.verbatim = %s;}";
    public static final String SET_SELECTION_SCRIPT = "if (window.chrome && window.chrome.searchBox) {  var f = window.chrome.searchBox;  f.selectionStart = %d  f.selectionEnd = %d}";
    public static final String SET_DIMENSIONS_SCRIPT = "if (window.chrome && window.chrome.searchBox) {   var f = window.chrome.searchBox;  f.x = %d;  f.y = %d;  f.width = %d;  f.height = %d;}";
    public static final String DISPATCH_EVENT_SCRIPT = "if (window.chrome && window.chrome.searchBox &&  window.chrome.searchBox.on%1$s) { window.chrome.searchBox.on%1$s(); }";
    public final List<SearchBox.SearchBoxListener> mListeners = new ArrayList<SearchBox.SearchBoxListener>();
    public final WebViewCore mWebViewCore;
    public final CallbackProxy mCallbackProxy;

    public SearchBoxImpl(WebViewCore webViewCore, CallbackProxy callbackProxy) {
        this.mWebViewCore = webViewCore;
        this.mCallbackProxy = callbackProxy;
    }

    @Override
    public void setQuery(String query) {
        String formattedQuery = this.jsonSerialize(query);
        if (formattedQuery != null) {
            String js = String.format(SET_QUERY_SCRIPT, formattedQuery);
            this.dispatchJs(js);
        }
    }

    @Override
    public void setVerbatim(boolean verbatim) {
        String js = String.format(SET_VERBATIM_SCRIPT, String.valueOf(verbatim));
        this.dispatchJs(js);
    }

    @Override
    public void setSelection(int selectionStart, int selectionEnd) {
        String js = String.format(SET_SELECTION_SCRIPT, selectionStart, selectionEnd);
        this.dispatchJs(js);
    }

    @Override
    public void setDimensions(int x, int y, int width, int height) {
        String js = String.format(SET_DIMENSIONS_SCRIPT, x, y, width, height);
        this.dispatchJs(js);
    }

    @Override
    public void onchange() {
        this.dispatchEvent("change");
    }

    @Override
    public void onsubmit() {
        this.dispatchEvent("submit");
    }

    @Override
    public void onresize() {
        this.dispatchEvent("resize");
    }

    @Override
    public void oncancel() {
        this.dispatchEvent("cancel");
    }

    public void dispatchEvent(String eventName) {
        String js = String.format(DISPATCH_EVENT_SCRIPT, eventName);
        this.dispatchJs(js);
    }

    public void dispatchJs(String js) {
        this.mWebViewCore.sendMessage(194, js);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSearchBoxListener(SearchBox.SearchBoxListener l) {
        List<SearchBox.SearchBoxListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSearchBoxListener(SearchBox.SearchBoxListener l) {
        List<SearchBox.SearchBoxListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.remove(l);
        }
    }

    public String jsonSerialize(String query) {
        JSONStringer stringer = new JSONStringer();
        try {
            stringer.array().value(query).endArray();
        }
        catch (JSONException e) {
            Log.w(TAG, "Error serializing query : " + query);
            return null;
        }
        return stringer.toString();
    }

    public void setSuggestions(String jsonArguments) {
        if (jsonArguments == null) {
            return;
        }
        String query = null;
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            JSONObject suggestionsJson = new JSONObject(jsonArguments);
            query = suggestionsJson.getString("query");
            JSONArray suggestionsArray = suggestionsJson.getJSONArray("suggestions");
            for (int i = 0; i < suggestionsArray.length(); ++i) {
                JSONObject suggestion = suggestionsArray.getJSONObject(i);
                String value = suggestion.getString("value");
                if (value == null) continue;
                suggestions.add(value);
            }
        }
        catch (JSONException je) {
            Log.w(TAG, "Error parsing json [" + jsonArguments + "], exception = " + je);
            return;
        }
        this.mCallbackProxy.onSearchboxSuggestionsReceived(query, suggestions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSuggestions(String query, List<String> suggestions) {
        List<SearchBox.SearchBoxListener> list = this.mListeners;
        synchronized (list) {
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                this.mListeners.get(i).onSuggestionsReceived(query, suggestions);
            }
        }
    }
}

