/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.webkit.WebViewDatabase;

public abstract class WebSyncManager
implements Runnable {
    public static final int SYNC_MESSAGE = 101;
    public static int SYNC_NOW_INTERVAL = 100;
    public static int SYNC_LATER_INTERVAL = 300000;
    public Thread mSyncThread;
    public String mThreadName;
    public Handler mHandler;
    public WebViewDatabase mDataBase;
    public int mStartSyncRefCount;
    public static final String LOGTAG = "websync";

    public WebSyncManager(Context context, String name) {
        this.mThreadName = name;
        if (context == null) {
            throw new IllegalStateException("WebSyncManager can't be created without context");
        }
        this.mDataBase = WebViewDatabase.getInstance(context);
        this.mSyncThread = new Thread(this);
        this.mSyncThread.setName(this.mThreadName);
        this.mSyncThread.start();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("doesn't implement Cloneable");
    }

    public void run() {
        Looper.prepare();
        this.mHandler = new SyncHandler(null);
        this.onSyncInit();
        Process.setThreadPriority(10);
        Message msg = this.mHandler.obtainMessage(101);
        this.mHandler.sendMessageDelayed(msg, SYNC_LATER_INTERVAL);
        Looper.loop();
    }

    public void sync() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeMessages(101);
        Message msg = this.mHandler.obtainMessage(101);
        this.mHandler.sendMessageDelayed(msg, SYNC_NOW_INTERVAL);
    }

    public void resetSync() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeMessages(101);
        Message msg = this.mHandler.obtainMessage(101);
        this.mHandler.sendMessageDelayed(msg, SYNC_LATER_INTERVAL);
    }

    public void startSync() {
        if (this.mHandler == null) {
            return;
        }
        if (++this.mStartSyncRefCount == 1) {
            Message msg = this.mHandler.obtainMessage(101);
            this.mHandler.sendMessageDelayed(msg, SYNC_LATER_INTERVAL);
        }
    }

    public void stopSync() {
        if (this.mHandler == null) {
            return;
        }
        if (--this.mStartSyncRefCount == 0) {
            this.mHandler.removeMessages(101);
        }
    }

    public void onSyncInit() {
    }

    public abstract void syncFromRamToFlash();

    public static class 1 {
    }

    public class SyncHandler
    extends Handler {
        public SyncHandler() {
        }

        public void handleMessage(Message msg) {
            if (msg.what == 101) {
                WebSyncManager.this.syncFromRamToFlash();
                Message newmsg = this.obtainMessage(101);
                this.sendMessageDelayed(newmsg, SYNC_LATER_INTERVAL);
            }
        }

        public /* synthetic */ SyncHandler(1 x1) {
            this();
        }
    }
}

